# 🍔 McDonald's Database Simulation (McDonald-s-DB)

Welcome to the **McDonald's Database Simulation Project**! This repository hosts a comprehensive simulation of a database system tailored for **McDonald's**, the renowned fast-food chain. The goal of this project is to create a realistic representation of McDonald's operations through a well-designed database schema, detailed entity relationships, and optimized queries.

## 👥 Contributors:
- **Vincenzo Bucciero**
- **Camilla De Martino**
- **Noemi Ruocco**

---

## 📚 Project Files:

- **McDonalds.pdf**: This document provides an overview of the McDonald's Database Simulation, offering insights into the project's goals, design principles, and data structures.
- **modello_concettuale.jpeg**: This file contains the **conceptual model** representing the high-level structure of the database.
- **modello_relazionale.jpeg**: This file contains the **relational model** depicting the detailed relationships and tables within the database.
- **popolamento.sql**: This SQL script file contains data population queries, enabling the simulation with sample data.
- **procedure.sql**: This file includes SQL procedures that define specific actions or operations within the database.
- **tabelle.sql**: This file contains the SQL statements for creating the necessary tables in the database.
- **trigger.sql**: This file contains SQL triggers that are executed automatically in response to specific events on a particular table or view.
- **vincoli_check.sql**: This file defines **check constraints** to enforce specific conditions on the data in the database.
- **viste.sql**: This file contains SQL queries defining **views**, providing simplified and meaningful perspectives on the underlying data.

---

## 🚀 How to Use:

### Clone the Repository:

```bash
git clone <repository_url.git>
cd McDonald-s-DB
```
---
# 🛠️: Database Setup:
* Create a new database in your preferred DBMS (MySQL, PostgreSQL, etc.).
* Execute the ```tabelle.sql``` script to create the necessary tables.
* Populate the database with sample data using the ```popolamento.sql``` script
* Run the ```trigger.sql``` script to set up triggers for automated actions.
* Execute the ```procedure.sql``` script to define specific database procedures.

# 🛂Exploring the Project:
* Refer to **McDonalds.pdf** for an in-depth understanding of the project's structure and objectives.
* Review the **conceptual model** in ```modello_concettuale.jpeg``` and the **relational model** in ```modello_relazionale.jpeg``` for visual representations of the database design.
* Utilize the **SQL views** defined in ```viste.sql``` for simplified data access.
* Contribute to the project by making enhancements, fixing issues, or proposing new features.

# 🤙Contributing:
We welcome contributions from the community! If you have ideas, bug fixes, or improvements to suggest, please follow these steps:

  * **Fork the repository and create your branch**: ```git checkout -b feature/your-feature```.
  * **Commit your changes**: ```git commit -m 'Add your feature'```.
  * **Push to the branch**: ```git push origin feature/your-feature```.
  * **Create a pull request, describing your changes in detail and explaining their purpose**.

Thank you for being a part of this exciting McDonald's Database Simulation project! Let's work together to create a robust and realistic representation of McDonald's database operations. 🍟🍔
