---
title: "The BIG List of Video Game Randomizers"
permalink: "randomizers"
snippet: "Exhaustive list of all known video game randomizers."
subtitle: "Exhaustive list of all known video game randomizers."
updatedate: 2024-05-13
---
Official Discord Community Server: **<https://discord.com/invite/YREMzGQ3gd>**

## ‼️ OPEN SOURCE ANNOUNCEMENT ‼️

GitHub repository: <https://github.com/video-game-randomizers/rando-list>

Read the [full announcement here](https://www.debigare.com/the-future-of-the-video-game-randomizer-list/)!

## New randomizers

This subset only shows recently added entries from the past 3 months, with the most recent ones on top, with the exclusion of obsolete ones.

- [Advance Wars 2: Black Hole Rising](https://feuniverse.us/t/aw2-self-randomizing-rom-complete/24788) (Self Randomizer)
- [Fire Emblem: The Binding Blade](https://feuniverse.us/t/fe6-self-randomizing-rom-complete/24920) (Self Randomizer)
- [Fire Emblem: The Blazing Blade](https://feuniverse.us/t/fe7-self-randomizing-rom-complete/24719) (Self Randomizer)
- [Metroid: Samus Returns](https://randovania.org/) (added to Randovania)
- [Ultrakill](https://github.com/TRPG0/ArchipelagoULTRAKILL) (ArchipelagoULTRAKILL) - Requires [Archipelago](https://archipelago.gg/)
- [Dragon's Dogma 2](https://www.nexusmods.com/dragonsdogma2/mods/611) (0xffa's)
- [Kid Chameleon](https://www.romhacking.net/hacks/7490/) (Level Randomizer)
- [Like a Dragon: Infinite Wealth](https://www.nexusmods.com/likeadragoninfinitewealth/mods/145) (Zoo's)
- [Lunacid](https://www.nexusmods.com/lunacid/mods/11) (Witchybun Albrekka's) - Requires [Archipelago](https://archipelago.gg/)
- [Might and Magic VI: The Mandate of Heaven / Might and Magic VII: For Blood and Honor](https://rekurs.io/mmrandomizer/) (Anerag's)
- [Persona 5 Royal](https://gamebanana.com/mods/502477) (Screenments's)
- [Pokémon Scarlet / Pokémon Violet](https://github.com/Gonzalooo/Scarlet-and-Violet-Randomizer) (Gonzalo's)
- [Star Wars: Dark Forces](https://github.com/The-MAZZTer/DarkForces) (Showcase) - Modding tool with bundled randomizer
- [Xenoblade Chronicles 3](https://github.com/RoccoDev/xc3fr-unlock-kit-balance) (Future Redeemed unlock kit balance editor) - Randomizes Art Unlock Kit locations
- [Oxide (Super Metroid hack) / Super Metroid: Redesign (Super Metroid hack) / Digital Cube (Super Metroid hack) / Super Metroid: Golden Dawn (Super Metroid hack)](https://randorandy.github.io/) (added to ironrusty's)
- [Tunic / Kirby's Dream Land 3 / Celeste 64: Fragments of the Mountain / Zork: Grand Inquisitor / Castlevania (Nintendo 64) / A Short Hike / Yoshi's Island](https://archipelago.gg/) (added to Archipelago)
- [Escape the Backrooms](https://www.nexusmods.com/escapethebackrooms/mods/20) (Reokin's)
- [King Arthur: Knight's Tale](https://github.com/GeorgieH/kakt-skill-tree-randomizer) (Skill Tree Randomizer) - Documentation in Wiki
- [Legend of Grimrock](https://www.nexusmods.com/grimrock/mods/148) (Random Dungeon)
- [Lies of P](https://www.nexusmods.com/liesofp/mods/117) (Item Randomizer)
- [Lies of P](https://www.nexusmods.com/liesofp/mods/118) (Shop Item Randomizer)
- [Lies of P](https://www.nexusmods.com/liesofp/mods/119) (Starting Weapon Randomizer)
- [Mystical Ninja Starring Goemon](https://github.com/abyssonym/mn64rando) (Ancient Cave Starring Goemon)
- [Palworld](https://github.com/DavidEMorales/PalworldOverworldSpawnRandomizer) (Overworld Spawn Randomizer)
- [Shogun Showdown](https://www.nexusmods.com/shogunshowdown/mods/6) (Enemy / Boss Randomizer)
- [Stardew Valley](https://www.nexusmods.com/stardewvalley/mods/20425) (Community Center Bundles Randomizer)
- [Starfield](https://www.nexusmods.com/starfield/mods/7514) (Enemy Weapon Randomizer)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/107301) (Alchemy Effects Randomizer, SKSE)
- [Cliffhanger Redux (Super Metroid hack) / Super Zero Mission (Super Metroid hack) / Metroid: The Blue Plague (Super Metroid hack)](https://randorandy.github.io/) (added to ironrusty's)


For older changes, you may consult the [full changelog](/randomizers-changelog/).

---

## All randomizers

### A Short Hike

- A Short Hike - _See at end of list: Multi-series, Connected worlds_

### ActRaiser

- [ActRaiser](https://github.com/Osteoclave/actraiser-randomizer) (Osteoclave's)

### Advance Wars

- [Advance Wars 2: Black Hole Rising](https://www.reddit.com/r/Advance_Wars/comments/k2kj5y/advance_wars_2_randomizer_program/) (Ephraim225's)
- [Advance Wars 2: Black Hole Rising](https://feuniverse.us/t/aw2-self-randomizing-rom-complete/24788) (Self Randomizer)

### Adventure

- Adventure - _See at end of list: Multi-series, Connected worlds_

### Adventure Island

- [Adventure Island II](https://micheilskeens.com/adventure-island-2-randomizer.php) (Micheil Skeens's)
- [Super Adventure Island II](https://github.com/abyssonym/sai2_rando) (abyssonym's)

### Aerobiz

- [Aerobiz Supersonic](https://github.com/stochaztic/aerobonkers) (AeroBonkers)

### Age of Empires

- [Age of Empires II: The Age of Kings / Age of Empires II (2013) / Age of Empires II: Definitive Edition](https://aok.heavengames.com/cgi-bin/forums/display.cgi?action=ct&f=28,44641,,365) (HyperRandom)
- [Age of Mythology: Extended Edition](https://steamcommunity.com/workshop/browse/?appid=266840&requiredtags%5B%5D=Random+Map+Scripts) (Steam Workshop - Map Scripts)

### Alien

- [Alien: Isolation](https://www.nexusmods.com/alienisolation/mods/47) (Mission Randomiser)

### Alundra

- [Alundra](https://github.com/Dinopony/alundra-randomizer) (Dinopony's)

### America's Army

- [America's Army](https://www.gamefront.com/games/america-s-army/file/weapon-randomizer-v1-5) (Weapon Randomizer)

### Amnesia

- [Amnesia: The Bunker](https://www.nexusmods.com/amnesiathebunker/mods/3) (Dog Tag Randomizer)

### An Untitled Story

- [An Untitled Story](https://www.dropbox.com/s/awy8mmf7eirwnm8/AnUntitledStory_Randomizer.zip?dl=0) (Mokesmoe's) - Support available on the [ESA Randomizer Discord server](https://discord.com/invite/kPMT8g3)

### Axiom Verge

- [Axiom Verge](https://pozzum.github.io/AxiomRandomizer/) (Pozzum's) - _OBSOLETE due to [official game integration](https://www.axiomverge.com/blog/announcing-axiom-verges-first-ever-free-content-update-in-open-beta-now) since [v1.48](https://store.steampowered.com/news/app/332200/view/2990940314641346963)_

### Azure Dreams

- [Azure Dreams](https://adrando.com/) (pro_grammar's)
- [Azure Dreams (Game Boy Color)](https://adrando.com/gbc/) (pro_grammar's)

### Baldur's Gate

- [Baldur's Gate / Baldur's Gate: Enhanced Edition / Baldur's Gate II: Shadows of Amn / Baldur's Gate II: Enhanced Edition / Baldur's Gate: Enhanced Edition Trilogy (mod)](https://www.gibberlings3.net/mods/items/item_rand/) (Enemy Randomizer)
- [Baldur's Gate / Baldur's Gate: Enhanced Edition / Baldur's Gate II: Shadows of Amn / Baldur's Gate II: Enhanced Edition / EasyTutu (mod) / Baldur's Gate Trilogy (mod) / Baldur's Gate: Enhanced Edition Trilogy (mod)](https://www.gibberlings3.net/mods/items/item_rand/) (Item Randomiser)
- [Baldur's Gate / Baldur's Gate: Enhanced Edition / Baldur's Gate II: Shadows of Amn / Baldur's Gate II: Enhanced Edition / EasyTutu (mod) / Baldur's Gate Trilogy (mod) / Baldur's Gate: Enhanced Edition Trilogy (mod)](https://www.gibberlings3.net/mods/tweaks/scs/) (Sword Coast Stratagems) - Mod collection that can randomize the maze in Watcher's Keep for Baldur's Gate II
- [Baldur's Gate II: Shadows of Amn](http://forums.blackwyrmlair.net/index.php?showtopic=1739) (Improved Anvil)
- [Baldur's Gate II: Enhanced Edition](http://forums.blackwyrmlair.net/index.php?showtopic=5326) (Improved Anvil Enhanced Edition)

### Banjo-Kazooie

- [Banjo-Kazooie](https://github.com/CyrusKashef/BK_Randomizer) (Giant Jigglypuff's)

### Bat Boy

- [Bat Boy (Demo)](https://github.com/alwaysintreble/Archipelago.BatBoy) (Archipelago.BatBoy) - Requires [Archipelago](https://archipelago.gg/)

### Blade of Darkness

- [Blade of Darkness](https://www.moddb.com/mods/gorentity-mod-2015) (Gorentity Mod with Random Enemy Creator)
- [Blade of Darkness](https://www.moddb.com/mods/metal-mod) (Metal Mod)

### Blasphemous

- [Blasphemous](https://www.nexusmods.com/blasphemous/mods/15) (Item and Enemy Randomizer)
- Blasphemous - _See at end of list: Multi-series, Connected worlds_

### Blaster Master

- [Blaster Master](https://www.speedrun.com/Blaster_Master/thread/8k04s) (Quantam's)

### Blood

- Blood - _See at end of list: Multi-series, Other_

### Bloodborne

- [Bloodborne](https://www.nexusmods.com/bloodborne/mods/15) (Enemy and Item Randomizer)

### Bloodstained

- [Bloodstained: Ritual of the Night](https://www.nexusmods.com/bloodstainedritualofthenight/mods/135) (Randomization Generator)
- [Bloodstained: Ritual of the Night](https://www.nexusmods.com/bloodstainedritualofthenight/mods/132) (Randomizer Tweaks and True Randomization Script)

### Bomberman

- [Bomberman Tournament](https://btrando.surge.sh/) (fusecv's)
- Bomberman Tournament - _See at end of list: Multi-series, Connected worlds_

### Borderlands

- [Borderlands 2 / Borderlands: The Pre-Sequel](https://github.com/BLCM/BLCMods) (BLCMods) - Mod repository containing multiple randomizers
- [Borderlands 2](https://www.se7ensins.com/forums/threads/borderlands-2-gun-item-randomizer-mod.1269836/) (shadowevil1996's Gun and Item Randomizer) - _OBSOLETE_
- [Borderlands: The Pre-Sequel](https://www.mediafire.com/file/gst4yd3gzuly36y/TPS+gun+randomizer.CT) (Turk's Gun Randomizer) - _OBSOLETE_

### Bravely

- [Bravely Default / Bravely Second: End Layer](https://github.com/MarvinXLII/BravelyRandomize) (MarvinXLII's)
- [Bravely Default II](https://github.com/MarvinXLII/BravelyRandomize2) (MarvinXLII's)

### Breath of Fire

- [Breath of Fire](https://github.com/pelador/Breath-of-Fire-Rando) (pelador's)
- Breath of Fire - _See at end of list: Multi-series, Other_
- [Breath of Fire II](https://github.com/abyssonym/painsong) (Painsong)
- [Breath of Fire III](https://github.com/abyssonym/vast_violence) (The Vast and the Violent)

### Broforce

- [Broforce](https://www.nexusmods.com/broforce/mods/22) (Alex Neargarder's)

### Captain Comic

- [The Adventures of Captain Comic](https://www.bamsoftware.com/comicrando/) (David Fifield's)

### Castlevania

#### Classic

- [Castlevania II: Simon's Quest](https://cv2r.kaelari.tech/) (BloodSweatAndCode's)
- [Castlevania II: Simon's Quest](https://abyssonym.wordpress.com/2017/10/27/castlevania-2-deadly-curse/) (Deadly Curse)
- [Castlevania III: Dracula's Curse](https://micheilskeens.com/castlevania-3-randomizer.php) (Micheil Skeens's)
- [Super Castlevania IV](https://www.romhacking.net/forum/index.php?topic=22494.msg346214#msg346214) (RedGuy's)

#### Metroidvania

- [Castlevania: Symphony of the Night (PlayStation / Saturn)](https://github.com/MottZilla/SOTN_AR) (Area Randomizer) - Includes a Richter converter for Wild Mouse's item randomizer, and a standalone Maria item randomizer
- [Castlevania: Symphony of the Night](https://raw.githubusercontent.com/josephstevenspgh/SotN-Relic-Randomizer/master/relicrando.py) (Relic Randomizer) - Requires [Python 2](https://www.python.org/downloads/) and [PS1 2352 image EDC/ECC recalculator](https://www.romhacking.net/utilities/1264/) - Game data to patch should be named `Castlevania - Symphony of the Night (USA) (Track 1).bin` - _OBSOLETE_
- [Castlevania: Symphony of the Night](https://sotn.io/) (Wild Mouse's)
- [Castlevania: Circle of the Moon](https://github.com/calm-palm/cotm-randomizer) (calm-palm's)
- [Castlevania: Harmony of Dissonance](https://hodrando.surge.sh/) (fusecv's)
- Castlevania: Harmony of Dissonance - _See at end of list: Multi-series, Connected worlds_
- [Castlevania: Aria of Sorrow](https://github.com/abyssonym/aos_rando) (Item Randomizer)
- [Castlevania: Aria of Sorrow](https://aosrando.surge.sh/) (Randomizer 2)
- [Castlevania: Aria of Sorrow](https://www.romhacking.net/forum/index.php?topic=35962.0) (Reprise)
- [Castlevania: Dawn of Sorrow / Castlevania: Portrait of Ruin / Castlevania: Order of Ecclesia](https://github.com/LagoLunatic/dsvrandom) (DSVania Randomizer)

#### 3D

- Castlevania (Nintendo 64) - _See at end of list: Multi-series, Connected worlds_

### Cave Story

- Cave Story / Cave Story+ - _See at end of list: Multi-series, Connected worlds_
- [Cave Story / Cave Story+](https://shru.itch.io/cave-story-randomizer) (shru's) - _OBSOLETE_
- [Cave Story](https://trashboxbobylev.itch.io/doukutsu-randamu) (Doukutsu Randamu)

### Celeste

- [Celeste](https://github.com/rhelmot/CelesteRandomizer) (rhelmot's)
- Celeste 64: Fragments of the Mountain - _See at end of list: Multi-series, Connected worlds_

### Chained Echoes

- [Chained Echoes](https://www.nexusmods.com/chainedechoes/mods/5) (Samupo's)

### Chex Quest

- Chex Quest / Chex Quest 3 (fangame) - _See at end of list: Multi-series, id Software engines_

### Chibi-Robo!

- [Chibi-Robo!](https://github.com/JBDdev/Chibi-Robo-Randomizer) (JBDdev's)

### Chrono

- [Chrono Trigger](https://github.com/abyssonym/eternalnightmare) (Eternal Nightmare)
- [Chrono Trigger](https://ctjot.com/) (Jets of Time)
- [Chrono Trigger](https://github.com/Anskiy/wingsoftime) (Wings of Time) - _OBSOLETE_

### Citadel

- [Citadel](https://stardot.org.uk/forums/viewtopic.php?f=1&t=14318) (Item Randomiser)

### Civilization

- [Civilization IV](https://forums.civfanatics.com/forums/civ4-map-scripts.182/) (CivFanatics - Map Scripts)
- [Civilization IV](https://www.gamefront.com/games/civilization-4/file/random-map-creator) (DragonEmperor's)
- [Civilization IV](https://www.gamefront.com/games/civilization-iv-warlords/file/random-map-script-v5-final) (low's)
- [Civilization IV: Colonization](https://forums.civfanatics.com/threads/mapscript-faireweather-py-for-colonization.293491/) (FaireWeather.py)
- [Civilization V](https://steamcommunity.com/sharedfiles/filedetails/?id=93509365) (Civ Randomizer)
- [Civilization V](https://forums.civfanatics.com/forums/civ5-map-scripts.402/) (CivFanatics - Map Scripts)
- [Civilization V](https://docs.google.com/document/d/1KiFTUkF8zxbRdN_AmQ-jIwdUAjnriO2wYNGBuqphcCM/edit) (HellBlazers Map Script)
- [Civilization V](https://forums.civfanatics.com/threads/wip-randomized-unique-components-and-traits.558135/) (Randomized Uniques)
- [Civilization V](https://steamcommunity.com/workshop/browse/?appid=8930&requiredtags%5B%5D=mapscripts) (Steam Workshop - Map Scripts)
- [Civilization VI](https://steamcommunity.com/sharedfiles/filedetails/?id=873663804) (Random Religions)
- [Civilization VI](https://forums.civfanatics.com/forums/civ6-maps-and-map-scripts.559/) (CivFanatics - Map Scripts)
- [Civilization VI](https://steamcommunity.com/workshop/browse/?appid=289070&searchtext=map+script) (Steam Workshop - Map Scripts) - [More](https://steamcommunity.com/workshop/browse/?appid=289070&searchtext=mapscript)
- [C-evo (fangame)](https://github.com/samboy/c-evo-mapgen) (Sam Trenholme's map_gen)

### Clash at Demonhead

- [Clash at Demonhead](https://micheilskeens.com/clash-at-demonhead-randomizer.php) (Micheil Skeens's)

### Code Vein

- [Code Vein](https://www.nexusmods.com/codevein/mods/409) (Party Randomizer 2) - Description in [old standalone version](https://www.nexusmods.com/codevein/mods/396)

### Commander Keen

- [Commander Keen: Invasion of the Vorticons (shareware)](https://davidgow.net/keen/randomiser.html) (David Gow's) - Randomizes Episode 1

### Contra

- [Contra (NES)](https://cdn.discordapp.com/attachments/1140465134066741309/1147430404438102057/ContraRandomizerSetup.exe) (Azeryn's) - [Documentation](https://sites.google.com/view/contrarandomizer/features)
- [Super C (NES)](https://spiderdave.me/nes/?c=70-Super-C-Randomizer) (SpiderDave's)

### Crash Bandicoot

#### Main

- Crash Bandicoot / Crash Bandicoot 2: Cortex Strikes Back / Crash Bandicoot: Warped / Crash Twinsanity - _See at end of list: Multi-series, Other_

#### Racing

- [Crash Tag Team Racing](https://github.com/CDRomatron/CTTRRando) (CDRomatron's)
- Crash Nitro Kart / Crash Tag Team Racing - _See at end of list: Multi-series, Other_

### Crazy Castle

- [The Bugs Bunny Crazy Castle](https://github.com/MaximumLance/Crazy-Castle-Randomizer) (MaximumLance's)

### CrossCode

- [CrossCode](https://github.com/CCDirectLink/CCItemRandomizer) (Item Randomizer)

### Crusader Kings

_Old versions of Paradox Development Studio games are available on Steam as betas. To unlock Crusader Kings II versions prior to 2.8.3.4, refer to [this official announcement](https://forum.paradoxplaza.com/forum/threads/changes-to-playing-previous-versions-of-pds-titles.1120883/)._

- [Crusader Kings II](https://forum.paradoxplaza.com/forum/threads/tool-crusader-kings-2-alternate-history-and-random-map-generator.880329/) (Alternate History and Random Map Generator) - _OBSOLETE_
- [Crusader Kings II](https://forum.paradoxplaza.com/forum/threads/tool-ck2-holy-fury-map-generator.1129166/) (Holy Fury Map Generator)

### Crystal Project

- [Crystal Project](https://github.com/LtSquigs/crystal-project-randomizer) (LtSquigs's) - _OBSOLETE_

### Crystalis

- [Crystalis](https://crystalisrandomizer.com/) (steve_hacks's)

### Custom Robo

- [Custom Robo](https://www.romhacking.net/utilities/1778/) (PoggieB's)

### Darius

- [Darius Twin](https://micheilskeens.com/darius-twin-randomizer.php) (Micheil Skeens's)

### Dark Cloud

- [Dark Cloud](https://www.reddit.com/r/DarkCloud/comments/g141j0/dark_cloud_chest_randomizer_v102_update_upcoming/) (Chest Randomizer) - Requires special emulator [PCSX2 v1.4.0](https://pcsx2.net/downloads/)
- [Dark Cloud](https://www.reddit.com/r/DarkCloud/comments/g6aqab/dark_cloud_1_enemy_randomizer_emulator/) (Enemy Randomizer) - Requires special emulator [PCSX2 v1.4.0](https://pcsx2.net/downloads/)
- [Dark Cloud 2](https://www.reddit.com/r/DarkCloud/comments/m4f253/dc2_introducing_dark_cloud_2_chest_randomizer/) - Requires special emulator [PCSX2 v1.4.0 or v1.6.0](https://pcsx2.net/downloads/) (Chest Randomizer)

### Dark Souls

_A game downgrade to the last version released before 2022-01-23 may be required for some of these randomizers. For Dark Souls III, this would be application v1.15 with regulation v1.35._

- [Dark Souls: Prepare to Die Edition / Dark Souls: Remastered](https://www.nexusmods.com/darksouls/mods/1407) (Enemy Randomizer)
- [Dark Souls: Prepare to Die Edition / Dark Souls: Remastered](https://www.nexusmods.com/darksoulsremastered/mods/165) (Fog Gate Randomizer)
- [Dark Souls: Prepare to Die Edition / Dark Souls: Remastered](https://github.com/HotPocketRemix/DarkSoulsItemRandomizer) (Item Randomizer)
- [Dark Souls: Prepare to Die Edition / Dark Souls: Remastered](https://github.com/Poppyanimal/Paramdomizer) (Paramdomizer)
- [Dark Souls: Remastered](https://www.nexusmods.com/darksoulsremastered/mods/255) (Roguelike Souls - The Binding of Lordran)
- [Dark Souls II: Scholar of the First Sin](https://www.nexusmods.com/darksouls2/mods/743) (Item Location Randomizer) - _OBSOLETE_
- [Dark Souls II: Scholar of the First Sin](https://www.nexusmods.com/darksouls2/mods/774) (Item Randomizer REMIX
- [Dark Souls II: Scholar of the First Sin](https://www.nexusmods.com/darksouls2/mods/1108) (Ran-door-mizer)
- [Dark Souls II: Scholar of the First Sin](https://www.nexusmods.com/darksouls2/mods/1163) (Scrambler)
- [Dark Souls III](https://www.nexusmods.com/darksouls3/mods/484) (Enemy Randomizer)
- [Dark Souls III](https://www.nexusmods.com/darksouls3/mods/551) (Fog Gate Randomizer)
- [Dark Souls III](https://www.nexusmods.com/darksouls3/mods/298) (Irregulator)
- [Dark Souls III](https://www.nexusmods.com/darksouls3/mods/241) (Item Randomiser and Auto-Equip)
- [Dark Souls III](https://www.nexusmods.com/darksouls3/mods/361) (Static Item and Enemy Randomizer)
- [Dark Souls III](https://www.nexusmods.com/darksouls3/mods/318) (StraySouls) - Randomizing bosses may generate unwinnable games - _OBSOLETE_
- Dark Souls III - _See at end of list: Multi-series, Connected worlds_

### Darkest Dungeon

- [Darkest Dungeon](https://cdn.discordapp.com/attachments/1140465134066741309/1147430562450116648/ddrand-v0.2.0-x86_64-windows-msvc.zip) (ddrand)
- [Darkest Dungeon](https://github.com/TheUnlocked/DarkestDungeonRandomizer/releases) (TheUnlocked's)

### Dead Rising

- [Dead Rising](https://drive.google.com/file/d/1K5cZ2aqDa588gC7hPnROr8fQQA14E1NL/view) (DrunkWario's)
- [Dead Rising 2: Off the Record](https://www.nexusmods.com/deadrising2offtherecord/mods/23) (Fairy With a Pan's)

### Demon's Souls

- [Demon's Souls](https://www.nexusmods.com/demonssouls/mods/22) (Item Randomiser)

### Deus Ex

- [Deus Ex / Lay D Denton (mod) / GMDX (mod) / Revision (mod) / HX (mod) / Vanilla? Madder (mod)](https://github.com/Die4Ever/deus-ex-randomizer/) (Die4Ever's)

### Diablo

- [Diablo II](https://github.com/tlentz/d2modmaker) (D2 Mod Maker) - Modding tool with bundled randomizer
- [Diablo II](https://twitter.com/SunbeamX11/status/1383417309201453058) (Sunbeam's) - Support available on [Sunbeam's Discord server](https://discord.com/invite/K9AeByXyMu)
- [Diablo II: Resurrected](https://github.com/mapron/d2modgen) (Mod generator) - Modding tool with bundled randomizer

### Dicey Dungeons

- [Dicey Dungeons](https://xangelmoonx.itch.io/random-equipment) (Random Equipment)

### Digimon

- [Digimon World](https://github.com/meekrhino/digimon_world_randomizer) (meekrhino's)
- [Digimon World 2](https://discord.com/invite/rtFMVyZkbY) (GlorySeeker's) - Discord account required - Located in the #tool-releases channel
- [Digimon World 3](https://www.romhacking.net/utilities/1788/) (markisha64's)
- [Digimon Story Cyber Sleuth: Complete Edition](https://gamebanana.com/mods/369682) (zeak6464's) - [Source code](https://github.com/zeak6464/Digimon-Cyber-Sleuth-Mods)

### Divinity

- [Divinity: Original Sin 2](https://www.nexusmods.com/divinityoriginalsin2/mods/110) (Enemy Randomization) - Also on [Steam Workshop](https://steamcommunity.com/sharedfiles/filedetails/?id=1155733310)
- [Divinity: Original Sin 2 - Definitive Edition](https://www.nexusmods.com/divinityoriginalsin2definitiveedition/mods/9) (Enemy Randomization) - Also on [Steam Workshop](https://steamcommunity.com/sharedfiles/filedetails/?id=1499465417)

### DLC Quest

- DLC Quest - _See at end of list: Multi-series, Connected worlds_

### Dokapon

- [Dokapon Kingdom](http://ngplus.net/index.php?/files/file/53-dokapon-kingdom-randomizer/) (X Kirby's)

### Donkey Kong

#### Classic

- [Donkey Kong](https://www.donkeykonghacks.net/) (Randomized Edition)

#### Country

- [Donkey Kong Country / Donkey Kong Country 2: Diddy's Kong Quest](https://www.twitch.tv/rainbowsprinklez/about) (DKC Randomizer / DKC Entrance Rando / DKC2 Entrance Randomizer) - Located under ROM Hacks - DKC Randomizer randomizes animal buddies and enemies and requires an NA 1.0 ROM - Partial [source code](https://github.com/mike19283?tab=repositories)
- [Donkey Kong Country 3: Dixie Kong's Double Trouble](https://github.com/pozzum/DKC3Randomizer/releases) (Pozzum's)
- Donkey Kong Country 3: Dixie Kong's Double Trouble - _See at end of list: Multi-series, Connected worlds_
- [Donkey Kong 64](https://dk64randomizer.com/) (2dos's, 2021)
- [Donkey Kong 64](https://drive.google.com/file/d/1H21m7tiKPqRYNRh2O2R-KRcMT6nuyUJZ/view) (Loading Zone Randomizer) - Requires special emulator [BizHawk](https://tasvideos.org/BizHawk) - _OBSOLETE_

#### Racing

- [Diddy Kong Racing](https://acastelli.com/dkr/hacks/) (acastelli's) - Located under Randomizer

### Doom

- Doom (Ultimate) / Doom II / Final Doom / Harmony (fangame) - _See at end of list: Multi-series, id Software engines_
- [Doom (Ultimate) / Doom II / Final Doom](https://www.doomworld.com/forum/topic/106432-vdp-monsterrandomizer-updated-august-12th/) (Vanilla Doom Plus)
- [Doom (Ultimate) / Doom II](https://forum.zdoom.org/viewtopic.php?f=19&t=45378) (ORO-RANDOM-DOOM) - _OBSOLETE_
- [Doom (Ultimate) / Doom II](https://web.archive.org/web/20040404021558/http://www.doomworld.com/slige/) (SLIGE) - _OBSOLETE_
- [Doom (Ultimate) / Doom II](https://www.doomworld.com/forum/topic/112713-v104-vandomizer-a-vanilla-randomizer-for-gzdoom/) (Vandomizer)
- Doom (Ultimate) / Doom II - _See at end of list: Multi-series, Connected worlds_
- [Doom II / Final Doom](https://gitlab.com/andwj/populate) (The Populator)
- [Doom II](https://samiam.org/obhack/old/slump/slump.html) (SLUMP) - _OBSOLETE_
- [Doom Eternal](https://www.nexusmods.com/doometernal/mods/170) (Enemy Randomizer)
- [Doom Eternal](https://www.nexusmods.com/doometernal/mods/924) (Horde Mode Randomizer)

### Double Dragon

- [Double Dragon II: The Revenge (NES)](https://micheilskeens.com/double-dragon-2-randomizer.php) (Micheil Skeens's)

### Dragon Quest

#### Main

- [Dragon Quest](https://www.romhacking.net/utilities/1147/) (Catastrophe's) - _OBSOLETE_
- [Dragon Quest](https://github.com/mcgrew/dwrandomizer) (mcgrew's)
- [Dragon Quest II: Luminaries of the Legendary Line](https://github.com/gameboy9/DW2Randomizer) (gameboy9's)
- [Dragon Quest I&II (Super NES)](https://github.com/gameboy9/DQ12SFCRando) (gameboy9's)
- [Dragon Quest III: The Seeds of Salvation](https://github.com/Endymionls/DW3Randomizer) (Endymionls's)
- [Dragon Quest III: The Seeds of Salvation](https://github.com/gameboy9/DW3Randomizer) (gameboy9's) - _OBSOLETE_
- [Dragon Quest III: The Seeds of Salvation (Super NES)](https://cleartonic.net/dq3hf/dq3hf.html) (Heavenly Flight)
- [Dragon Quest IV: Chapters of the Chosen](https://github.com/gameboy9/DW4RandoHacker) (RandoHacker)
- [Dragon Quest VIII: Journey of the Cursed King (3DS)](https://github.com/playinful/DQ8-Rando) (playinful's)

#### Monsters

- [Dragon Quest Monsters 2: Cobi's Journey / Dragon Quest Monsters 2: Tara's Adventure](https://www.woodus.com/forums/index.php?/topic/36046-dragon-warrior-monsters-2-randomizer/) (Bynine's) - _OBSOLETE_
- [Dragon Quest Monsters 2: Cobi's Journey / Dragon Quest Monsters 2: Tara's Adventure](https://cowness.net/DWM2R/) (TheCowness's)

### Dragon's Dogma

- [Dragon's Dogma: Dark Arisen](https://www.nexusmods.com/dragonsdogma/mods/670) (Bitterblack Isle Randomizer)
- [Dragon's Dogma 2](https://www.nexusmods.com/dragonsdogma2/mods/611) (0xffa's)

### DuckTales

- [DuckTales](https://micheilskeens.com/duck-tales-randomizer.php) (Micheil Skeens's)

### Duke Nukem

- [Duke Nukem 3D](https://forums.duke4.net/topic/7246-map-order-randomizer/) (Map Order Randomizer) - _OBSOLETE_
- Duke Nukem 3D - _See at end of list: Multi-series, Other_

### EarthBound

- [EarthBound Beginnings](https://forum.starmen.net/forum/Community/PKHack/EarthBound-Zero-Randomizer-Updated-9-6-14) (Agent Ape's)
- [EarthBound](https://github.com/abyssonym/bizarre_dimension) (Bizarre Dimension) - _OBSOLETE_
- [EarthBound](https://earthbound.app/) (Chaz's)
- [EarthBound](https://pkscramble.com/) (PK Scramble)
- [EarthBound](https://secure.fangamer.com/forum/Community/PKHack/EarthBound-Reshuffler-2-0) (Rydel's Reshuffler) - _OBSOLETE_
- [EarthBound](https://earthboundcentral.com/reshuffler/) (Tomato's Reshuffler) - _OBSOLETE_
- [Mother 3](https://forum.starmen.net/forum/Community/PKHack/Mother-3-Randomizer-Version-0-0-1) (Lorenzooone's)

### Elden Ring 

- [Elden Ring](https://www.nexusmods.com/eldenring/mods/2683) (Elden Loot)
- [Elden Ring](https://www.nexusmods.com/eldenring/mods/3295) (Fog Gate Randomizer) - Unofficial [Randomizer Hints](https://www.nexusmods.com/eldenring/mods/4096) mod
- [Elden Ring](https://www.nexusmods.com/eldenring/mods/97) (Item and Param Randomiser)
- [Elden Ring](https://www.nexusmods.com/eldenring/mods/428) (Item and Enemy Randomizer) - Unofficial [Randomizer Hints](https://www.nexusmods.com/eldenring/mods/4096) mod
- [Elden Ring](https://www.nexusmods.com/eldenring/mods/982) (Summon Randomizer)

### Elemental

- [Fallen Enchantress](https://www.nexusmods.com/fallenenchantress/mods/55) (Randomized Monsters)

### Ender Lilies

- [Ender Lilies: Quietus of the Knights](https://github.com/Trexounay/EnderLilies.Randomizer) (Trexounay's)

### Escape the Backrooms

- [Escape the Backrooms](https://www.nexusmods.com/escapethebackrooms/mods/20) (Reokin's)

### Europa Universalis

_Old versions of Paradox Development Studio games are available on Steam as betas. To unlock Europa Universalis IV versions prior to 1.27, refer to [this official announcement](https://forum.paradoxplaza.com/forum/threads/changes-to-playing-previous-versions-of-pds-titles.1120883/)._

- [Europa Universalis IV](https://www.mediafire.com/file/3b5lb78vybzv2e0/EUIV_Map_Generator_2.0.zip/file) (Haftetavenscrap's Realistic Map Generator) - Paradox Interactive account required to access [original forum thread](https://forum.paradoxplaza.com/forum/threads/mod-cop-haftetavenscraps-realistic-map-generator.751689/)
- [Europa Universalis IV](https://steamcommunity.com/sharedfiles/filedetails/?id=602251342) (Random New World Improvements) - Paradox Interactive account required to access [original forum thread](https://forum.paradoxplaza.com/forum/threads/mod-random-new-world-improvements.907010/) - _OBSOLETE_
- [Europa Universalis IV](https://steamcommunity.com/sharedfiles/filedetails/?id=2786231870) (Random New World Improvements \[Updated]) - _OBSOLETE_
- [Europa Universalis IV](https://steamcommunity.com/sharedfiles/filedetails/?id=2484562172) (Randomizable World)
- [Europa Universalis IV](https://steamcommunity.com/sharedfiles/filedetails/?id=1852796430) (Religion Randomizer)

### Environmental Station Alpha

- [Environmental Station Alpha](https://www.speedrun.com/esalpha/resources) (Mokesmoe's) - Located under Tools

### Excitebike

- [Excitebike](https://github.com/gameboy9/ExciteBikeRando) (gameboy9's)

### Fable

- [Fable - The Lost Chapters](https://www.nexusmods.com/fablethelostchapters/mods/458) (Creature Generator Randomiser)
- [Fable Anniversary](https://www.nexusmods.com/fableanniversary/mods/43) (Creature Generator Randomiser)

### Factorio

- [Factorio](https://mods.factorio.com/?version=1.1&search_order=updated&query=randomize) (Official Mod Portal - Randomizers)
- Factorio - _See at end of list: Multi-series, Connected worlds_

### Fallout

- [Fallout: New Vegas](https://www.nexusmods.com/newvegas/mods/70845) (NVRNG) - Unofficial [debug weapon nerf mod](https://www.nexusmods.com/newvegas/mods/71211)
- [Fallout: New Vegas](https://www.nexusmods.com/newvegas/mods/53420) (Skill Check Randomizer) - Unofficial [patch for YUP mod](https://www.nexusmods.com/newvegas/mods/84349)
- [Fallout: New Vegas](https://www.nexusmods.com/newvegas/mods/74554) (World Randomizer)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/58541) (Bobblehead Randomizer)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/69102) (Crazy's Armor Overhaul and Randomizer)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/69248) (Crazy's Weapon Randomizer)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/9528) (Enemy Weapon Randomizer)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/21297) (Mechtechnal's) - Only mitigates sequence breaking
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/43223) (Random Weapon Stats)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/40446) (Randomized Enemy Weapons)
- [Fallout 4](https://www.nexusmods.com/fallout4/mods/44946) (Weapon Quality Randomizer)

### Faxanadu

- [Faxanadu](https://www.romhacking.net/utilities/1470/) (Notlob's)

### Final Fantasy

#### Main

- [Final Fantasy](https://www.romhacking.net/utilities/1519/) (Deep Dungeon) - _OBSOLETE_
- [Final Fantasy](https://finalfantasyrandomizer.com/) (Entroper's)
- Final Fantasy - _See at end of list: Multi-series, Connected worlds_
- [Final Fantasy (PSP)](https://github.com/gameboy9/FFRPSP) (gameboy9's)
- [Final Fantasy (pixel remaster)](https://github.com/gameboy9/FF1-PR-Rando) (gameboy9, leggystarscream & seeliefae's)
- [Final Fantasy II](https://borokobo.web.fc2.com/#FF2) (Fast Food Tour Randomizer) - Located under FF2
- [Final Fantasy II](https://github.com/PheonixMMKC777/Final_Fantasy_2_Randomizer) (PheonixMMKC777's)
- [Final Fantasy I & II: Dawn of Souls](https://abyssonym.wordpress.com/2017/10/12/ff-dawn-of-souls-approaching-chaos-randomizer/) (Approaching Chaos)
- [Final Fantasy I & II: Dawn of Souls](https://hmsjayne.com/) (HMS Jayne) - [Source code](https://github.com/hmsjayne/ffr-hmsj) - Randomizes Final Fantasy I
- [Final Fantasy III](https://github.com/nachoyacopu/ff3-randomizer) (Nacho Yacopu's) - If online version does not work, download the code and open `index.html`
- [Final Fantasy IV](https://github.com/abyssonym/beyond_babil) (Beyond Babil)
- [Final Fantasy IV](http://ff4fe.com/) (Free Enterprise)
- [Final Fantasy IV](https://www.romhacking.net/forum/index.php?topic=23126.0) (Roguelikeifyer)
- [Final Fantasy IV](https://ff4-lunarianshuffle.blogspot.com/) (The Lunarian Shuffle)
- [Final Fantasy IV (pixel remaster)](https://github.com/gameboy9/FF4FabulGauntlet) (Fabul Gauntlet)
- [Final Fantasy IV (pixel remaster)](https://github.com/gameboy9/FF4FalconDive/) (Falcon Dive)
- [Final Fantasy V](https://www.romhacking.net/hacks/957/) (Ancient Cave) - Original [English translation by Sky Render](https://www.mediafire.com/file/jjv80yb83ychmvt/ff5ace.zip/file) - Revised [English translation by FlamePurge](https://www.romhacking.net/hacks/7228/)
- [Final Fantasy V](https://bigbridge.studio/careerday/) (Career Day)
- [Final Fantasy V](https://github.com/abyssonym/grand_cross) (Grand Cross)
- [Final Fantasy V Advance](https://www.romhacking.net/forum/index.php?topic=18507.0) (Ancient Cave)
- [Final Fantasy V Advance](https://discord.com/invite/vvu3TXY) (DarkJDL's) - Discord account required - Located in the #randomizerfiles channel
- [Final Fantasy V Advance](https://www.dropbox.com/s/jq1vdp650j0bf8d/ffvarandomizer.zip?dl=0) (Spicy) - Randomizes job abilities - Mild output is normal randomization, while Extra Spicy output also randomizes job abilities independently between characters - Drag & drop original USA ROM on `randomizer.exe` to randomize
- [Final Fantasy V (pixel remaster)](https://github.com/gameboy9/FF5Abridged) (FF5Abridged)
- [Final Fantasy VI](https://github.com/abyssonym/beyondchaos) (Beyond Chaos) - _OBSOLETE_
- [Final Fantasy VI](https://github.com/FF6BeyondChaos/BeyondChaosRandomizer) (Beyond Chaos CE)
- [Final Fantasy VI](https://github.com/subtractionsoup/beyondchaos) (Beyond Chaos EX) - _OBSOLETE_
- [Final Fantasy VI / Brave New World (hack)](https://abyssonym.wordpress.com/2018/04/02/176/) (Beyond Chaos Gaiden)
- [Final Fantasy VI](https://web.archive.org/web/20201109152941/https://archive.codeplex.com/?p=ff6randomizer) (Dessyreqt's) - Extract `/releases/0/55609bb9-67b8-4ce4-8ff0-4673a618e35f` from the archive and rename it to its original file name `FinalFantasy6Randomizer.exe` to use
- [Final Fantasy VI](https://abyssonym.wordpress.com/2017/09/13/ff6-exit-rando/) (Exit Rando)
- [Final Fantasy VI](https://www.ff6worldscollide.com/) (Worlds Collide)
- [Final Fantasy VI (pixel remaster)](https://github.com/gameboy9/FF6KefkaRush) (Kefka Rush)
- [Final Fantasy VII](https://forums.qhimm.com/index.php?topic=19468.0) (Godo)
- [Final Fantasy VIII / Final Fantasy VIII Remastered](https://github.com/sleepeybunney/maelstrom) (Maelstrom)
- [Final Fantasy IX](https://forums.qhimm.com/index.php?topic=16285.0) (Meteor On Final Fantasy IX)
- [Final Fantasy IX](https://github.com/Druthulu/Stiltzkins-Bag) (Stiltzkin's Bag)
- [Final Fantasy IX](https://www.nexusmods.com/finalfantasy9/mods/30) (﻿VVs Randomizer)
- [Final Fantasy X](https://forums.pcsx2.net/Thread-FFXED-Final-Fantasy-X-Save-Editor) (FFXED) - Save editor that can randomize Sphere Grids
- [Final Fantasy X/X-2 HD Remaster](https://github.com/Stingerman06/Stingerman06_FFXRandomizerPack) (Final Fantasy X HD Randomizer Pack)
- [Final Fantasy X/X-2 HD Remaster](https://ffxrandomizer.zint.ch/) (FFX Randomizer)
- [Final Fantasy X/X-2 HD Remaster](https://github.com/shea093/FFX-2-Remaster-Randomizer) (FFX-2 Remaster Randomizer)
- [Final Fantasy XII The Zodiac Age](https://www.nexusmods.com/finalfantasy12/mods/72) (Bartz24's)
- [Final Fantasy XII The Zodiac Age](https://www.nexusmods.com/finalfantasy12/mods/224) (Open World Randomizer)
- [Final Fantasy XIII (Steam)](https://github.com/Bartz24/FF13Randomizer/releases) (Bartz24's, 2020)
- [Final Fantasy XIII (Steam) / Final Fantasy XIII-2 (Steam) / Lightning Returns: Final Fantasy XIII (Steam)](https://github.com/Bartz24/FFModdingWPF/releases) (Bartz24's, 2021) - Discord account required to download the required Nova Chrysalia mod manager

#### Tactics

- [Final Fantasy Tactics](https://github.com/abyssonym/rumble_chaos_crashdown) (Rumble Chaos Crashdown) - _OBSOLETE_
- [Final Fantasy Tactics](https://github.com/abyssonym/fftrctcr) (Rumble: Chaos: >>The Crashdown<< REMAKE)
- [Final Fantasy Tactics Advance](https://ffhacktics.com/smf/index.php?topic=12184.0) (Leonarth's)
- [Final Fantasy Tactics Advance](https://github.com/TojiKitten/FFTA-randomizer/releases) (TojiKitten's)

#### Other

- [Final Fantasy Mystic Quest](https://github.com/abyssonym/terriblesecret) (A Terrible Secret)
- [Final Fantasy Mystic Quest](https://www.ffmqrando.net/) (wildham's)
- Final Fantasy Mystic Quest - _See at end of list: Multi-series, Connected worlds_

### Final Fight

- [Final Fight AE (Final Fight hack)](https://gamehackfan.github.io/ffaee/) (FFAEE) - Game editor with bundled randomizer - _OBSOLETE due to the superior CPS2 version_
- [Final Fight AE CPS2 (Final Fight hack)](https://gamehackfan.github.io/ffaee-c2/) (FFAEE-C2) - Game editor with bundled randomizer

### Fire Emblem

- [(4, 6-9) Fire Emblem: Genealogy of the Holy War / Fire Emblem: The Binding Blade / Fire Emblem: The Blazing Blade / Fire Emblem: The Sacred Stones / Fire Emblem: Path of Radiance](https://github.com/lushen124/Universal-FE-Randomizer) (Yune)
- [(4) Fire Emblem: Genealogy of the Holy War](https://forums.serenesforest.net/index.php?/topic/80806-fire-emblem-4-randomizer/) (jespoke's) - _OBSOLETE_
- [(5) Fire Emblem: Thracia 776](https://github.com/dDShockTrooper/FE5-Randomiser-Releases) (dD_ShockTrooper's)
- [(5) Fire Emblem: Thracia 776](https://feuniverse.us/t/fire-emblem-5-randomiser/13003) (Kalieum's)
- [(6-8) Fire Emblem: The Binding Blade / Fire Emblem: The Blazing Blade / Fire Emblem: The Sacred Stones](https://www.dropbox.com/s/3ev9r5qy6ag726l/Camtech%27s%20FE7%20Randomizer%20Py1.zip?dl=1) (FERandomizer) - Original [release thread](https://forums.serenesforest.net/index.php?/topic/46886-ferandomizer-ver-py/) - _OBSOLETE_
- [(6-8) Fire Emblem: The Binding Blade / Fire Emblem: The Blazing Blade / Fire Emblem: The Sacred Stones](https://github.com/lushen124/Universal-GBA-FE-Randomizer-Windows) (Universal-GBA-FE-Randomizer-Windows) - _OBSOLETE_
- [(6) Fire Emblem: The Binding Blade](https://feuniverse.us/t/fe6-self-randomizing-rom-complete/24920) (Self Randomizer)
- [(7) Fire Emblem: The Blazing Blade](https://web.archive.org/web/20211103175902/https://forums.serenesforest.net/index.php?/topic/46885-ephraim-and-kloks-fe7-randomizer/) (Ephraim's) - Requires [Nintenlord's Event Assembler](https://forums.serenesforest.net/index.php?/topic/26913-nintenlords-hacking-utilities/) - _OBSOLETE_
- [(7) Fire Emblem: The Blazing Blade](https://feuniverse.us/t/fe7-self-randomizing-rom-complete/24719) (Self Randomizer)
- [(8) Fire Emblem: The Sacred Stones](https://feuniverse.us/t/fire-emblem-illusory-dungeon-a-fire-emblem-rogue-like-fe8/20754) (Illusory Dungeon)
- [(8) Fire Emblem: The Sacred Stones](https://forums.serenesforest.net/index.php?/topic/81571-fe8-self-randomizing-rom-v13/) (Self-Randomizing)
- [(9) Fire Emblem: Path of Radiance](https://feuniverse.us/t/fe9-character-editor-and-randomizer-v1-3-2/4979) (jespoke's)
- [(10) Fire Emblem: Radiant Dawn](https://github.com/LordMewtwo73/fe10-randomizer) (LordMewtwo's)
- [(11) Fire Emblem: Shadow Dragon](https://feuniverse.us/t/fe11-fe11-jesrandomizer-1-3/7253) (JesRandomizer)
- [(12) Fire Emblem: New Mystery of the Emblem](https://github.com/eLTehh/Raddomizer) (Raddomizer)
- [(13) Fire Emblem Awakening](https://github.com/rambon99/Fire-Emblem-Awakening-Randomizer) (rambon99's)
- [(14) Fire Emblem Fates](https://gbatemp.net/threads/wip-fire-emblem-fates-randomizer.452268/) (thane98's) - [Source code](https://github.com/thane98/3DSFE-Randomizer)
- [(16) Fire Emblem: Three Houses](https://feuniverse.us/t/fire-emblem-three-houses-randomizer/6043) (Blyvern's)
- [(16) Fire Emblem: Three Houses](https://feuniverse.us/t/fire-emblem-three-houses-randomizer-custom-build/9774) (Randomizer Custom Build)
- [(17) Fire Emblem Engage](https://gamebanana.com/tools/13023) (A Little \*Secret* Ingredient)
- [(17) Fire Emblem Engage](https://github.com/LordMewtwo73/feEngage-randomizer) (LordMewtwo73's) - _OBSOLETE_

### Fossil Fighters

- [Fossil Fighters](https://github.com/opiter09/Fossil-Fighters-Randomizer) (opiter09's)
- [Fossil Fighters: Champions](https://github.com/opiter09/Fossil-Fighters-Champions-Randomizer) (opiter09's)

### Freeway

- [Freeway](https://www.romhacking.net/utilities/720/) (Steve Englehardt's)

### Front Mission

- [Front Mission 5: Scars of the War](https://github.com/KhaleedSA/FM5RandomizerApp) (Khalid SA's)

### Game Dev Tycoon

- [Game Dev Tycoon](https://forum.greenheartgames.com/t/wip-platform-randomiser-alpha-0-0-5/9021) (Platform Randomiser) - Also on [Steam Workshop](https://steamcommunity.com/sharedfiles/filedetails/?id=296802750)
- [Game Dev Tycoon](https://forum.greenheartgames.com/t/rel-totalrandomiser-1-0-0/13359) (TotalRandomiser) - _Game downgrade required_

### Gato Roboto

- [Gato Roboto](https://github.com/CaptainDapper/GatoRobotoRandomizer/releases) (CaptainDapper's)

### Godzilla

- [Godzilla: Monster of Monsters](https://github.com/MaybeDatapod/godzilla-randomizer) (MaybeDatapod's)

### Goemon

- [Mystical Ninja Starring Goemon](https://github.com/abyssonym/mn64rando) (Ancient Cave Starring Goemon)

### Golden Sun

- [Golden Sun](https://web.archive.org/web/20210418021402/https://forum.goldensunhacking.net/index.php?action=downloads;sa=view;down=120) (MarvinXLII's) - _OBSOLETE_
- [Golden Sun](https://github.com/Valyssa/GS-Randomizer) (Valyssa's)
- [Golden Sun](https://web.archive.org/web/20210418021402/https://forum.goldensunhacking.net/index.php?action=downloads;sa=view;down=120) (MarvinXLII's) - _OBSOLETE_
- [Golden Sun: The Lost Age](https://gs2randomiser.com/) (Karanum's)
- [Golden Sun: The Lost Age](https://web.archive.org/web/20210401215000/http://forum.goldensunhacking.net/index.php?action=downloads;sa=view;down=122) (MarvinXLII's) - _OBSOLETE_

### Golf

- [Golf (NES)](https://github.com/gameboy9/golfRando/releases) (gameboy9's)
- [NES Open Tournament Golf](https://gist.github.com/TurbulentEddie/4e8fb8e52f64a99dfeb0) (Turbulent Eddie's) - Requires special emulator [FCEUX](https://sourceforge.net/projects/fceultra/files/Binaries/)

### Goof Troop

- [Goof Troop](https://github.com/GB127/GT-Rando/releases) (Niamek's)

### Grand Theft Auto

- [Grand Theft Auto: San Andreas](https://github.com/Parik27/SA.Rainbomizer) (Rainbomizer)

### Grandia

- [Grandia HD Remaster](https://github.com/Etsuna/GrandiaRandomizer) (Etsuna's)

### Gratuitous Space Battles

- [Gratuitous Space Battles](https://www.moddb.com/mods/gsb-galaxy-generator) (Galaxy generator)

### Hacx

- Hacx - _See at end of list: Multi-series, id Software engines_

### Hades

- [Hades](https://www.nexusmods.com/hades/mods/86) (ZebraFish's)

### Haiku, the Robot

- [Haiku, the Robot](https://github.com/Jarlyk/Haiku.Rando) (Jarlyk's) - Requires [Haiku.CoreModdingApi](https://github.com/Jarlyk/Haiku.ModdingApi) and [BepInEx](https://github.com/BepInEx/BepInEx)

### Half-Life

- [Half-Life](https://web.archive.org/web/20190926074638/http://www.valvetime.net/threads/randmap-and-its-whereabouts.169050/) (Randmap)
- [Half-Life 2](https://www.gamefront.com/games/half-life-2/file/half-life-2-random-map-creator) (Random Map Creator) - _Game downgrade required_

### Halo

- [Halo: Combat Evolved Anniversary (The Master Chief Collection)](https://github.com/Burnt-o/CEER) (Enemy Randomizer)
- [Halo 3 (The Master Chief Collection)](https://www.nexusmods.com/halothemasterchiefcollection/mods/2326) (NPC Weapon Randomzier) - Also on [Steam Workshop](https://steamcommunity.com/sharedfiles/filedetails/?id=2974714610)

### Hearts of Iron

_Old versions of Paradox Development Studio games are available on Steam as betas. To unlock Hearts of Iron IV versions prior to 1.5.4, refer to [this official announcement](https://forum.paradoxplaza.com/forum/threads/changes-to-playing-previous-versions-of-pds-titles.1120883/)._

- [Hearts of Iron IV](https://steamcommunity.com/sharedfiles/filedetails/?id=1687085898) (Drowse's)

### Hebereke

- Hebereke - _See at end of list: Multi-series, Other_

### Heretic

- Heretic / Hexen: Beyond Heretic - _See at end of list: Multi-series, id Software engines_
- Heretic - _See at end of list: Multi-series, Connected worlds_

### Hitman

- [Hitman World of Assassination](https://github.com/pawREP/ZHM5Randomizer) (ZHM5Randomizer)

### Hollow Knight

_Support is available on the [official Hollow Knight Discord server](https://discord.com/invite/hollowknight) in the #randomizer channel._

- [Hollow Knight](https://github.com/homothetyhk/RandomizerMod) (Randomizer 4) - [Multiplayer add-on](https://github.com/Shadudev/HollowKnight.MultiWorld) - Mod manager [Scarab](https://github.com/fifty-six/Scarab) for easy installation and updates
- Hollow Knight - _See at end of list: Multi-series, Connected worlds_

### Homeworld

- [Homeworld 2](https://www.moddb.com/mods/capturable-fleets-mod) (Capturable Fleets Mod)

### Hylics

- Hylics 2 - _See at end of list: Multi-series, Connected worlds_

### Inazuma Eleven

- [Inazuma Eleven / Inazuma Eleven 2: FireStorm / Inazuma Eleven 2: Blizzard / Inazuma Eleven 3: Team Ogre Attacks! (DS / 3DS)](https://mega.nz/file/9odwQYSC#vZppxUav1G0_v377P2au63O_WAN-RfvP-0t-O-Prypw) (Ultimate Randomizer) - Support and potential future versions available on the [Victory Road Discord server](https://discord.com/invite/3wKp5ZxA9N) in the #ie-randomizer channel
- [Inazuma Eleven GO Chrono Stones: Wildfire / Inazuma Eleven GO Chrono Stones: Thunderflash](https://www.mediafire.com/file/z9qmtis8cgwgfdw/Pixzer.rar/file) (Pixzer) - Support and potential future versions available on the [Victory Road Discord server](https://discord.com/invite/3wKp5ZxA9N) in the #ie-randomizer channel
- [Inazuma Eleven GO: Galaxy](https://github.com/Tiniifan/UltimateGalaxyRandomizer) (Tinifan's)

### Ion Fury

- Ion Fury - _See at end of list: Multi-series, Other_

### Ittle Dew

- [Ittle Dew 2+](https://github.com/Chris-Is-Awesome/Extra2DewMod) (Extra 2 Dew)

### Jade Cocoon

- [Jade Cocoon: Story of the Tamamayu](https://www.romhacking.net/utilities/1655/) (Meos's)

### James Bond

- [GoldenEye 007](http://www.shootersforever.com/forums_message_boards/viewtopic.php?t=7267) (K1lo's)

### Jet Set Radio

- [JSRF: Jet Set Radio Future](https://cdn.discordapp.com/attachments/249687933190275073/764597124938858516/default_rand3b3.xbe) (fusecv's) - [Documentation (for older version)](https://cdn.discordapp.com/attachments/249687933190275073/753102098417319968/Readme_2b8.txt) - Support and potential future versions available on the [JSRF Speedrunning Discord server](https://discord.com/invite/kFBgPnm) in the #modding channel

### Jetman

- [Solar Jetman](https://github.com/GB127/SJ-rando) (Niamek's)

### Joe & Mac

- [Joe & Mac: Caveman Ninja (Super NES)](https://micheilskeens.com/joe-and-mac-randomizer.php) (Micheil Skeens's)

### Jurassic Park

- [Jurassic Park (Super NES)](https://www.youtube.com/watch?v=Rq20h5S-KGE) (Yoshifanatic1's) - Located in video description

### Kartia

- [Kartia: The Word of Fate](https://github.com/Meerkov/Kartia) (Meerkov's)

### Keitai Denjū Telefang

- [Keitai Denjū Telefang: Power Version](https://sanqui.net/randomizer/#telefang) (Sanqui's) - [Source code](https://github.com/Sanqui/online-randomizer)

### Kid Chameleon

- [Kid Chameleon](https://www.romhacking.net/hacks/7490/) (Level Randomizer)

### Kid Icarus

- [Kid Icarus](https://www.romhacking.net/hacks/6447/) (Kid Randomicus) - [Source code](https://github.com/toddcblank/kid_randomicus)

### King Arthur (NeocoreGames)

- [King Arthur: Knight's Tale](https://github.com/GeorgieH/kakt-skill-tree-randomizer) (Skill Tree Randomizer) - Documentation in Wiki

### Kingdom Hearts

- [Kingdom Hearts Final Mix](https://github.com/Denhonator/KHPCSpeedrunTools) (KHPCSpeedrunTools) - Mod collection with bundled randomizer
- [Critical Mix (Kingdom Hearts Final Mix mod)](https://www.nexusmods.com/kingdomheartsfinalmix/mods/96) (Xendra's) - Old [PS2 version](https://docs.google.com/document/d/1eUGd_Bdf2PtMWP8JjbdddNeLknfWiij2F0lLXlE0lWc/edit) which requires special emulator
- [Kingdom Hearts: Chain of Memories](https://github.com/gaithern/Archipelago/releases) (gaithern's) - Requires [Archipelago](https://archipelago.gg/)
- [Kingdom Hearts II Final Mix](https://www.nexusmods.com/kingdomhearts2finalmix/mods/116) (Door Randomizer) - PS2 version requires special emulator - [Source code](https://github.com/MainMemory/KH2DoorRando)
- [Kingdom Hearts II Final Mix](https://tommadness.github.io/KH2Randomizer/) (Tommadness & thundrio's) - PS2 version requires special emulator
- [Kingdom Hearts II Final Mix](https://randomizer.valaxor.com/#/seed) (Valaxor's) - _OBSOLETE_
- Kingdom Hearts II Final Mix - _See at end of list: Multi-series, Connected worlds_
- [Kingdom Hearts Birth by Sleep Final Mix](https://github.com/Truthkey/Birth-by-Sleep-Randomizer) (Keytotruth's)
- [Kingdom Hearts III](https://kh3-randomizer-2ivd7.ondigitalocean.app/) (WaterKH's)

### Kirby

- [Kirby's Adventure](https://github.com/Aquova/KA-Rando) (Austin Bricker's)
- [Kirby: Nightmare in Dream Land](https://github.com/Aquova/KNDL-Rando) (Austin Bricker's)
- [Kirby Super Star](https://github.com/firubii/kss-randomizer) (firubii's)
- Kirby's Dream Land 3 - _See at end of list: Multi-series, Connected worlds_
- [Kirby 64: The Crystal Shards](https://www.youtube.com/watch?v=e8wVqrb0BUw) (jesusyoshi54's) - Located in video description
- [Kirby & The Amazing Mirror](https://github.com/HeyImTG/Amazing-Mirror-Randomizer) (HeyImTG's)
- [Kirby & The Amazing Mirror](https://github.com/Mips96/kamrandomizer) (Mips96's)
- [Kirby Star Allies](https://github.com/firubii/StarAlliesRandomizer) (firubii's)
- [Kirby and the Forgotten Land](https://gamebanana.com/mods/390471) (Toranix's)

### Kururin

- [KuruKuru Kururin](https://github.com/GirambQuamb/KuruKuruKurandomizer) (KuruKuruKurandomizer)

### La-Mulana

- [La-Mulana (The Maze of Galious fangame)](https://github.com/progre/lmorandomizer) (progre's)
- [La-Mulana (2011 remake)](https://github.com/thezerothcat/LaMulanaRandomizer) (thezerothcat's)
- [La-Mulana 2](https://github.com/Coookie93/LaMulana2Randomizer) (Coookie93's)

### Landstalker

- [Landstalker: The Treasures of King Nole](https://randstalker.ovh/) (Randstalker)
- Landstalker: The Treasures of King Nole - _See at end of list: Multi-series, Connected worlds_

### Left 4 Dead

- [Left 4 Dead 2](https://ssl.hehoe.de/mcs/index.php?display=tools) (Map Generator)

### Legacy of the Wizard

- [Legacy of the Wizard](https://github.com/MrStarbird/LotW-Randomizer/releases) (LadyStarbird's)

### Legend of Grimrock

- [Legend of Grimrock](https://www.nexusmods.com/grimrock/mods/148) (Random Dungeon)
- [Legend of Grimrock 2](https://www.grimrock.net/forum/viewtopic.php?f=23&t=18602) (7Soul's)

### Lies of P

- [Lies of P](https://www.nexusmods.com/liesofp/mods/117) (Item Randomizer)
- [Lies of P](https://www.nexusmods.com/liesofp/mods/118) (Shop Item Randomizer)
- [Lies of P](https://www.nexusmods.com/liesofp/mods/119) (Starting Weapon Randomizer)

### Like a Dragon

- [Yakuza: Like a Dragon](https://www.nexusmods.com/yakuzalikeadragon/mods/147) (Enemy Randomizer)
- [Like a Dragon: Infinite Wealth](https://www.nexusmods.com/likeadragoninfinitewealth/mods/145) (Zoo's)

### Lingo (Brenton Wildes)

- Lingo (Brenton Wildes) - _See at end of list: Multi-series, Connected worlds_

### Lisa

- [Lisa: The Pointless (fangame)](https://gamejolt.com/games/PointlessRandomizer/516789) (TrueCobalion's)

### Live A Live

- [Live A Live](https://github.com/PinkSwitch/Live-A-Live-Internal-Randomizer) (PinkSwitch's)

### Lizard

- [Lizard](https://rainwarrior.ca/lizard/lizard_of_random.html) (Official)

### Lost Kingdoms

- [Lost Kingdoms](https://github.com/BenjWolf/LKrandomizer) (Benjamin Wolf's)

### Lufia

- [Lufia II: Rise of the Sinistrals](https://abyssonym.wordpress.com/2017/09/12/lufia-2-terror-wave-new-randomizer/) (Terror Wave)
- Lufia II: Rise of the Sinistrals - _See at end of list: Multi-series, Connected worlds_

### Lunacid

- [Lunacid](https://www.nexusmods.com/lunacid/mods/11) (Witchybun Albrekka's) - Requires [Archipelago](https://archipelago.gg/)

### Mana

- [Secret of Mana](https://secretofmanaancientcave.blogspot.com/) (Mop's)
- [Sin of Mana (Trials of Mana hack)](http://ngplus.net/index.php?/files/file/28-seiken-densetsu-3-sin-of-mana/) (praetarius5018's) - Randomizer listed as separate download along with previous versions of the main hack

### Mario

#### 2D & 2D-like platformers

- [Super Mario Bros.](https://github.com/Coolcord/Level-Headed) (Level-Headed)
- [Super Mario Bros. 2](https://github.com/pepperpow/smb2-door-randomizer) (Door Randomizer)
- [Super Mario Bros. 2](https://github.com/macobra52/SMB2-Randomizer) (MaCobra52's)
- [Super Mario Bros. 2](https://github.com/tetraly/smb2r) (tetraly's)
- [Super Mario Bros. 3](https://sites.google.com/site/smb3randomizer/home) (Fred Coughlin's)
- [Super Mario Bros. 3](https://github.com/CujoIHSV/SMB3RR/releases) (Route Randomizer) - _OBSOLETE_
- [Super Mario Bros. 3](https://ssjtroly.github.io/smb3-nes-web-randomizer/) (ssjtroly's)
- Super Mario World - _See at end of list: Multi-series, Connected worlds_
- [Super Mario World](https://authorblues.github.io/smwrandomizer/) (authorblues's)
- [Super Mario Land 2: 6 Golden Coins / Super Mario Land 2 DX (hack)](https://sml2r.download/) (dadinfinitum's)
- [New Super Mario Bros. Wii](https://hbrohei.github.io/NSMRWii/) (HBroHei's)
- [Super Mario Bros. Wonder](https://github.com/MH13-YT/SMBW-Randomizer) (MH13's)

#### 3D platformers

- [Super Mario 64](https://github.com/aGlitch/Mario-64-Randomizer) (aGlitch's)
- [Super Mario 64](https://github.com/andrelikesdogs/sm64-randomizer) (Andre Meyer's)
- [Super Mario 64](https://romhacking.com/hack/sm64-randomizer) (Arthurtilly's)
- Super Mario 64 - _See at end of list: Multi-series, Connected worlds_
- [Super Mario Galaxy / Super Mario Galaxy 2](https://www.youtube.com/watch?v=4xXHTxTe9i8) (thegreatwaluigi's) - Located in video description

#### Racing

- [Mario Kart 64](https://www.romhacking.net/hacks/6409/) (Seohaine's)

#### RPGs

- [Super Mario RPG: Legend of the Seven Stars](https://github.com/abyssonym/smrpg_gbarp) (Gentle Beauty and Raw Power) - _OBSOLETE_
- [Super Mario RPG: Legend of the Seven Stars](https://randomizer.smrpgspeedruns.com/) (Open World)
- [Super Mario RPG (Switch)](https://github.com/ObsidianMakerDevelopment/super-mario-rpg-switch-randomizer) (ObsidianMaker's)
- [Paper Mario](https://www.youtube.com/watch?v=MWrXdQ_IiJw) (Black Pit) - Located in video description
- [Paper Mario](https://pm64randomizer.com/) (Icebound777, Clover and Pronyo's)
- [Paper Mario: The Thousand-Year Door](https://github.com/jdaster64/ttyd-infinite-pit) (Infinite Pit)
- [Paper Mario: The Thousand-Year Door](https://github.com/jdaster64/shufflizer) (Shufflizer)
- [Paper Mario: The Thousand-Year Door](https://www.dropbox.com/s/twt9121mhzti9w3/Misc_Randomizers.zip?dl=0) (Zephiles's Enemy HP and Item Drops Randomizers) - Requires a cheat engine supporting Gecko codes
- [Paper Mario: The Thousand-Year Door](https://www.speedrun.com/ttyd/resources) (Zephiles's Item and Loading Zones Randomizers) - Located under Tools as Miscellaneous Cheat Codes
- [Super Paper Mario](https://github.com/skawo/Super-Paper-Mario-Level-Editor-Randomizer) (Level Editor and Randomizer)
- [Mario & Luigi: Superstar Saga](https://github.com/jamesbrq/MLSSRandomizer) (jamesbrq's)

### Mass Effect

- [Mass Effect 2](https://me3tweaks.com/masseffect2randomizer/) (ME3Tweaks's)
- [Mass Effect 2 (Legendary Edition)](https://www.nexusmods.com/masseffectlegendaryedition/mods/1952) (ME3Tweaks's)

### Medabots

- [Medabots: Metabee / Medabots: Rokusho](https://github.com/STulling/Medabots-Randomizer) (STulling's)

### Mega Man

#### Classic

- [Mega Man](https://github.com/avvie/MegamanRandomizer) (avvie & JoJoCrusade's)
- [Mega Man 2](https://github.com/duckfist/MM2Random) (duckfist's) - _OBSOLETE_
- [Mega Man 2](https://github.com/squid-man/MegaMan2Randomizer2) (Randomizer 2)
- [Mega Man 2](https://www.romhacking.net/hacks/2294/) (Endless)
- [Mega Man 3 / Mega Man 4 / Mega Man 5](https://www.himaq5.xyz/rock5easily/ips.html) (Endless) - Located under ハック as ロックマン3 エンドレス for Mega Man 3, ロックマン4 エンドレス for Mega Man 4 and ロックマン5 エンドレス for Mega Man 5
- [Mega Man 4](https://borokobo.web.fc2.com/#Rock4) (NBoroKobo's) - Randomizes enemies and items - Located under ロックマン4 as ロックマン4ランダマイザー
- [Mega Man 6](https://web.archive.org/web/20180819085015/http://bin.smwcentral.net/u/24848/mm6-weapon-randomizer-v0.1.zip) (Raidenthequick's Weapon Randomizer)
- [Mega Man 7](https://borokobo.web.fc2.com/#Rock7) (Endless / Rainbow Session Randomizer) - Located under ロックマン7
- [Mega Man: The Wily Wars](https://github.com/MaximumLance/Wily-Wars-Randomizer) (MaximumLance's)

#### X

- Mega Man X3 / Zero Project (hack) - _See at end of list: Multi-series, Other_
- [Mega Man X6](https://www.romhacking.net/utilities/1414/) (Tweaks Patcher) - Modding tool with bundled randomizer

#### Battle Network

- [Mega Man Battle Network (Legacy Collection)](https://github.com/NecroCorey/Undernet-Trader) (Undernet-Trader)
- [Mega Man Battle Network 2](https://devonfae.github.io/NETCUST2/) (Network Customizer)
- [Mega Man Battle Network 3 White / Mega Man Battle Network 3 Blue](http://ngplus.net/index.php?/files/file/37-mega-man-battle-network-3-randomizer/) (X Kirby's)
- [Mega Man Battle Network 3 White](https://github.com/samfin/mmbn3-random) (samfin's) - _OBSOLETE_
- Mega Man Battle Network 3 Blue - _See at end of list: Multi-series, Connected worlds_
- [Mega Man Battle Network 5 Team Protoman / Mega Man Battle Network 5 Team Colonel / Mega Man Battle Network 6 Cybeast Gregar / Mega Man Battle Network 6 Cybeast Falzar](https://forums.therockmanexezone.com/mmbn-randomizer-t15216.html) (Prof. 9's)
- [Mega Man Battle Chip Challenge (Game Boy Advance)](https://melancholytree.com/mmbccr/) (Sam Donow's)

#### Unofficial

- [Rockman 3: Winternight (Mega Man 3 hack)](https://www.romhacking.net/hacks/4106/) (Endless Version)

### Meritous

- Meritous - _See at end of list: Multi-series, Connected worlds_

### Metal Gear

- [Metal Gear](https://github.com/wijnen/mg-random) (Objects)

### Metroid

#### Main

- Metroid / Super Metroid / Metroid Dread / Metroid: Samus Returns - _See at end of list: Multi-series, Connected worlds_
- [Metroid](https://www.romhacking.net/utilities/1437/) (Metrandomizer)
- [Metroid](https://www.romhacking.net/utilities/1257/) (Nestroid Randomizer)
- [Metroid](https://www.romhacking.net/utilities/1250/) (Netsrotti's) - _OBSOLETE_
- [Metroid](https://forum.metroidconstruction.com/index.php/topic,4952.0.html) (Planets) - Fan recreation with bundled randomizer
- [Metroid: Zero Mission](https://forum.metroidconstruction.com/index.php/topic,4559.0.html) (biospark's)
- [Metroid: Zero Mission](https://forum.metroidconstruction.com/index.php/topic,2765.0.html) (Quantum Deluxe Boogaloo)
- [Metroid II: Return of Samus](https://liamnajor.github.io/Metroid-2-Randomizer/) (liamnajor's)
- [Super Metroid](https://metroidconstruction.com/hack.php?id=357) (Arcade)
- [Super Metroid](https://www.dashrando.net/) (DASH)
- [Super Metroid](https://github.com/Dessyreqt/smrandomizer) (Dessyreqt's) - _OBSOLETE_
- [Super Metroid](https://web.archive.org/web/20201113040706/https://archive.codeplex.com/?p=smdoor) (Door Randomizer) - Extract `/releases/1/a60245ee-c346-4473-9cc9-2f19ae1e1095` from the archive and rename it to its original file name `SuperMetroidDoor0.3a.rar` to use
- [Super Metroid](https://itemrando.supermetroid.run/) (Item Randomizer) - _OBSOLETE_
- [Super Metroid](https://sm.samus.link/) (Item Randomizer Multiworld)
- [Super Metroid](https://maprando.com/) (Map Rando)
- [Super Metroid](https://metroidconstruction.com/resource.php?id=102) (Route Randomizer)
- [Super Metroid](https://randommetroidsolver.pythonanywhere.com/) (VARIA) - Conversion tool to [randomize Rotation (Super Metroid hack)](https://strotlog.github.io/randoxrotation/)
- [Super Metroid](https://worldrandomizer.com/) (World Randomizer)
- [Metroid Fusion](https://forum.metroidconstruction.com/index.php?topic=5376.0) (MFOR)

#### Prime

- Metroid Prime / Metroid Prime 2: Echoes - _See at end of list: Multi-series, Connected worlds_
- [Metroid Prime](https://github.com/BashPrime/metroid-prime-randomizer) (BashPrime's) - _OBSOLETE_
- [Metroid Prime](https://github.com/EthanArmbrust/new-prime-seed-generator) (Metroid Prime Seed Generator) - Requires [Claris's Randomizer v3.2](https://www.dropbox.com/s/s9nomgf5few8kyv/Randomizer.zip?dl=0) which may generate unwinnable games by itself - _OBSOLETE_
- [Metroid Prime 3: Corruption](https://discord.com/invite/WWGcay6) (gollop's) - Discord account required - Located in the #corruption-general channel
- [Metroid Prime Hunters](https://github.com/toiletman74/MPHrandomizer) (toiletman74's)

#### Super Metroid hacks

- [Hyper Metroid](https://github.com/Galamoz/HyperMetroidRandomizer) (Item Randomizer)
- [Project Base](https://github.com/Galamoz/ProjectBaseRandomizer) (Item Randomizer)
- [Subversion / Cryogenesis / Eris / Escape II / Recovery / Stardust / Nature / V I T A L I T Y / Ascent / Cliffhanger Redux / Super Zero Mission / Metroid: The Blue Plague / Oxide / Super Metroid: Redesign / Digital Cube / Super Metroid: Golden Dawn](https://randorandy.github.io/) (ironrusty's) - [Source code for the Subversion randomizer](https://github.com/SubversionRando/SubversionRando) - [Source code for the other randomizers](https://github.com/randorandy?tab=repositories)
- [Z-Factor](https://github.com/Galamoz/Z-Factor-ItemRandomizer) (Item Randomizer)

#### Fangames

- [AM2R](https://www.reddit.com/r/AM2R/) (Community Updates) - Fan updates with randomizer in pinned post - Unlock Random Game+ by either beating the game under 4 hours on Normal or Hard difficulty, or by entering cheat code \[UP]\[UP]\[DOWN]\[DOWN]\[LEFT]\[RIGHT]\[LEFT]\[RIGHT]\[ACCEPT]\[BACK] on the game selection screen - Options documented in `explanations.txt`
- AM2R - _See at end of list: Multi-series, Connected worlds_
- [Metroid The Threat Never Ends](https://github.com/DodoBirby/MTTNE-Randomiser) (DodoBirby's)

### Might and Magic 

- [Might and Magic VI: The Mandate of Heaven / Might and Magic VII: For Blood and Honor](https://rekurs.io/mmrandomizer/) (Anerag's)

### Milon

- [Milon's Secret Castle](https://micheilskeens.com/milons-secret-castle-randomizer.php) (Micheil Skeens's)

### Minecraft

_Old versions of Minecraft: Java Edition are available on Mojang's website, although note that such versions may contain critical security vulnerabilities. Direct download links can be found on [MCVersions](https://mcversions.net/) for convenience._

- [Minecraft: Java Edition](https://fasguy.net/minecraft_toolbox/info) (Fasguy's Minecraft Toolbox)
- [Minecraft: Java Edition](https://www.youtube.com/watch?v=3JEXAZOrykQ) (Loot Table Randomizer) - Located in video description - Requires [Python 3](https://www.python.org/downloads/) - _OBSOLETE_
- [Minecraft: Java Edition](https://www.spigotmc.org/resources/randomizer-1-13-1-16-x.77069/) (MotzlMotzt's) - _OBSOLETE_
- Minecraft: Java Edition - _See at end of list: Multi-series, Connected worlds_

### Monster Hunter

- [Monster Hunter: World](https://www.nexusmods.com/monsterhunterworld/mods/6124) (Kana Miyoshi's)
- [Monster Hunter: World](https://www.nexusmods.com/monsterhunterworld/mods/5415) (Randomizer Quests)

### Monster Party

- [Monster Party](https://micheilskeens.com/monster-party-randomizer.php) (Micheil Skeens's)

### Monster Rancher

- [Monster Rancher 2](https://www.romhacking.net/hacks/3482/) (Seasonal Shrine)

### Muse Dash

- Muse Dash - _See at end of list: Multi-series, Connected worlds_

### Necropolis

- [Necropolis](https://www.nexusmods.com/necropolis/mods/10) (Weapon Randomizer)

### Need for Speed

- [The Need for Speed](https://randtrack.sourceforge.net/) (RandTrack)
- [Need for Speed Carbon](https://nfsmods.xyz/mod/1568) (RaTT's) - Requires [NFS-VltEd](https://nfs-tools.blogspot.com/p/downloads.html)

### Neutopia

- [Neutopia](https://neutopia.run/) (konkers's)

### Nier

- [Nier: Automata](https://www.nexusmods.com/nierautomata/mods/565) (NAER)

### Ninja Gaiden

- [Ninja Gaiden (NES)](https://micheilskeens.com/ninja-gaiden-randomizer.php) (Micheil Skeens's)

### Nioh

- [Nioh 2](https://cdn.discordapp.com/attachments/1140465134066741309/1147430736178192385/Randomizer-304-1-1655766157.zip) (Enemy Randomizer, gumbenzoin's) - [Documentation archive](https://web.archive.org/web/20220621010638/https://www.nexusmods.com/nioh2/mods/304) - _Game downgrade to v1.28.6 required_ - _OBSOLETE_
- [Nioh 2](https://www.nexusmods.com/nioh2/mods/321) (Enemy Randomizer, rphii's)

### Noita

- [Noita](https://steamcommunity.com/workshop/browse/?appid=881100&searchtext=randomizer) (Steam Workshop - Randomizers)
- Noita - _See at end of list: Multi-series, Connected worlds_

### Octopath Traveler

- [Octopath Traveler](https://github.com/mastermind1919/OctopathBossRandomizer) (Boss Randomizer)
- [Octopath Traveler](https://github.com/MarvinXLII/OctopathTravelerJobRandomizer) (Job Randomizer)
- [Octopath Traveler II](https://github.com/MarvinXLII/OT2R) (MarvinXLII's)

### Ogre

- [Ogre Battle: The March of the Black Queen](https://www.ogrebattlerandomizer.com/) (spellzapp's)

### Ori

- [Ori and the Blind Forest: Definitive Edition](https://orirando.com/) (sigmasin & Eiko's) - [Source code](https://github.com/sparkle-preference/OriDERandomizer)
- [Ori and the Will of the Wisps](https://wotw.orirando.com/) (Eiko's) - [Source code](https://github.com/ori-community)

### Overcooked

- Overcooked! 2 - _See at end of list: Multi-series, Connected worlds_

### Pac-Man

- [Pac-Man World 2](https://drive.google.com/drive/folders/1eeb04B-GefSSXOvT8Xyc3DyZaoZrdFWa) (Montra's)

### Palworld

- [Palworld](https://github.com/DavidEMorales/PalworldOverworldSpawnRandomizer) (Overworld Spawn Randomizer)

### Parasite Eve

- [Parasite Eve II](https://drive.google.com/file/d/1E_OVyGw23XOAyMGlB-tkigvj1ruuktRN/view) (Randomized Eve II)

### Pathologic

- [Pathologic 2](https://www.nexusmods.com/pathologic2/mods/6) (District Randomizer Mod)

### Persona

- [Persona 5 Royal](https://gamebanana.com/mods/502477) (Screenments's)

### Phantasy Star

- [Phantasy Star II](https://github.com/MrStarbird/PSII-Randomizer/releases) (LadyStarbird's)
- [Phantasy Star IV: The End of the Millennium](https://github.com/MrStarbird/PStar4-Randomizer) (LadyStarbird's, 2018)
- [Phantasy Star IV: The End of the Millennium](https://sites.google.com/view/ps4-pd/home) (Profound Disorder)

### Pikmin

- [Pikmin](https://github.com/Minty-Meeo/Pikmin-1-Randomizer-Gecko) (Minty-Meeo's)
- [Pikmin 2](https://uckuiy4gtnjwosehfomppag.blogspot.com/2021/03/pikmin2-randomizer-v36.html) (kurumizome's)

### Pizza Tower

- [Pizza Tower](https://gamebanana.com/mods/432725) (Greenhead's)

### Plants vs. Zombies

- [PlantsVsZombies.NET (Plants vs. Zombies unofficial PC port)](https://github.com/Andree12/PVZ1-Randomizer) (Andree's) - Requires the Windows Phone version of the game and [Visual Studio Community 2019](https://learn.microsoft.com/en-us/visualstudio/releases/2019/release-notes)

### Pokémon

_Note that for readability, the core games in this series may be referred to one the following **Generation (Gen)** groupings instead of their full names:_

- _**I**: Pokémon Red Version (international) / Pokémon Blue Version (international) as **primary**, Pokémon Yellow Version: Special Pikachu Edition as **secondary**_
- _**II**: Pokémon Gold Version / Pokémon Silver Version as **primary**, Pokémon Crystal Version as **secondary**_
- _**III**: Pokémon Ruby Version / Pokémon Sapphire Version as **primary**, Pokémon Emerald Version as **secondary**, Pokémon FireRed Version / Pokémon LeafGreen Version as **remakes**_
- _**IV**: Pokémon Diamond Version / Pokémon Pearl Version as **primary**, Pokémon Platinum Version as **secondary**, Pokémon HeartGold Version / Pokémon SoulSilver Version as **remakes**_
- _**V**: Pokémon Black Version / Pokémon White Version as **primary**, Pokémon Black Version 2, Pokémon White Version 2 as **secondary**_
- _**VI**: Pokémon X / Pokémon Y as **primary**, Pokémon Omega Ruby / Pokémon Alpha Sapphire as **remakes**_
- _**VII**: Pokémon Sun / Pokémon Moon as **primary**, Pokémon Ultra Sun / Pokémon Ultra Moon as **secondary**, Pokémon: Let's Go Pikachu! / Pokémon: Let's Go Eevee! as **remakes**_
- _**VIII**: Pokémon Sword / Pokémon Shield as **primary**. Pokémon Legends: Arceus as **secondary**, Pokémon Brillant Diamond / Pokémon Shining Pearl as **remakes**_
- _**IX**: Pokémon Scarlet / Pokémon Violet as **primary**_

#### Core

_Speedchoice hacks are available on the [Pokemon Crystal Randomizer Central Discord server](https://discord.com/invite/nT56DbT) in the #resources channel._

- [(I-VII) Gens I to VI all / Gen VII primary & secondary](https://github.com/Ajarmar/universal-pokemon-randomizer-zx) (Universal Pokemon Randomizer ZX)
- [(I-V) Gens I to V all](https://pokehacks.dabomstew.com/randomizer/index.php) (Universal Pokemon Randomizer) - _OBSOLETE_
- [(I-III) Gens I to III all / Pokémon Red Speedchoice (hack) / Pokémon Crystal Speedchoice (hack) / Pokémon Emerald Speedchoice (hack) / Pokémon Emerald EX Speedchoice (hack)](https://github.com/NPO-197/PokemonTypeChartRandomizer) (Type Chart Randomizer)
- (I/III) Gen I primary / Gen III secondary - _See at end of list: Multi-series, Connected worlds_
- [(I) Gen I primary](http://artemis251.fobby.net/downloads/redblue/) (Artemis251's) - _OBSOLETE_
- [(I) Gen I primary](https://stump.io/itemrando/) (Key Item Randomizer)
- [(I) Gen I primary](https://github.com/NPO-197/PokemonRedBlue-RAMdomizer) (RAMdomizer) - _OBSOLETE_
- [(I) Gen I primary](https://code.google.com/archive/p/red-blue-randomizer/) (Ubuntaur's) - _OBSOLETE_
- [(I) Pokémon Red Version (international)](https://sanqui.net/randomizer/#pokered) (Sanqui's) - [Source code](https://github.com/Sanqui/online-randomizer)
- [(I) Pokémon Red Speedchoice (hack)](https://cdn.discordapp.com/attachments/356914936750014465/727678797947600926/rando-20200630-r1.1-c6.0-e1.1.4.zip) (Official) - Support and potential future versions available on the [Pokemon Crystal Randomizer Central Discord server](https://discord.com/invite/nT56DbT) in the #resources channel - [Source code](https://github.com/Dabomstew/UPR-Speedchoice)
- [(II-III) Gens II to III all](https://code.google.com/archive/p/pokemon-randomiser/) (pateandrew's) - _OBSOLETE_
- [(II) Gen II secondary / Pokémon Crystal Speedchoice (hack)](https://github.com/choatix/pokemon-crystal-map-randomizer) (Map Randomizer)
- [(II) Gen II secondary](https://github.com/xCrystal/crystal-randofuser/releases) (Randofuser)
- [(II) Pokémon Crystal Speedchoice (hack)](https://github.com/choatix/Pokemon-Crystal-Item-Randomizer) (Item Randomizer)
- [(III-V) Gen III secondary & remakes / Gen IV secondary & remakes / Pokémon White Version 2](https://warprandomizer.com/) (Universal Warp Randomizer) - [Source code](https://warprandomizer.com//randomizer_py.zip)
- [(III) Gen III all](https://code.google.com/archive/p/pokemon-reasonable-randomizer/) (Reasonable Randomizer)
- [(III) Pokémon FireRed Version / Pokémon CrystalDust (hack) / Pokémon Emerald Version](https://kittypboxx.github.io/GBAXG/) (GBAXG) - Requires special emulator
- [(III) Pokémon FireRed Speedchoice (hack)](https://github.com/pikalaxalt/firered-speedchoice/releases) (Official) - Included in hack release
- [(III) Gen III secondary](http://artemis251.fobby.net/downloads/emerald/) (Artemis251's) - _OBSOLETE_
- [(III) Gen III secondary](https://github.com/shinyquagsire23/pokeemerald-warprandomizer) (pokeemerald warp randomizer) - Requires decompiled version of original game - _OBSOLETE_
- [(III) Gen III secondary](https://ko-fi.com/s/b0c17d6f9d) (Pokémon Emerald Cross)
- [(III) Gen III secondary](https://www.pokecommunity.com/showthread.php?t=479406) (Pokemon Emerald Rogue)
- [(III) Pokémon Emerald Speedchoice (hack)](https://github.com/RevoSucks/pokeemerald-speedchoice/releases) (Official) - Included in hack release
- [(III) Pokémon Emerald EX Speedchoice (hack)](https://kittypboxx.github.io/Emerald-Ex-Map-Rando/dist/RomMaker/) (Map Rando) - Source code [part 1](https://github.com/KittyPBoxx/Emerald-Ex-Map-Rando), [part 2](https://github.com/KittyPBoxx/Emerald-Ex-Map-Rando)
- [(III) Pokémon Emerald EX Speedchoice (hack)](https://github.com/RevoSucks/pokeemerald-ex-speedchoice/releases) (Official) - Included in hack release
- [(IV-V) Gen IV remakes / Gen V secondary](https://github.com/adrienntindall/hgss-map-randomizer/releases) (Map Randomizer)
- [(IV) Gen IV secondary](https://github.com/SilverstarStream/pokemon-entrance-randomizer) (Entrance Randomizer)
- [(VI-VII) Gen VI all / Gen VII primary / Gen VII secondary](https://projectpokemon.org/home/forums/topic/34377-pk3ds-xyoras-rom-editor-amp-randomizer/) (pk3DS) - _OBSOLETE_
- [(VII-VIII) Gen VII remakes / Gen VIII primary](https://projectpokemon.org/home/forums/topic/48647-pknx-nintendo-switch-rom-editor-randomizer/) (pkNX)
- [(VIII) Gen VIII remakes](https://gamebanana.com/tools/8385) (Imposter's Ordeal) - Modding tool with bundled randomizer
- [(VIII) Gen VIII remakes](https://gamebanana.com/tools/7848) (SanGawku's) - _OBSOLETE_
- [(IX) Gen IX primary](https://github.com/Gonzalooo/Scarlet-and-Violet-Randomizer) (Gonzalo's)
- [(IX) Gen IX primary](https://github.com/XLuma/SV-Randomizer) (XLuma's) - _OBSOLETE_
- [(IX) Gen IX primary](https://gamebanana.com/tools/11402) (ZadenOwer's) - _OBSOLETE_

#### Side

- [(I) Pokémon Stadium](https://www.speedrun.com/pkmnstadium/thread/8ias0) (Randomizer and Editor)
- [(II) Pokémon Stadium 2](https://github.com/mike19283/Pokemon-Stadium-2-Randomizer) (RainbowSprinklez's)
- [(II) Pokémon Stadium 2](https://www.speedrun.com/pkmnstadium2/thread/9febd) (Rental Moveset Randomizer)
- [(III) Pokémon Colosseum / Pokémon XD: Gale of Darkness](https://github.com/rotobash/pokemon-ngc-rando) (Pokemon NGC Rando)
- [(III) Pokémon Colosseum / Pokémon XD: Gale of Darkness](https://www.youtube.com/watch?time_continue=10&v=zXOvLc1Zk9U) (Reclaimer Shawn's) - Located in video description - Requires special emulator [Dolphin 5.0 Windows x64 stable version](https://dolphin-emu.org/download/) - _OBSOLETE_
- [(III) Pokémon Colosseum / Pokémon XD: Gale of Darkness](https://projectpokemon.org/home/files/file/2463-gale-of-darkness-tool-osx-colosseum-tool/) (Gale of Darkness Tool + Colosseum Tool) - [Source code](https://github.com/PekanMmd/Pokemon-XD-Code) - _OBSOLETE_

#### Spin-offs

- [Pokémon Trading Card Game](https://github.com/anmart/UniversalCardGameRandomizer/releases) (Aroymart's)
- [Pokémon Trading Card Game](https://sanqui.net/randomizer/#poketcg) (Sanqui's) - [Source code](https://github.com/Sanqui/online-randomizer)
- [Pokémon Trading Card Game](https://github.com/pokepress/TCGRandomizer) (pokepress's)
- [Pokémon Trading Card Game](https://github.com/xCrystal/TCGRandomizer) (xCrystal's) - _OBSOLETE_
- [Pokémon Mystery Dungeon: Red Rescue Team](https://github.com/Suguivy/pmdrc-randomizer) (Suguivy's)
- [Pokémon Mystery Dungeon: Explorers of Sky](https://github.com/Aissurteivos/mdrngzer/releases) (mdrngzer)
- [Pokémon Mystery Dungeon: Explorers of Sky](https://projectpokemon.org/home/files/file/4235-skytemple-randomizer/) (SkyTemple Randomizer)
- [Pokémon Conquest](https://github.com/Deijin27/RanseiLink) (RanseiLink) - Game editor with bundled randomizer

#### Unofficial

- [Pokémon Gaia Version (Pokémon FireRed Version hack)](https://github.com/sphericalice/universal-pokemon-randomizer) (Universal Pokémon Randomizer - Pokémon Gaia Fork)
- [Pokémon Rejuvenation (fangame)](https://www.rebornevo.com/forums/topic/51568-rejuvenation-v12-challenge-pack/) (Challenge Pack)

### PowerSlave

- PowerSlave - _See at end of list: Multi-series, Other_

### Prey

- [Prey (2017)](https://www.nexusmods.com/prey2017/mods/67/) (Tsundereployer's)

### Project Wingman

- [Project Wingman](https://www.nexusmods.com/projectwingman/mods/355) (FalconLuma's) - Requires [Project Sicario Merger](https://sicario.modding.app/merger)

### Pseudoregalia

- [Pseudoregalia](https://www.nexusmods.com/pseudoregalia/mods/11) (spuds's)

### Psychonauts

- [Psychonauts](https://github.com/Akashortstack/PsychoRando) (PsychoRando)

### Punch-Out!!

- [Mike Tyson's Punch-Out!!](https://authorblues.github.io/mtporandomizer/) (authorblues's)

### Quake

- Quake / Quake II - _See at end of list: Multi-series, id Software engines_
- [Quake](https://www.reddit.com/r/quake/comments/q3d0mc/quake_randomizer_updated_for_the_quake_rerelease/) (RandoQ)
- [Quake II](https://www.nexusmods.com/quake2/mods/6) (Campaign Randomizer)

### Quest

- [Quest 64](https://hangedman.itch.io/merrow) (Merrow)

### Quest for Glory

- [Quest for Glory I: So You Want to Be a Hero (EGA)](https://github.com/Rainault/qfg1-randomizer) (Rainault's)

### Rabi-Ribi

- [Rabi-Ribi](https://wcko87.github.io/rabiribi-randomizer/) (wcko87's)

### Rad Racer

- [Rad Racer](https://github.com/gameboy9/RadRacerRando/releases) (gameboy9's)

### Raft

- Raft - _See at end of list: Multi-series, Connected worlds_

### Rain World

- [Rain World](https://steamcommunity.com/sharedfiles/filedetails/?id=2933916034) (Enemy Randomizer)

### Ratchet & Clank

- [Ratchet & Clank Collection](https://github.com/bordplate/rac1-randomizer) (bordplate's) - Randomizes Ratchet & Clank

### Rayman

- Rayman 3: Hoodlum Havoc - _See at end of list: Multi-series, Other_

### Record of Lodoss War

- Record of Lodoss War: Deedlit in Wonder Labyrinth - _See at end of list: Multi-series, Other_

### Resident Evil

- [Resident Evil (MediaKite) / Resident Evil 2 (Sourcenext) / Resident Evil 3: Nemesis (Sourcenext)](https://github.com/IntelOrca/biorand) (BioRand) - Requires [Classic REbirth](https://classicrebirth.com/index.php/downloads/)
- [Resident Evil (MediaKite)](https://www.moddb.com/mods/re-randomizer) (re_duke's) - Requires [Classic REbirth](https://classicrebirth.com/index.php/downloads/resident-evil-classic-rebirth/)
- [Resident Evil HD Remaster](http://benn-gaming.co.uk/rerandomizer.html) (Benn Powell's)
- [Resident Evil 2 (Sourcenext)](https://www.mediafire.com/file/zlxm2khdq8u2eqy/bio2_rndx_0.53.rar/file) (BIO2 RNDX) - Run with the `/L` command line argument for Leon
- [Resident Evil 2 (Sourcenext)](https://www.moddb.com/mods/re2randomizer) (Claire A - Leon B) - Requires [Classic REbirth](https://classicrebirth.com/index.php/downloads/resident-evil-2-classic-rebirth/)
- [Resident Evil 2 (2019)](http://benn-gaming.co.uk/re2randomizer.html) (Benn Powell's)
- [Resident Evil 3: Nemesis](https://www.youtube.com/watch?v=znhyPqqveJg) (PS Resident Evil 3 Tool) - Trainer that can randomize items - Located in video description
- [Resident Evil 3: Nemesis (Sourcenext)](https://www.moddb.com/mods/re3-randomizer) (New RE3 Randomizer) - Requires [Classic REbirth](https://classicrebirth.com/index.php/downloads/resident-evil-3-classic-rebirth/)
- [Resident Evil 3: Nemesis (EA Taiwanese)](https://discord.com/invite/cGuADyy4um) (PyramidK & re_fan_2236's) - Randomizes enemies and items - Discord account required - Located in the #💥☢☣downloads channel
- [Resident Evil 3 (2020)](https://www.nexusmods.com/residentevil32020/mods/158) (naitsircNH's)
- [Resident Evil 4](https://www.moddb.com/mods/re4randomizer) (Enemy/Merchant Randomizer)
- [Resident Evil 4](https://www.nexusmods.com/residentevil4/mods/210) (Item Randomizer)
- [Resident Evil 4](https://www.nexusmods.com/residentevil4/mods/99) (Rando Items 9000)
- [Resident Evil 4](https://www.nexusmods.com/residentevil4/mods/32) (UHD Ultimate Trainer) - Trainer that can randomize player inventory and merchant - _Game downgrade to v1.0.6 required_ - _OBSOLETE_
- [Resident Evil 5](https://residentevilmodding.boards.net/thread/14061/mercenaries-randomizer-mod) (The Mercenaries Randomizer Mod)

### Risk of Rain

- Risk of Rain 2 - _See at end of list: Multi-series, Connected worlds_

### Rogue Legacy

- [Rogue Legacy](https://github.com/ThePhar/RogueLegacyRandomizer) (Phar's)
- Rogue Legacy - _See at end of list: Multi-series, Connected worlds_

### RollerCoaster Tycoon 

- [OpenRCT2 (RollerCoaster Tycoon 2 fan recreation)](https://github.com/Die4Ever/rollercoaster-tycoon-randomizer) (Die4Ever's)

### Rome

_Old versions of Paradox Development Studio games are available on Steam as betas._

- [Imperator: Rome](https://forum.paradoxplaza.com/forum/threads/tool-shattered-world-mod-generator.1191906/) (Shattered World mod generator)

### SaGa

- [The Final Fantasy Legend](https://towerreversed.neocities.org/projects) (Chaoseum) - Located under ffl chaoseum
- [The Final Fantasy Legend](https://github.com/eclipseyy/FFLRandomizer) (eclipseyy's)
- [Final Fantasy Legend II](https://github.com/abyssonym/mighty_power) (Mighty Power)
- [Final Fantasy Legend III](https://www.romhacking.net/hacks/4351/) (Lunacy)

### Sailor Moon

- [Pretty Soldier Sailor Moon](https://www.romhacking.net/utilities/1600/) (PSSME) - Game editor with bundled randomizer

### Salt and Sanctuary

- [Salt and Sanctuary](https://www.reddit.com/r/saltandsanctuary/comments/c28z64/randomizer/) (coppie's)

### Scooby-Doo

- Scooby-Doo: Night of 100 Frights - _See at end of list: Multi-series, Other_

### Scourge of War

- [Scourge of War: Gettysburg](https://www.norbsoftdev.net/index.php/kunena/modifications/44306-gcm-singleplayer-campaign) (GCM Singleplayer Campaign) - Stripped-down [offline version](https://www.norbsoftdev.net/index.php/kunena/garnier-s-campaign-mod/63173-gcm-offline-scenario-generator-for-sp-mp)

### Secret of Evermore

- [Secret of Evermore](https://evermizer.com/) (Evermizer)
- Secret of Evermore - _See at end of list: Multi-series, Connected worlds_

### Sekiro: Shadows Die Twice

- [Sekiro: Shadows Die Twice](https://www.nexusmods.com/sekiro/mods/543) (Enemy and Item Randomizer)

### Sgt. Frog

- [Keroro RPG: Kishi to Musha to Densetsu no Kaizoku](https://www.crystalmods.com/index.php/game_mods/tales-of-keroro-english-patch/) (Dawnbomb's English Patch + Optional Randomizer)

### Shadow Warrior

- Shadow Warrior - _See at end of list: Multi-series, Other_

### Shadowrun

- [Shadowrun](https://github.com/Osteoclave/shadowrun-randomizer) (Osteoclave's)

### Shin Megami Tensei

- [Shin Megami Tensei](https://github.com/spannerisms/smt1rando) (spannerisms's)
- [Shin Megami Tensei III: Nocturne](https://github.com/nmarkro/Nocturne-Randomizer) (NMarkro's)
- [Shin Megami Tensei: Strange Journey](https://github.com/abyssonym/disastercycle) (Disaster Cycle)

### Shining

- [Shining Force](https://forums.shiningforcecentral.com/viewtopic.php?t=45800) (Join Order Randomizer)
- [Shining Force II](https://forums.shiningforcecentral.com/viewtopic.php?f=5&t=15502) (Scrambled Force II)
- [Shining Force II](https://www.romhacking.net/hacks/5809/) (Shining Chaos Prelude)
- [Shining Force III](https://sf3transftp.shiningforcecentral.com/Mods/) (Chaos) - More information in the [Shining Force III Translation Project Progress Report May 2022](https://sf3trans.shiningforcecentral.com/2022/05/11/progress-report-may-2022/)

### Shivers

- [Shivers](https://www.speedrun.com/shivers/resources) (GodlFire's) - Located under Tools - [Source code](https://github.com/GodlFire/Shivers-Randomizer-CSharp)
- Shivers - _See at end of list: Multi-series, Connected worlds_

### Shogun Showdown

- [Shogun Showdown](https://www.nexusmods.com/shogunshowdown/mods/6) (Enemy / Boss Randomizer)

### Sifu

- [Sifu](https://www.nexusmods.com/sifu/mods/296) (Randomizer Mod)

### Silent Hill

- [Silent Hill 2 / Silent Hill 3](https://github.com/JokieW/RandomHill) (Jokie's)
- [Silent Hill 4: The Room](https://github.com/HunterStanton/SilentHill4Randomizer) (Hunter Stanton's)

### Slaves to Armok: God of Blood

- [Dwarf Fortress](https://dffd.bay12games.com/file.php?id=3752) (Random plant creation script)
- [Dwarf Fortress](http://www.bay12forums.com/smf/index.php?topic=91255.0) (Random Raw Scripts)

### Slay the Spire

- Slay the Spire - _See at end of list: Multi-series, Connected worlds_

### Smash T.V.

- [Super Smash T.V.](https://micheilskeens.com/super-smash-tv-randomizer.php) (Micheil Skeens's)

### Snowboard Kids

- [Snowboard Kids](https://github.com/Stingerman06/A-Simple-SBK-Rando) (Stingerman06's)

### Soldier of Fortune

- [Soldier of Fortune II: Double Helix - Gold Edition](https://www.moddb.com/mods/sof2-rmg-expansion-and-sp-tweaks-mod) (RMG Expansion and SP Tweaks Mod)

### Solstice

- [Solstice](https://pbandpickle.com/) (pbandpickle's)

### Sonic the Hedgehog

#### 2D

- [Sonic the Hedgehog](https://forums.sonicretro.org/index.php?threads/random-levels-project.36646/) (Random Levels Project) - Randomizes Green Hill Zone
- [Sonic the Hedgehog (Master System)](https://ssjtroly.github.io/sonic1-sms-randomizer/) (ssjtroly's)
- [Sonic CD](https://gamebanana.com/mods/347942) (MainMemory's)
- [Sonic & Knuckles Collection](https://shc.zone/entries/expo2022/682) (MainMemory's)
- [Sonic Mania](https://github.com/junglechief87/Sonic-Mania-Randomizer-Custom-Game-Maker) (junglechief87's)

#### 3D

- [Sonic Adventure DX](https://github.com/Sora-yx/SADX-Randomizer) (Sora's)
- [Sonic Adventure 2](https://github.com/Ngolinvaux/SA2Randomizer) (Ngolinvaux's)
- Sonic Adventure 2 - _See at end of list: Multi-series, Connected worlds_
- [Shadow the Hedgehog](https://github.com/ShadowTheHedgehogHacking/ShadowRando) (MainMemory & dreamsyntax's)
- [Sonic the Hedgehog (2006)](https://github.com/Knuxfan24/Sonic-06-Randomiser-Suite) (Randomiser Suite)

#### Unofficial

- [Sonic Robo Blast 2 (fangame)](https://mb.srb2.org/threads/srb2randomizer.28983/) (SRB2Randomizer​)

### Soul Blazer

- [Soul Blazer](https://randoblazer.orphis.net/) (RandoBlazer) - Old [Windows binaries](https://github.com/LeHulk1/RandoBlazer/tree/master/Releases)
- [Illusion of Gaia](https://www.iogr.app) (DontBaguMe's)
- [Terranigma](https://www.terranigma.be/index.php?title=TerraFluky) (TerraFluky) - [Discord server](https://discord.com/invite/NkdvaHp) for support

### Spelunky

- [Spelunky 2](https://spelunky.fyi/mods/m/randomizer/) (Dregu's)

### SpongeBob SquarePants

- [SpongeBob SquarePants: Battle for Bikini Bottom (GameCube)](https://github.com/Cyb3RGER/bfbb_ap_world/) (BfBB AP World) - Requires [Archipelago](https://archipelago.gg/)
- SpongeBob SquarePants: Battle for Bikini Bottom (GameCube / Xbox / PS2) / The SpongeBob SquarePants Movie (GameCube / Xbox / PS2) - _See at end of list: Multi-series, Other_

### Spyro

- [Spyro the Dragon](https://www.youtube.com/watch?v=jYrPQZnwXSk&t=3s) (Requirement Randomizer) - Located in video description
- [Spyro: Year of the Dragon](https://twitter.com/hwd405/status/1617036701980889088?cxt=HHwWgMC4pYSU7_AsAAAA) (hwd405's)

### S.T.A.L.K.E.R.

- [S.T.A.L.K.E.R.: Shadow of Chernobyl](https://www.moddb.com/games/stalker/downloads/simple-randomizer-for-shadow-of-chernobyl) (Simple Randomizer)

### Star Control

- [The Ur-Quan Masters (Star Control II open source port)](https://www.infiniteurquanmasters.com/) (Infinite Ur Quan Masters)

### StarCraft

- [StarCraft II](https://github.com/Die4Ever/starcraft-2-randomizer) (Balance Patch Randomizer)
- StarCraft II - _See at end of list: Multi-series, Connected worlds_

### Star Fox

- [Star Fox](https://www.patreon.com/posts/star-fox-92309645) (kandowontu's)
- [Star Fox](https://qubedstudios.rustedlogic.net/PeppysTool.htm) (Peppy's Tool)
- [Star Fox 64](https://github.com/punk7890/Star-Fox-64-Randomizer) (punk7890's)

### Star Wars

- [Star Wars: Dark Forces](https://github.com/The-MAZZTer/DarkForces) (Showcase) - Modding tool with bundled randomizer
- [Star Wars Jedi Knight: Jedi Academy](https://github.com/ps1337/RandomJK) (RandomJK)
- [Lego Star Wars: The Complete Saga](https://discord.com/invite/h5NKfmGWWm) (Viola's) - Discord account required - Located in the #downloads channel
- [Star Wars Jedi: Fallen Order](https://www.nexusmods.com/starwarsjedifallenorder/mods/209) (Enemy Randomizer)

### Starfield

- [Starfield](https://www.nexusmods.com/starfield/mods/7514) (Enemy Weapon Randomizer)

### Stardew Valley

- [Stardew Valley](https://www.nexusmods.com/stardewvalley/mods/20425) (Community Center Bundles Randomizer)
- [Stardew Valley](https://github.com/chikakoo/stardew-valley-randomizer) (More Random Edition) - Unofficial [compatibility fix for newer SMAPI versions](https://www.nexusmods.com/stardewvalley/mods/16921)
- [Stardew Valley](https://www.nexusmods.com/stardewvalley/mods/7151) (Queen of Sauce Randomizer)
- [Stardew Valley](https://stardewvalley.curseforge.com/projects/stardew-valley-randomizer) (Tooshi's) - [Source code](https://github.com/cTooshi/stardew-valley-randomizer) - _OBSOLETE_
- Stardew Valley - _See at end of list: Multi-series, Connected worlds_

### State of Decay

- [State of Decay](https://www.nexusmods.com/stateofdecay/mods/135) (Character Randomizer)

### SteamWorld

- [SteamWorld Dig](https://github.com/clementgallet/LiveSplit.SteamWorldDig.Randomizer) (LiveSplit.SteamWorldDig.Randomizer)
- [SteamWorld Dig 2](https://github.com/clementgallet/SWD2Randomizer) (SWD2Randomizer)

### Streets of Rage

- [Streets of Rage 2 / Streets of Rage 2 Syndicate Wars (hack)](https://www.romhacking.net/utilities/1634/) (SoR2 Level Editor) - Level editor with bundled randomizer
- [Streets of Rage 4](https://sourceforge.net/projects/sor4-character-swapper/) (Swapper)

### Strife

- Strife - _See at end of list: Multi-series, id Software engines_

### Subnautica

- [Subnautica](https://www.nexusmods.com/subnautica/mods/1230) (Aci's Drop Randomizer Challenge)
- [Subnautica](https://www.nexusmods.com/subnautica/mods/764) (Randomizer Remade)
- [Subnautica](https://www.nexusmods.com/subnautica/mods/309) (Stephen England's) - _OBSOLETE_
- [Subnautica](https://www.nexusmods.com/subnautica/mods/960) (Transition Randomiser)
- Subnautica - _See at end of list: Multi-series, Connected worlds_

### Super 3D Noah's Ark

- Super 3D Noah's Ark - _See at end of list: Multi-series, id Software engines_

### Super Meat Boy

- [Super Meat Boy](https://github.com/negative-seven/smb-randomizer) (negative-seven)

### Super Smash Bros.

- [Super Smash Bros. Melee](https://bttrandomizer.com/) (Break the Targets Randomizer)
- [Super Smash Bros. Melee](https://github.com/drewlith/ssbmr) (drewlith's)
- [Super Smash Bros. Ultimate](https://skelux.net/showthread.php?tid=954) (Skelux's)
- [Super Smash Bros. Ultimate](https://gamebanana.com/tools/9313) (WoL Randomizer)

### SWAT

- [SWAT 4](https://drive.google.com/file/d/1d9DpEDxMPCkl8LIst9uG7LvCQhmtaYbv/view) (Infinite) - [Original release forum post](https://www.gog.com/forum/swat_series/swat_4_random_missions_mod/post4)

### System Shock

- [System Shock (2023)](https://www.nexusmods.com/systemshock2023/mods/55) (Ironman)
- [System Shock 2 / Secmod (mod)](https://www.systemshock.org/index.php?topic=12152.0) (Sarge945's)
- [System Shock 2](https://www.systemshock.org/index.php?topic=67.0) (Zygoptera's) - _OBSOLETE_

### Tear Ring Saga

- [Berwick Saga: Lazberia Chronicle Chapter 174](https://feuniverse.us/t/berwick-saga-berwick-saga-editor-randomizer-early-beta/11256) (Editor & Randomizer)

### Tecmo Bowl

- [Tecmo Super Bowl](https://tecmobowl.org/files/file/599-tecmo-super-bowl-salary-cap-random-match/) (Salary Cap Random Match)

### Teenage Mutant Ninja Turtles

- [Teenage Mutant Ninja Turtles (NES)](https://github.com/abyssonym/tmnt_rando) (abyssonym's)
- [Teenage Mutant Ninja Turtles (NES)](https://www.kavoc.io/tmntR) (kavoc's)

### Terraria

- [Terraria](http://artemis251.fobby.net/stuff/terrariaMusic.html) (Chest Randomizer)
- [Terraria](https://forums.terraria.org/index.php?threads/terraria-flag-randomizer.113407/) (Flag Randomizer) - Requires [tModLoader](https://tmodloader.net/)
- [Terraria](https://forums.terraria.org/index.php?threads/randomizer-challenge-mod.83163/) (JamSnack's) - Requires [tModLoader](https://tmodloader.net/)
- Terraria - _See at end of list: Multi-series, Connected worlds_

### Tetris

- [Tetris (NES Nintendo)](https://drive.google.com/drive/folders/19NklVLPD1cF2cygbJSIgyvGfKUl7eCVg) (fridaywitch's) - Overrides normal RNG

### The 7th Saga

- [The 7th Saga](https://github.com/gameboy9/7thSagaRando/releases) (gameboy9's)

### The Battle of Olympus

- [The Battle of Olympus](https://www.romhacking.net/hacks/8283/) (Item Randomizer)

### The Elder Scrolls

- [The Elder Scrolls III: Morrowind](https://www.nexusmods.com/morrowind/mods/47306) (4NM_Randomizer)
- [The Elder Scrolls III: Morrowind](https://www.nexusmods.com/morrowind/mods/48632) (Door Randomizer)
- [The Elder Scrolls III: Morrowind](https://www.nexusmods.com/morrowind/mods/51242) (DRIP)
- [The Elder Scrolls III: Morrowind](https://www.nexusmods.com/morrowind/mods/44989) (mort's)
- [OpenMW (The Elder Scrolls III: Morrowind open source port)](https://www.nexusmods.com/morrowind/mods/53455) (Fancy Door Randomizer)
- [OpenMW (The Elder Scrolls III: Morrowind open source port)](https://www.nexusmods.com/morrowind/mods/53454) (World Randomizer)
- [The Elder Scrolls IV: Oblivion](https://www.nexusmods.com/oblivion/mods/51582) (brknndd's)
- [The Elder Scrolls IV: Oblivion](https://www.nexusmods.com/oblivion/mods/49970) (ddmlink's)
- [The Elder Scrolls IV: Oblivion](https://www.nexusmods.com/oblivion/mods/53582) (Leveled Armors and Weapons Randomizer)
- [The Elder Scrolls V: Skyrim](https://www.nexusmods.com/skyrim/mods/61962) (Fushigina Dungeon)
- [The Elder Scrolls V: Skyrim](https://www.nexusmods.com/skyrim/mods/63933) (Random Dungeon Generator) - _OBSOLETE_
- [The Elder Scrolls V: Skyrim](https://www.nexusmods.com/skyrim/mods/43409) (Randomized Word Walls)
- [The Elder Scrolls V: Skyrim](https://www.nexusmods.com/skyrim/mods/114581) (World Randomizer)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/107301) (Alchemy Effects Randomizer, SKSE)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/41960) (Alchemy Effects Randomizer, zEdit)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/23838) (Randomized Birthstones)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/13757) (Randomized Word Walls) - _OBSOLETE_
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/81881) (Serpent's Modular Randomizer)
- [The Elder Scrolls V: Skyrim Special Edition / The Elder Scrolls V: Skyrim VR](https://www.nexusmods.com/skyrimspecialedition/mods/70839) (ToxiRandomizer)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/41616) (Word Walls Randomizer)
- [The Elder Scrolls V: Skyrim Special Edition](https://www.nexusmods.com/skyrimspecialedition/mods/79974) (World Randomizer)

### The Goonies

- [The Goonies II](https://www.romhacking.net/utilities/1247/) (Netsrotti's) - _OBSOLETE_
- [The Goonies II](https://goonies2r.com/en) (Veetorp's)

### The Guardian Legend

- [The Guardian Legend](https://www.synchrocade.com/tgl) (fireball87's) - [Source code](https://github.com/fireball87/GuardianLegendRando)
- [The Guardian Legend](https://micheilskeens.com/guardian-legend-randomizer.php) (Micheil Skeens's) - _OBSOLETE_

### The Legend of Heroes

- [The Legend of Heroes: Trails of Cold Steel](https://github.com/nnguyen259/ColdSteelRandomizer) (nnguyen259's)
- [The Legend of Heroes: Trails of Cold Steel III](https://github.com/nnguyen259/ColdSteel3Tools) (nnguyen259's) - Modding tool with bundled randomizer
- [The Legend of Heroes: Trails into Reverie](https://github.com/nnguyen259/ReverieRandomizer) (nnguyen259's)

### The Legend of Zelda

#### 2D & 2D-like

- The Legend of Zelda / The Legend of Zelda: A Link to the Past / The Legend of Zelda: Link's Awakening DX - _See at end of list: Multi-series, Connected worlds_
- [The Legend of Zelda](https://www.romhacking.net/hacks/7358/) (Ancient Dungeon)
- [The Legend of Zelda](https://sites.google.com/site/zeldarandomizer/) (Fred Coughlin's)
- [The Legend of Zelda](https://bitbucket.org/Garmichael/infinite-hyrule/src/master/) (Infinite Hyrule)
- [The Legend of Zelda](https://www.reloadedretro.com/games/zelda) (Reloaded)
- [The Legend of Zelda](https://github.com/tetraly/zelda-randomizer) (tetraly's)
- [Zelda II: The Adventure of Link](https://bitbucket.org/digshake/z2randomizer/wiki/Home) (Digshake's) - _OBSOLETE_
- [Zelda II: The Adventure of Link](https://github.com/Ellendar/Z2Randomizer) (Ellendar's)
- [The Legend of Zelda: A Link to the Past](https://github.com/Bonta0/ALttPEntranceRandomizer/tree/multiworld_31) (Bonta0's Multiworld) - Optional [Enemizer](https://github.com/Bonta0/Enemizer/releases) - Unofficial [setup/instructions guide](https://docs.google.com/document/d/19FoqUkuyStMqhOq8uGiocskMo1KMjOW4nEeG81xrKoI/edit) - _OBSOLETE_
- [The Legend of Zelda: A Link to the Past](https://dessyreqt.github.io/alttprandomizer/) (Dessyreqt's) - _OBSOLETE_
- [The Legend of Zelda: A Link to the Past](https://github.com/aerinon/ALttPDoorRandomizer) (Door Randomizer)
- [The Legend of Zelda: A Link to the Past](https://github.com/Zarby89/Enemizer) (Enemizer) - _OBSOLETE_
- [The Legend of Zelda: A Link to the Past](https://github.com/AmazingAmpharos/ALttPEntranceRandomizer) (Entrance Randomizer) - _OBSOLETE_
- [The Legend of Zelda: A Link to the Past](https://alttpr.gwaa.kiwi/en) (karafruit's) - [Source code](https://github.com/ardnaxelarak/alttp_vt_randomizer/tree/ow_shuffle)
- [The Legend of Zelda: A Link to the Past](https://github.com/codemann8/ALttPDoorRandomizer) (Overworld Randomizer)
- [The Legend of Zelda: A Link to the Past](https://alttpr.com/en) (Veetorp's)
- [The Legend of Zelda: A Link to the Past/Four Swords](https://github.com/MichaelK-UnderscoreUnderscore/alttprandomizer_GBA/releases) (MichaelK__'s)
- [The Legend of Zelda: Link's Awakening DX](https://daid.github.io/LADXR/) (LADXR)
- [The Legend of Zelda: Link's Awakening DX](https://sites.google.com/view/z4randomizer) (Z4Randomizer)
- [The Legend of Zelda: Link's Awakening (Switch)](https://github.com/la-switch/LAS-Randomizer) (Glan9's) - _OBSOLETE_
- [The Legend of Zelda: Link's Awakening (Switch)](https://github.com/Owen-Splat/LAS-Randomizer) (Owen-Splat's)
- [The Legend of Zelda: Oracle of Ages / The Legend of Zelda: Oracle of Seasons](https://github.com/jangler/oracles-randomizer)
- [The Legend of Zelda: The Minish Cap](https://github.com/minishmaker/randomizer) (Minish Maker's)
- [The Legend of Zelda: A Link Between Worlds](https://gitlab.com/marsolk/albw-randomizer-cli) (Kevin Marsolais's) - _OBSOLETE_
- [The Legend of Zelda: A Link Between Worlds](https://github.com/rickfay/z17-randomizer) (Rick Fay's)
- [The Faces of Evil Remastered (Link: The Faces of Evil fan recreation) / The Wand of Gamelon Remastered (Zelda: The Wand of Gamelon fan recreation](https://archive.org/details/foer-wogr-randomizer-mod) (Dopply's)

#### 3D

- [The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Majora's Mask](https://ootmm.com/) (OoTMM) - [Source code](https://github.com/OoTMM/core)
- [The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master Quest](https://github.com/AmazingAmpharos/OoT-Randomizer) (AmazingAmpharos's) - _OBSOLETE_
- [The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master Quest](https://ootrandomizer.com/) (TestRunner's)
- The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master Quest - _See at end of list: Multi-series, Connected worlds_
- [The Legend of Zelda: Ocarina of Time](https://www.mediafire.com/folder/8c5ez915mhfww/latest) (Beta Quest)
- [The Legend of Zelda: Ocarina of Time](https://github.com/HarbourMasters/Shipwright) (Ship of Harkinian) - Unofficial PC port with bundled randomizer
- [The Legend of Zelda: Ocarina of Time 3D](https://github.com/gamestabled/OoT3D_Randomizer) (gamestabled's)
- [The Legend of Zelda: Majora's Mask](https://www.zeldacodes.org/challenges/beta-quest) (Beta Quest) - Requires a cheat engine supporting Gecko codes
- [The Legend of Zelda: Majora's Mask](https://pastebin.com/M0asDmXy) (DeathBasket's, 2013) - Randomizes items based on file name - Requires using non-casual techniques
- [The Legend of Zelda: Majora's Mask](https://www.youtube.com/watch?v=xIeNzcwWAtM) (DeathBasket's, 2019) - Located in video description - Requires using non-casual techniques - _OBSOLETE_
- [The Legend of Zelda: Majora's Mask](https://github.com/ZoeyZolotova/mm-rando/releases) (ZoeyZolotova's)
- [The Legend of Zelda: Majora's Mask 3D](https://github.com/Z3DR/MM3D_Randomizer/releases) (MM3D_Randomizer)
- [The Legend of Zelda: The Wind Waker](https://github.com/CryZe/WindWakerBetaQuest) (Beta Quest)
- [The Legend of Zelda: The Wind Waker](https://github.com/LagoLunatic/wwrando) (LagoLunatic's)
- [The Legend of Zelda: Twilight Princess](https://tprandomizer.com/) (AECX's)
- [The Legend of Zelda: Twilight Princess HD](https://www.youtube.com/watch?v=ql7qzX1mPIY) (Beta Quest) - Located in video description - [Source code](https://github.com/zsrtp/TPHD-BetaQuest)
- [The Legend of Zelda: Skyward Sword](https://github.com/ssrando/ssrando) (lepelog's)
- [The Legend of Zelda: Breath of the Wild (Wii U)](https://github.com/MelonSpeedruns/BotwRandomizer) (MelonSpeedruns's)
- [The Legend of Zelda: Breath of the Wild (Wii U)](https://gamebanana.com/mods/354911) (Randomized Leveled Chests)
- [The Legend of Zelda: Breath of the Wild (Wii U)](https://gamebanana.com/mods/345664) (Waikuteru's)
- [The Legend of Zelda: Breath of the Wild (Switch)](https://gamebanana.com/mods/345673) (Waikuteru's)
- [The Legend of Zelda: Tears of the Kingdom](https://github.com/MelonSpeedruns/TotkRandomizer) (MelonSpeedruns's)

### The Little Mermaid

- [The Little Mermaid](https://micheilskeens.com/little-mermaid-randomizer.php) (Micheil Skeens's)

### The Messenger

- [The Messenger](https://github.com/minous27/TheMessengerRandomizerMod) (Minous27's)
- The Messenger - _See at end of list: Multi-series, Connected worlds_

### The Simpsons

- [The Simpsons: Hit & Run](https://github.com/EnAppelsin/SHARCarRandomiser) (EnAppelsin's)

### The Sims

- [The Sims 4](https://www.nexusmods.com/thesims4/mods/1349?tab=description) (NPC Skill Randomizer)

### The Talos Principle

- [The Talos Principle](https://github.com/apple1417/Talos-Randomizer) (apple1417's) - Randomizes portals & sigils - Also on [Steam Workshop](https://steamcommunity.com/sharedfiles/filedetails/?id=1244163099)

### The Witness

- [The Witness](https://github.com/jbzdarkid/witness-randomizer/releases) (jbzdarkid's)
- [The Witness](https://github.com/sigma144/witness-randomizer) (Witness Random Puzzle Generator)
- The Witness - _See at end of list: Multi-series, Connected worlds_

### The World Ends with You

- [The World Ends with You](https://github.com/abyssonym/fractalizon) (Fractalizon)
- [NEO: The World Ends with You](https://github.com/SaltContainer/NEO-TWEWY-Randomizer) (SaltContainer's)

### Timespinner

- [Timespinner](https://github.com/Jarno458/TsRandomizer) (Jarno's)
- Timespinner - _See at end of list: Multi-series, Connected worlds_

### Titanfall

- [Titanfall 2](https://github.com/taskinoz/Titanfall2-Randomizer) (taskinoz's) - [Official hints](https://github.com/taskinoz/Titanfall-Randomizer-Hints) for new possible helmet locations

### Tomb Raider

- [Tomb Raider / Tomb Raider II / Tomb Raider III](https://github.com/LostArtefacts/TR-Rando) (Lost Artefacts's)

### Tomodachi

- [Miitopia](https://github.com/Kobazco/Miitopia_Randomizer) (Kobazco's)

### Total War

- [Rome: Total War / Total War: Rome Remastered](https://github.com/sargeantPig/RTWRandomiser) (sargeantPig's)

### Touhou

- [Gensokyo no Nazo (Atlantis no Nazo fangame)](https://github.com/Ryason55/gnazo_randomizer) (Ryason55's)
- Touhou Luna Nights - _See at end of list: Multi-series, Other_

### Tunic

- [Tunic](https://github.com/Dr4g0nsoul/TunicRandomizer) (Item Randomizer) - _OBSOLETE_
- [Tunic](https://github.com/silent-destroyer/tunic-randomizer) (SilentDestroyer's)
- Tunic - _See at end of list: Multi-series, Connected worlds_

### Turok

- [Turok (Nightdive Studios)](https://turoksanctum.com/randomizer/) (Behemoth's)

### Tyrian

- [OpenTyrian (Tyrian open source port)](https://drive.google.com/drive/folders/1Qn0iqGOt-Zqt5L-DSSiS_v3WQhKZWB7P) (TyriGen)

### Ultima

- [Ultima IV: Quest of the Avatar (PC)](https://github.com/Fenyx4/U4DosRandomizer) (Fenyx4's)
- [Ultima IV: Quest of the Avatar (NES)](https://github.com/Gilmok/U4Rando/) (Gilmok's)
- [Ultima VI: The False Prophet (Super NES)](https://arya-iwakura.github.io/Ultima6Randomizer/) (squibbons's)

### Ultrakill

- [Ultrakill](https://github.com/TRPG0/ArchipelagoULTRAKILL) (ArchipelagoULTRAKILL) - Requires [Archipelago](https://archipelago.gg/)

### Uncharted Waters

- [Uncharted Waters: New Horizons](https://github.com/Gilmok/UWNHRando) (Gilmok's)

### Undertale

- [Undertale](https://gamejolt.com/games/UndertaleGenoRandomizer/604714) (Geno Randomizer)
- Undertale - _See at end of list: Multi-series, Connected worlds_
- [Deltarune (SURVEY_PROGRAM)](https://discord.com/invite/WwVB9sxd47) (Deltarando) - Discord account required - Located in the #resources channel - Randomizes Chapter 1
- [Deltarune (Chapter 1&2)](https://gamebanana.com/mods/405974) (Chapter 2 Encounter Randomizer) - Randomizes Chapter 2

### Unreal

- [Unreal Gold](https://github.com/Die4Ever/unreal-randomizer) (Die4Ever's)
- [Unreal Tournament](https://www.gweb.me.uk/gweb/ut_mr.htm) (Map Randomizer) - _OBSOLETE_
- [Unreal Tournament](https://www.gweb.me.uk/xmaps/index.html) (XMaps)

### Vagrant Story

- [Vagrant Story](https://github.com/ChaoticBrave/VagrantStoryRandomizer) (ChaoticBrave's)	

### Victoria

_Old versions of Paradox Development Studio games are available on Steam as betas._

- [Victoria II](https://yadi.sk/d/b6jEkpbrBMexiw) (FortTell's Random World Generator) - [Original release forum post](https://forum.paradoxplaza.com/forum/threads/victoria-ii-random-world-generator.546055/page-35#post-26579083) for Paradox Interactive account users
- [Victoria II](https://web.archive.org/web/20210125171855/https://www.magiadosdoces.com/jeff/v2rwg.html) (Jefferson Pinheiro's Random World Generator) - _OBSOLETE_

### VVVVVV

- VVVVVV - _See at end of list: Multi-series, Connected worlds_

### Wargroove

- Wargroove - _See at end of list: Multi-series, Connected worlds_

### Wario

- [Wario Land 3](https://github.com/AaronDobbe/wl3-randomizer) (AaronDobbe's)
- [Wario Land 4](https://github.com/IsaGoodFriend/WL4-Randomizer) (IsaGoodFriend's)

### Willow

- Willow (NES) - _See at end of list: Multi-series, Other_

### Wolfenstein

- Wolfenstein 3D / Spear of Destiny - _See at end of list: Multi-series, id Software engines_

### X

- [X2: The Threat](https://xehonk.de/projects/galaxyeditor.php) (Galaxy Editor) - Includes random galaxy creator - _OBSOLETE_
- [X2: The Threat](https://sourceforge.net/projects/xuniversewizard/) (XUniverseWizard) - Download of dependency requires Egosoft account
- [X3: Terran Conflict](https://forum.egosoft.com/viewtopic.php?f=94&t=397700) (AP Map Generator)

### XCOM

- [XCOM: Enemy Unknown](https://www.nexusmods.com/xcom/mods/499) (Wasteland Ghost's)

### Xeno

- [Xenoblade Chronicles 3](https://github.com/RoccoDev/xc3fr-unlock-kit-balance) (Future Redeemed unlock kit balance editor) - Randomizes Art Unlock Kit locations

### Yo-kai Watch

- [Yo-kai Watch](https://github.com/Tiniifan/YKWrandomizer) (YKWrandomizer)

### Yoshi

- Yoshi's Island - _See at end of list: Multi-series, Connected worlds_

### You Have to Win the Game

- [You Have to Win the Game](https://github.com/ZZKer/YHtWtG-Randomizer) (ZZKer's)

### Yu-Gi-Oh!

- [Yu-Gi-Oh! Forbidden Memories](https://www.speedrun.com/yugiohfm/resources) (Complete Randomizer / Random Startdeck Mod) - Located under Patches
- [Yu-Gi-Oh! The Duelists of the Roses](https://github.com/GenericMadScientist/DotR-Randomiser) (GenericMadScientist's)

### Zanac

- [Zanac](https://www.zanacga.me/) (Omaha's)

### Zero Sievert

- [Zero Sievert](https://www.nexusmods.com/zerosievert/mods/25) (Gun and Armor Randomizer)

### Zillion

- [Zillion](https://github.com/beauxq/zilliandomizer) (Zilliandomizer)
- Zillion - _See at end of list: Multi-series, Connected worlds_

### Zombies Ate My Neighbors

- [Zombies Ate My Neighbors (Genesis)](https://www.romhacking.net/hacks/6960/) (Zombies Ate My Roguelike)

### Zork

- Zork: Grand Inquisitor - _See at end of list: Multi-series, Connected worlds_

### Multi-series

#### Connected worlds

- [The Legend of Zelda: A Link to the Past / Factorio / Minecraft: Java Edition / Subnautica / Slay the Spire / Risk of Rain 2 / The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master Quest / Timespinner / Super Metroid / Secret of Evermore / Final Fantasy / Rogue Legacy / VVVVVV / Raft / Super Mario 64 / Meritous / Hollow Knight / The Witness / Sonic Adventure 2 / StarCraft II / Donkey Kong Country 3: Dixie Kong's Double Trouble / Dark Souls III / Super Mario World / Pokémon Red Version (international) / Pokémon Blue Version (international) / Hylics 2 / Overcooked! 2 / Zillion / Lufia II: Rise of the Sinistrals / Blasphemous / Wargroove / Stardew Valley / The Legend of Zelda / The Messenger / Kingdom Hearts II Final Mix / The Legend of Zelda: Link's Awakening DX / Adventure / DLC Quest / Noita / Undertale / Mega Man Battle Network 3 Blue / Muse Dash / Doom (Ultimate) / Terraria / Lingo (Brenton Wildes) / Pokémon Emerald Version / Doom II / Shivers / Heretic / Landstalker: The Treasures of King Nole / Final Fantasy Mystic Quest / Tunic / Kirby's Dream Land 3 / Celeste 64: Fragments of the Mountain / Zork: Grand Inquisitor / Castlevania (Nintendo 64) / A Short Hike / Yoshi's Island](https://archipelago.gg/) (Archipelago) - List of [additional extensions in development](https://multiworld.news/apworlds.html)
- [Castlevania: Harmony of Dissonance / Bomberman Tournament](https://hodbt.surge.sh/) (HoDBT)
- [Super Metroid / The Legend of Zelda: A Link to the Past](https://github.com/Vivelin/SMZ3Randomizer) (SMZ3 Cas' Randomizer)
- [Super Metroid / The Legend of Zelda: A Link to the Past](https://samus.link/) (Super Metroid and A Link to the Past
Crossover Randomizer) - [Beta version](https://beta.samus.link/)
- [AM2R (Metroid fangame) / Cave Story / Cave Story+ / Metroid Dread / Metroid Prime / Metroid Prime 2: Echoes / Metroid: Samus Returns](https://randovania.org/) (Randovania)
- [The Legend of Zelda / Metroid](https://z1m1.info/) (Z1M1)

#### id Software engines

- [Doom (Ultimate) / Doom II / Final Doom / Heretic / Hexen: Beyond Heretic / Strife / Chex Quest](https://forum.zdoom.org/viewtopic.php?f=45&t=51446) (CustomDoom) - _OBSOLETE_
- [Doom (Ultimate) / Doom II / Final Doom / Heretic / Hexen: Beyond Heretic / Strife / Chex Quest](https://forum.zdoom.org/viewtopic.php?f=43&t=64678) (Universal Custom Doom)
- [Doom (Ultimate) / Doom II / Final Doom / Heretic / Hexen: Beyond Heretic / Strife / Chex Quest](https://www.moddb.com/mods/universal-entropy) (Universal Entropy)
- [Doom (Ultimate) / Doom II / Final Doom / Heretic / Chex Quest 3 (fangame) / Hacx / Harmony (fangame) / Hexen: Beyond Heretic / Strife / Wolfenstein 3D / Spear of Destiny / Super 3D Noah's Ark](https://obsidian-level-maker.github.io/index.html) (OBSIDIAN)
- [Doom (Ultimate) / Doom II / Final Doom / Heretic](https://oblige.sourceforge.net/) (OBLIGE) - Unofficial [64-bit executable](https://forum.zdoom.org/viewtopic.php?f=44&t=64879) - Extensive add-on [ObAddon](https://github.com/caligari87/ObAddon/) - Add-on for [Brutal Doom (mod)](https://gitlab.com/CloudOfShame/BrutalOblige) - Version 4.28 also supported [Hexen: Beyond Heretic / Quake / Quake II](https://sourceforge.net/projects/oblige/files/Oblige/4.28/) - Version 0.97 also had experimental support for [Wolfenstein 3D](https://sourceforge.net/projects/oblige/files/Oblige/0.97/) - _OBSOLETE_
- [Doom (Ultimate) / Doom II / Final Doom / Heretic](https://samiam.org/obhack/) (ObHack) - _OBSOLETE_
- [Doom (Ultimate) / Heretic](https://forum.zdoom.org/viewtopic.php?f=43&t=72760) (MOShuffle)

#### Other

- [Duke Nukem 3D / Ion Fury / Shadow Warrior / Blood / PowerSlave (PC)](https://github.com/Die4Ever/build-engine-randomizer) (Build Engine Randomizer)
- [Crash Nitro Kart / Crash Twinsanity / Crash Tag Team Racing / Rayman 3: Hoodlum Havoc / Crash Bandicoot / Crash Bandicoot 2: Cortex Strikes Back / Crash Bandicoot: Warped / Crash Bandicoot: The Wrath of Cortex](https://github.com/TheBetaM/CrateModLoader) (Crate Mod Loader)
- [Hebereke / Willow (NES) / Mega Man X3 / Zero Project (Mega Man X3 hack) / Breath of Fire](https://github.com/vinheim3/randomizers) (Dan Jia Randomizers) - Download code in local directory and open `index.html` to use
- [SpongeBob SquarePants: Battle for Bikini Bottom (GameCube / Xbox / PS2) / Scooby-Doo: Night of 100 Frights / The SpongeBob SquarePants Movie (GameCube / Xbox / PS2)](https://github.com/igorseabra4/IndustrialPark) (Industrial Park) - Level editor with bundled randomizer - [User guide](https://heavyironmodding.org/wiki/Randomizer)
- [Touhou Luna Nights / Record of Lodoss War: Deedlit in Wonder Labyrinth](https://github.com/Lakifume/Ladybug-Randomizer) (Ladybug Randomizer)

---

## What is this list?

Randomizers are game modifications and utilities that randomly arranges original game data in a way that significantly increase their replayability. Their randomization are applied before or when starting a new game in order to effectively generate many different games to experience based off the originals. They are also designed to prevent new unwinnable states to the game, or at the very least make such issues extremely unlikely or have easily-applicable non-destructive workarounds.

Randomizers may feature major gameplay tweaks to accomodate possible randomized changes, or other additional minor improvements. However, a game modification or utility that may change any other gameplay element and which cannot be disabled would not be considered a randomizer, as the modified game would become closer to a custom game instead of a randomized one.

This list is an exhaustive list of all known freely-available video game randomizers that are playable by the general public and not bundled with the game they randomize, regardless of their fun factor. The goal of this project is to give positive exposure to randomizers that players of their original games may have missed otherwise. It was originally created by [Guillaume Fortin-Debigaré](https://www.debigare.com/) in 2016, and maintained by him up until 2024, when it became an [open source community project](https://github.com/video-game-randomizers/rando-list).

In order to prevent the list from being polluted with randomizers that do not conform to the above, the following is not considered sufficient for inclusion:

- Official games and bundled tools.
- Game modification that randomizes itself rather than the game it is modifying.
- Located behind a paywall.
- Can easily be performed without game modifications or external logic trackers.
- No significant gameplay changes beyond superficial ones.
- Randomization requiring major modifications to the original moment-to-moment gameplay mechanics.
- Guaranteed to be beatable only by using expert techniques that trivializes the randomization.
- Pre-randomized data in the randomizer's code.
- Incomplete coverage of a randomized data type within a standalone game mode.
- Random object injection within original game areas.
- Inconsistent outcomes within the same playthrough.
- Recurring random events triggered by seemingly-unrelated causes.
- Chaotic effects.

Randomizers are listed by the games they randomize and grouped by game series, along with the randomizer's name (or the primary creators' names if it is too generic) in parentheses, along with any additional documentation whenever necessary.

The following rules are used to determine the game name showed in the list:

- For games with different versions, the list refers to the base game name only, unless an alternate version has significantly different gameplay content in which case it is considered a separate game.
- For games with official expansions or downloadable content, only the base game name is listed, even if said expansions or DLCs are required for the associated randomizer to work.
- If at least one official English name exists, the most current one is used, with American English prioritized over European English.
- Official Japanese names with no official English equivalent are romanized in modified Hepburn, with the exception of katakana which is directly translated.
- Whenever different games have identical names, the list refers to the one originally released, unless explicitely specified.
- Legal characters are omitted.
- Proper grammar is used over stylized writings.

## Can I help?

This list would not be what it is today without the amazing help of the gaming community! If you would like to contribute in any way, including submitting a video game randomizer valid for inclusion that is not already listed, please join the [Video Games Randomizer Discord server](https://discord.com/invite/YREMzGQ3gd), the official Discord server for this page.

If you are a developer, the [code repository for this page](https://github.com/video-game-randomizers/rando-list) is also available on GitHub. Feel free to submit pull requests and/or join the Discord server to discuss with the other maintainers!

## I want more!

You can chat with other randomizer enthusiasts on the [Video Games Randomizer Discord server](https://discord.com/invite/YREMzGQ3gd), a Discord Community Server originally created specifically for this page.

You can look for the [Randomizer tag on Twitch](https://www.twitch.tv/directory/all/tags/Randomizer) to easily find channels streaming live randomizer video content.

Many popular randomizers have progression trackers available. [EmoTracker](https://emotracker.net/) is a popular tool that hosts a large collection of them.

For those interested in creating randomizers, you can listen to the [Making a Randomizer panel from Awesome Games Done Quick 2019](https://www.youtube.com/watch?v=vGIDzGvsrV8) explaining the process in detail. [ROMHacking.net](https://www.romhacking.net/) is also a great resource with plenty of technical information and tools for hacking video games in general. Frameworks such as [randomtools-js](https://github.com/stochaztic/randomtools-js) and [Simple Randomizer Maker](https://github.com/Mips96/SimpleRandomizerMaker) may also help for development purposes.

For those that perfer an original game experience but still want to experience a randomized challenge, [Final Fantasy Five Four Job Fiesta](https://www.fourjobfiesta.com/freerun.php), [Hitman Roulette](https://thekotti.github.io/about.html) and [Scenario Generator](https://scenariogenerator.net/faq) can generate interesting rulesets with randomized goals for many classic video games.

While this list is focused on third-party video game randomizers, there are also many official video game randomizers out there. Most notably, the unlockable item randomizer included in the Nintendo 64 version of Resident Evil 2 is believed to be the very first item randomizer ever.

Note that randomizer variants also exist for tabletop games as well, such as [Fischer Random Chess](https://en.wikipedia.org/wiki/Fischer_random_chess) and [Monopoly Randomizer](https://boardgamegeek.com/thread/2410918/monopoly-randomizer).