Skeleton theme
============

The Skeleton theme is a simplified Shopify theme, to be used as a "blank slate" starting point for theme designers.

<b>Features:</b>
- Almost no theme settings. Ready to be customized any way you want. 
- Only ~500 lines of CSS including comments. 
- Despite its 500 lines of CSS code, it is responsive and has styled drop-down menus.
- Include SVG images to style select elements and cart icon.
- Commented code to teach you Liquid concepts in practice.

<b>Demo:</b>

- [Demo store](http://skeleton.myshopify.com/)

Designing a store for a client? Earn 20% revenue through our <a href="http://www.shopify.com/partners">Partner program<a/>.

Getting started
---------------------
1. <a href="https://github.com/Shopify/skeleton-theme/archive/master.zip">Download</a> the latest version
2. or clone the git repo: <code>git clone https://github.com/Shopify/skeleton-theme.git</code>

Basic structure
---------------
```
├── assets
│   └── Javascript, CSS, and theme images
├── config
│   └── custom Theme Settings
├── layout
│   ├── theme.liquid
│   └── optional alternate layouts
├── snippets
│   └── optional custom code snippets
├── templates
│   ├── 404.liquid
│   ├── article.liquid
│   ├── blog.liquid
│   ├── cart.liquid
│   ├── collection.liquid
│   ├── index.liquid
│   ├── page.liquid
│   ├── product.liquid
│   └── search.liquid
│   └── list-collections.liquid
```

Additional resources
---------------------
- <a href="http://meetup.shopify.com/">Free workshops</a>: Sign up for a free Shopify For Designers workshop in a city near you.
- <a href="http://docs.shopify.com/themes">Theme Documentation</a>: Learn more about Liquid and theme templates.
- <a href="http://apps.shopify.com/desktop-theme-editor">Desktop Theme Editor</a>: For Mac OS X users, we recommend our free app to sync theme files in development. 
- Need more help? Ask a question in our <a href="http://ecommerce.shopify.com/c/ecommerce-design"> Design Forums</a>.
