# :brain: Generative AI - Learning Guide :robot:
> "_A.I. might not replace you, but a person who uses A.I. could._"

A curated list of Generative AI videos :tv:, tutorials :notebook:, guides :books:, articles and frameworks.

- [Generative AI]()
  - [ChatGPT]()
  - [LLMs]() 
- [Prompting Techniques]()
- [Autonomous AI Agents]()
  
---

## Generative AI

Generative AI is a type of artificial intelligence technology that can produce various types of content, including text, images, audio, videos and synthetic data.

### What is ChatGPT? 
ChatGPT is a large language model that generates human-like text in response to a given text prompt. It is essentially a next word predictor. 

- ChatGPT is an AI chatbot developed by OpenAI
- ChatGPT is a variant of the GPT (Generative Pre-training Transformer) model, which is a type of transformer-based neural network architecture.
- The model is trained on a [large dataset of text](https://en.wikipedia.org/wiki/GPT-3) which contains entire internet, books, Wikipedia and more.

It can understand what we say or write, or rather, can generate knowledge from what they have learned from humans. It set to revolutionise the way we work.
It is showing sparks of cleverness that can accelerate automation.

### What are LLMs?

A large language model (LLM) is a deep learning algorithm that can perform a variety of natural language processing (NLP) tasks. Large language models use transformer models and are trained using massive datasets — hence, large. This enables them to recognize, translate, predict, or generate text or other content.

### How ChatGPT works?

[How GPT3 Works - Visualizations and Animations](https://jalammar.github.io/how-gpt3-works-visualizations-animations/)

#### GPT Internals
- :tv: [State of GPT](https://www.youtube.com/watch?v=bZQun8Y4L2A)
- :tv: [Let's build GPT: from scratch, in code, spelled out](https://youtu.be/kCc8FmEb1nY)

#### GPT-3 Vs. ChatGPT Vs. GPT-4
[Comparison of GPT-3, ChatGPT and GPT-4](https://simplified.com/blog/ai-writing/chatgpt-vs-gpt-3/)

### What can I do with ChatGPT?
- :star::star: https://research.aimultiple.com/chatgpt-use-cases/


### Gen AI Tools

#### Text to Image 
- [Midjourney](https://www.midjourney.com/showcase/recent/) is a text-to-image AI that generates visually appealing images based on text prompts.
  - [ Midjourney + ChatGPT-4 = INSANE Prompts and Images!]https://www.youtube.com/watch?v=Asg1e_IYzR8
- [DALL-E 2](https://openai.com/dall-e-2)

### Text to Video Generators

#### Code Generators
- CodeX
- Github Copilot

- - [Coding Won’t Exist In 5 Years. This Is Why](https://javascript.plainenglish.io/coding-wont-exist-in-5-years-this-is-why-6da748ba676c)
- SQL: https://www.sqlservercentral.com/articles/chatgpt-in-sql-server-practical-examples

### Audio
#### Speech Recognition & Transcription (Audio-to-Text)
#### Speech Synthesis (Text-to-Audio)
#### Voice Cloning

- [Whishper - Automated Speech Recognition](https://openai.com/research/whisper)

### Gen AI Youtube Channels
- :tv: [Youtube @AllaboutAI Channel](https://www.youtube.com/@AllAboutAI/videos) 🌟
- :tv: [Youtube @mreflow Channel](https://www.youtube.com/@mreflow/videos) 🌠

### Prompt Engineering Guide
##### Guides
- :star::star: [Learn Prompting](https://learnprompting.org/docs/intro)
- :star: [Prompt Engineering Guide](https://www.promptingguide.ai/)
##### Videos
- :star::star::star::tv: [ChatGPT Prompt Engineering Level Up in 8 Minutes](https://www.youtube.com/watch?v=Qos2rG3zVAM)
- :star::star: [ChatGPT Prompt Engineering: The Human Reasoning Super Prompt ](https://www.youtube.com/watch?v=S4GfRQ9zIj4)
- Watch entire playlist here, [Prompt Engineering Playlist](https://www.youtube.com/watch?v=S4GfRQ9zIj4&list=PL6o08pkcQol7-TlFJl05pEEp4hw418DmM)
- :star::star::star: :tv: [Prompt Engineering by Matt Wolfe](https://www.youtube.com/watch?v=pc8ftlzB2D0)

## Generative AI / LLMs Model Hub 
[Huggingface](https://huggingface.co/) - A repository of open-source and proprietary LLM model hub. Provides LLM models, hosting, inference endpoints and more.

[Hugging Face Transformer Tutorial](https://huggingface.co/learn/nlp-course/chapter2/1?fw=pt) - A library to download open-source LLMs to your machine, run LLMs locally and perform inferences.
#### Open LLM Leaderboard
https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard

## Autonomous AI Agents
- [Agent GPT](https://agentgpt.reworkd.ai/) - An web-based autonoums AI agent.
- [Auto GPT](https://github.com/Significant-Gravitas/Auto-GPT) - Auto-GPT is an experimental open-source application showcasing the capabilities of the GPT-4 language model.
- [Godmode Space](https://godmode.space/) - Godmode is a web platform to access the powers of autoGPT and babyAGI.

:star::star::star: [LangChain](https://python.langchain.com/en/latest/index.html) Framework to build Automous AI Agent

:tv: :star: [LangChain Tutorials](https://www.youtube.com/@lucidateAI)


### LLM Evaluation Libraries & Metrics

Perplexity (PPL) is one of the most common metrics for evaluating language models. 
https://huggingface.co/docs/transformers/perplexity

https://github.com/openai/evals
