# 🤖 Artificial Intelligence & Machine Learning 🧠

> "_A.I. might not replace you, but a person who uses A.I. could._"

A curated list of awesome AI & ML :orange_book: tutorials, :page_with_curl: articles, :tv: videos and jupyter notebooks.

## AI in Real-world
- [Real-world usage of AI/ML](docs/ai-in-real-world.md)
## Generative AI
- [Overview & Concepts](docs/gen-ai/generative-ai.md)
### LLMs
- [Prompt Engineering Guide](docs/gen-ai/prompt-engineering-resources.md)
- [LLMs Architecture](docs/gen-ai/llms-architecture.md)
- [LLMs Benchmarking & Evaluation](docs/gen-ai/evaluation-metrics.md)
- [Fine-tune LLMs](docs/gen-ai/finetune-llms.md)
- [LLM Inference & Serving](docs/gen-ai/llm-inference.md)
  - [LLM Guardrails](https://github.com/guardrails-ai/guardrails/blob/main/README.md)
- [Autonomus AI Agents](docs/gen-ai/llm-powered-autonomous-ai-agents.md)
  - [AI Agent Architecture](docs/gen-ai/ai-agents-overview.md)
  - [LangChain](docs/gen-ai/langchain.md)
  - [Vector Databases](docs/vector-db.md)

### Diffusion Models - Text-to-Image/Videos, Image-to-Image/Videos
- [Latent Diffusion Models](docs/gen-ai/latent-diffusion.md)
- [Mulitmodality](docs/multimodality/multimodality.md)

## Machine Learning
- [Concepts](docs/ml/ml-concepts.md)
- Traditional ML Models
  - [Linear regression](docs/ml/ml-algorithms.md)
  - [Logistic regression](docs/ml/ml-algorithms.md)
  - [k-nearest neighbors](docs/ml/ml-algorithms.md)
  - [Support vector machines](docs/ml/ml-algorithms.md)
  - [Naïve bayes](docs/ml/ml-algorithms.md)
  - [k-means](docs/ml/ml-algorithms.md)
  - [Random Forest](docs/ml/ml-algorithms.md)
- [NLP](https://github.com/venkataravuri/awesome-tech-articles-blogs/blob/master/topics/architecture-design/search.md)
  - [Lexical/Keyword Search](https://github.com/venkataravuri/awesome-tech-articles-blogs/blob/master/topics/architecture-design/search.md)
  - [Semantic/Vector Search](https://github.com/venkataravuri/awesome-tech-articles-blogs/blob/master/topics/architecture-design/search.md)
  
## Neural Networks
- [Concepts](docs/nn/nn-deeplearning.md)
- [Convolutional Neural Networks](docs/nn/cnn.md)

## Basics - Algebra & Statistics
- [Algebra](docs/stats/algebra.md)
- [Statistics & Probability](docs/stats/probability.md)

## AI/ML - Interview Notes
- [ML Concepts](docs/interview-notes/interview-notes.md)
- [ML Models](docs/interview-notes/models.md)
- [Neural Netowrks](docs/interview-notes/nn-notes.md)
  - [CNN](docs/interview-notes/cnn-interview-notes.md)
- [ML System Design](docs/interview-notes/system-design.md)
- [MLOps](docs/interview-notes/mlops.md)
- [Huggingface](docs/interview-notes/huggingface.md)
- [Latent Diffusion](docs/interview-notes/diffusion.md)
- [Finetune LLMs](docs/interview-notes/finetune.md)
