# Floky Core

## Overview

Floky Core is the foundational component of the [Floky PHP framework](https://github.com/v1p3r75/Floky). It provides the essential building blocks and features for creating web applications with a focus on simplicity, flexibility, and performance.

## Features

- **MVC Architecture**: Organize your code in a clean and modular Model-View-Controller architecture.
- **Powerful Routing**: Easily manage URLs and direct requests to the appropriate controllers.
- **Database Interaction**: Simplify database interactions with the integrated ORM (Object-Relational Mapping).
- **Security Measures**: Integrate security mechanisms to protect your application against common vulnerabilities.
- **Flexible Views**: Use template engines to design dynamic and visually appealing views.
- **Dependency Container**: Efficiently manage components of your application using a dependency container.
- **Testing with Pest**: Enjoy elegant testing using Pest, a PHP testing framework.
- **Reusable Components**: Utilize libraries and tools to accelerate development.
- **Comprehensive Documentation**: A detailed guide to help you get started quickly.

## Lightweight and Efficient

Floky Core is designed to be lightweight, making it an ideal choice for smaller projects where a minimal footprint is desired. It allows for quick and efficient development without unnecessary bloat.

## Getting Started

To get started with Floky, follow these steps:

1. Install Floky Core using Composer:

   ```bash
   composer require floky/core
    ```

## Contributing

We welcome contributions to Floky Core. Feel free to open issues, submit pull requests, or join the community discussions.

## Licence

Floky Core is open-source software licensed under the [MIT Licence](https://en.wikipedia.org/wiki/MIT_License).