/* DATAS 

USA/1706464/99813/464728/15188842/330811717
Brazil/376669/23522/153833/735224/212409786
Russia/362342/3807/131129/9160590/145928485
Spain/28248/26837/196958/3556567/46753049
Italy/230158/32877/141981/3482253/60470230
France/182942/28432/65199/1384633/65259581
Germany/18083/8433/162000/3595059/83757965
Turkey/157814/4369/120015/1853754/84247422
India/146498/4187/61151/3126119/1378641054
Iran/139511/7508/109437/837090/83883203
Peru/123979/3629/50949/840922/32924686
Canada/85711/6545/44638/1482468/37709091
Saudi Arabia/74795/399/45668/722079/34757706
Chile/73997/761/29302/488041/19099822
Mexico/71105/7633/49890/225650/128796145
Pakistan/57705/1197/18314/490908/220438956
Belgium/57455/9334/15320/795447/11584702
Qatar/47207/28/11844/196411/2875978
Belarus/38059/208/15086/472906/9449619
Ecuador/37355/3203/18003/106554/17615358
Bangladesh/36751/522/7579/258550/164524398
Sweden/3444/4125/4971/209900/10093058
Singapore/32343/23/15738/294414/5845767
UAE/31086/253/15982/2072493/9878250
Portugal/31007/1342/18096/689705/10199497
Switzerland/30761/1913/28200/375115/8648347
Ireland/24698/1606/21060/295626/4932204
South Africa/23615/481/11917/596777/59232433
Indonesia/23165/1418/5877/264098/273231828
Kuwait/22575/172/7306/276207/4264055
Colombia/21981/750/5265/260812/50828154
Poland/21867/1013/10020/801753/37850537
Ukraine/21584/644/7575/301736/43757987
Romania/18429/1210/11874/385728/19249480
Egypt/17967/783/4900/135000/102130974
Israel/16743/281/14362/545761/9197590
Japan/16581/830/13612/435412/126512743
Austria/16557/643/15182/411185/9001347
Dominican Republic/15073/460/8285/69608/10836968
Philippines/14669/886/3412/307434/109431787
Argentina/12628/467/3999/133468/45154246
Afghanistan/11831/220/1128/32870/38834157
Denmark/11428/563/10044/559454/5790221
Serbia/11227/239/6067/223771/8740651
S. Korea/11225/269/10275/839475/51264961
Panama/11183/310/6279/59339/4307725
Bahrain/9223/14/4916/285373/1694805
Czechia/9004/317/6182/403358/10707069
Kazakhstan/8969/35/4560/687249/18753881
Norway/8364/235/7727/234637/5417027
Oman/8118/37/2067/72000/5092460
Nigeria/8068/233/2311/44458/205584173
Malaysia/7604/115/6041/519944/32323664
Morocco/7556/202/4841/155579/36866123
Armenia/7402/91/3220/52554/2962710
Moldova/7147/265/3884/40565/4034845
Australia/7133/102/6553/1288223/25469872
Ghana/6964/32/2097/197194/31003853
Bolivia/666/261/647/22294/11656694
Finland/6628/312/5100/171575/5539893
Iraq/4632/163/2811/194444/40125564
Azerbaijan/4271/51/2741/273411/10130034
Honduras/4189/182/473/14790/9888260
Luxembourg/3993/110/3781/68107/624919
Sudan/3976/170/503/401/43738792
Hungary/3771/499/1836/166263/9662656
Guatemala/376/59/274/31427/17880705
Uzbekistan/3281/13/2624/460000/33419241
Guinea/3275/20/1673/14407/13093597
Senegal/3161/36/1565/35016/16695568
Thailand/3045/57/2929/375453/69783058
Greece/2882/172/1374/155037/10427777
Djibouti/2468/14/1079/23140/986520
Bulgaria/2443/130/880/74834/6953227
Ivory Coast/2423/30/1257/24317/26307273
Bosnia and Herzegovina/2416/149/1721/60528/3282698
Croatia/2244/101/2046/63682/4107599
Gabon/2135/14/562/9908/2220060
El Salvador/2042/36/787/77482/6483000
North Macedonia/2014/116/1453/25841/2083382
Cuba/1947/82/1704/94060/11327273
Estonia/1834/65/1552/78085/1326450
Iceland/1804/10/1791/58856/341024
Lithuania/1639/65/1165/275058/2725640
Mayotte/1609/20/894/5200/272102
Slovakia/1513/28/1322/160523/5459389
New Zealand/1504/21/1461/263156/4818333
Slovenia/1469/108/1346/77138/2078911
Kyrgyzstan/1468/16/1015/100488/6512990
Maldives/1395/4/155/11775/539547
Kenya/1286/52/402/61971/53644375
Sri Lanka/1206/10/712/56181/21404496
Guinea-Bissau/1178/7/42/1500/1962975
Venezuela/1177/10/302/832526/28443500
Lebanon/114/26/689/75813/6828287
Hong Kong/1066/4/1033/202930/7490925
Haiti/1063/31/22/3115/11388384
Mali/1059/67/604/3483/20186088
Latvia/1053/22/741/101598/1888068
Tunisia/1051/48/919/48476/11806151
Equatorial Guinea/1043/12/165/854/1397760
Albania/1029/33/803/13506/2878095
Niger/951/62/786/5989/24105596
Costa Rica/951/10/628/23580/5089461
Cyprus/937/17/594/103814/1206488
Zambia/92/7/336/20011/18327041
Paraguay/865/11/344/25216/7123619
South Sudan/806/8/6/3356/11180404
Uruguay/787/22/629/38695/3472561
Nepal/772/4/155/152391/29081827
Andorra/763/51/663/3750/77253
Georgia/732/12/537/50208/3989889
Jordan/711/9/479/165109/10192951
Ethiopia/701/6/167/87264/114654045
San Marino/666/42/275/4079/33924
CAR/652/1/22/11570/4820985
Malta/611/6/485/63087/441429
Madagascar/586/2/147/9340/27613258
Channel Islands/559/45/517/10255/173702
Jamaica/556/9/238/10570/2959906
Taiwan/441/7/416/71101/23812627
Palestine/423/3/357/44876/5088625
Cabo Verde/39/3/155/1307/555377
Togo/386/13/161/17049/8257779
Isle of Man/336/24/305/4569/84989
Mauritius/334/10/322/104639/1271565
Montenegro/324/9/315/10167/628058
Sao Tome and Principe/299/11/4/175/218731
Mauritania/262/9/15/2583/4636268
Eswatini/256/2/158/4994/1158954
Yemen/233/44/10/120/29755574
Mozambique/209/1/71/8796/31158631
Benin/208/3/118/28015/12088427
Myanmar/203/6/123/20322/54373757

/* LIBRARY AND GLOBAL VARIABLE DEFINITIONS */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define MAX 134
int last;  // Number of total countries
/* STRUCT DEFINITIONS */
struct covid19{
	char countryName[99];
	int totalCases;
	int totalDeaths;
	int totalRecovered;
	int totalTestnum;
	int countryPopulation;
};
/* FUNCTION DEFINITIONS */
void readData(char [],struct covid19 []);
void showData(char [],struct covid19 []);
void insertData(struct covid19 []);
void removeData(struct covid19 []);
void updateData(struct covid19 []);
void sortCases(struct covid19 []);
void sortDeaths(struct covid19 []);
void top5(struct covid19 []);
void recent(struct covid19 []);
/* MAIN FUNCTION */
int main (void)
{
	int choice;
	char filename[99],countryname[99];
	struct covid19 cases[MAX];

	
	/* Main Menu and choosing an operator */
	do {
		printf("******************************************************************\n");
		printf("\t1. Read data from file\n");
		printf("\t2. Show Country data\n");
		printf("\t3. Insert Country data\n");
		printf("\t4. Remove Country Data\n");
		printf("\t5. Update Country data\n");
		printf("\t6. Sort Covid data based on total cases\n");
		printf("\t7. Sort Covid data based on total deaths\n");
		printf("\t8. Find and display the top 5 countries with largest number of cases per person\n");
		printf("\t9. Write recent data to file 'recent.txt' \n");
		printf("\t10. Exit\n");
		printf("******************************************************************\n");
		
		printf("\tChoose the task (0-10): ");
		scanf("%d", &choice);
		
		switch (choice)
		{
			case 1: // Read data from file
				printf("\nInput name of the file : "); // Inputting file name
				scanf("%s", &filename);
				
				readData(filename,cases);
				break;
				
			case 2: // Show country data
				printf("\nInput name of the country: ");
				scanf("%s", &countryname);
				
				showData(countryname,cases);
				break;
			
			
			case 3: // Insert country data
				insertData(cases);
				break;
			
				
			case 4:  // Remove country data
				removeData(cases);
				break;
				
			
			case 5:  // Update country data
				updateData(cases);
				break;
				
				
			case 6:  // Sort Covid data based on total cases
				sortCases(cases);
				break;
				
				
			case 7: // Sort Covid data based on total deaths
				sortDeaths(cases);
				break;
			
				
			case 8:  // Find and display the top 5 countries with largest number of cases per person
				top5(cases);
				break;
			
				
			case 9:  // Write recent data to file "recent.txt"
				recent(cases);
				break;
		}	
	}
	while (choice != 10);  // If choice is 10, exit.
	printf("Bye...");
	return(0);	
}

/* readData FUNCTION */
void readData(char filename[],struct covid19 data[])
{
	int i=0,x;
	char line[999];
	char *delp;  // To use in strtok function, it is pointer.
	FILE *readFile; // Open the file
	readFile = fopen(filename,"r"); // Read mode
	
	/* Error Checking */
	if (readFile == NULL) 
	{
		printf("The file could not be opened !\n"); 
		printf("Returning to the main menu...\n\n");
	}

	else
	{
		while (fscanf(readFile,"%s",&line) != EOF )  // Get the line in the text file
		{
			/* This check for seperate the countries which have two or three names, Like "S. Korea" */
			if (strlen(line) < 25)   
			{
				fscanf(readFile,"%s",&line);
				if (strlen(line) < 25)
				{
					fscanf(readFile,"%s",&line);
					if (strlen(line) < 25)
					{
						fscanf(readFile,"%s",&line);
					}
				}
			}
			
				
			last++;  // �ncrease total country number
			delp = strtok(line,"/");  // Split the string in line from '/' character
			x=0;
			while (delp != NULL)
			{
				if (x==0) // To store the country name
				{
					strcpy(data[i].countryName,delp);
				}
				else if (x==1)	// To store the total cases
				{	
					data[i].totalCases = atoi(delp);  // String converted to integer by using atoi function
				}
				else if (x==2)	// To store the total deaths
				{	
					data[i].totalDeaths = atoi(delp);
				}
				else if (x==3)	// To store the total recovered number
				{	
					data[i].totalRecovered = atoi(delp);
				}
				else if (x==4)	// To store the total test number
				{	
					data[i].totalTestnum = atoi(delp);
				}
				else if (x==5)	// To store the country population
				{	
					data[i].countryPopulation = atoi(delp);
				}
				delp = strtok(NULL,"/"); // To skip the other string which after from '\' character
				x++;  // To skip the other storing operation
			}
			i++;
		}
		printf("-----> %d countries imported succesfully <-----\n",last);
		printf("Returning to the main menu...\n\n");
		fclose(readFile); // The file is closing
	} 
}
/* showData FUNCTION */
void showData(char countryname[],struct covid19 data[])
{
	int i,storage,flag=0;
	
	for (storage=0;storage<last;storage++)
	{
		if (strcmp(data[storage].countryName,countryname)==0)  // Country name inputted from user is searching in the array of structure 
		{
			i = storage; // �ndex is stored
			/* Display the country datas */ 
			printf("Country Name\t\t: %s\n",data[i].countryName);
			printf("Total Cases\t\t: %d\n",data[i].totalCases);
			printf("Total Deaths\t\t: %d\n",data[i].totalDeaths);
			printf("Total Recovered\t\t: %d\n",data[i].totalRecovered);
			printf("Total Test Number\t: %d\n",data[i].totalTestnum);
			printf("Country Population\t: %d\n\n",data[i].countryPopulation);
			flag = 1;  // If country name inputted from user founded in array of structure, flag = 1, otherwise, it stayed 0.
		}
	}
	if (flag==0) // If could not be founded in structure
	{
		printf("\n***ERROR***\n");
		printf("Country could not be founded!\n");
		printf("Returning to the main menu...\n\n");
	}
}

/* insertData FUNCTION */
void insertData(struct covid19 data[])
{
	char countryname[99];
	int i,flag=0;
	
	printf("Input name of the country : "); // Input country name from user
	scanf("%s",&countryname);
	
	for (i=0;i<last;i++)
	{
		if (strcmp(data[i].countryName,countryname)==0) // Country name inputted from user is searching in the array of structure  
		{
			printf("This country data exist in the dataset\n\n"); // If country name is already exist, this message will be displayed.
			flag=1;
		}
	}
	if (flag==0) // If country name is not exist, run this case
	{
		strcpy(data[last].countryName,countryname); // New country name is copied to the array of structure
		
		printf("Enter the total case : ");  // Inputting and storing the total case
		scanf("%d", &data[last].totalCases);
		
		printf("Enter the total deaths : ");	// Inputting the total deaths
		scanf("%d", &data[last].totalDeaths);
		
		printf("Enter the total recovered : ");	// Inputting the total recovered
		scanf("%d", &data[last].totalRecovered);
		
		printf("Enter the total test number : ");	// Inputting the total case
		scanf("%d", &data[last].totalTestnum);
		
		printf("Enter the country population : ");	// Inputting the countryPopulation
		scanf("%d", &data[last].countryPopulation);
		
		printf("Data is inserted \n");
	}
	last+=1;  // Country number is increased


	printf("Returning to the main menu...\n\n");	
}

/* removeData FUNCTION */
void removeData(struct covid19 data[])
{
	char countryname[99];
	int i,flag=1,storage;
	printf("Input name of the country : ");
	scanf("%s",&countryname);
	
	for (i=0;i<last;i++)
	{
		if (strcmp(data[i].countryName,countryname)==0)	// Country name inputted from user is searching in the array of structure  
		{
			storage = i;
			flag=0; // If data is exist, set flag = 0;
		}
	}
	if (flag==0)
	{
		// Removing and re-ordering
		for (storage;storage<last;storage++)  
		{
			strcpy(data[storage].countryName,data[storage+1].countryName);
			data[storage].totalCases=data[storage+1].totalCases;
			data[storage].totalDeaths=data[storage+1].totalDeaths;
			data[storage].totalRecovered=data[storage+1].totalRecovered;
			data[storage].totalTestnum=data[storage+1].totalTestnum;
			data[storage].countryPopulation=data[storage+1].countryPopulation;
		}
		last-=1; // Country number is decreased
		printf("The data is deleted\n");
	}
	else // If data not exist
		printf("This country data not exist in the dataset\n");
		printf("Returning to the main menu...\n\n");	
}
/* updateData FUNCTION */
void updateData(struct covid19 data[])
{
	char countryname[99];
	int i,storage,flag=1;
	printf("Enter name of the country: ");
	scanf("%s", &countryname);
	
	for (i=0;i<last;i++)
	{
		if (strcmp(data[i].countryName,countryname)==0)	// Country name inputted from user is searching in the array of structure 
		{
			storage = i;
			flag=0;	// If data is exist, set flag = 0;
		}
	}
	if (flag==0)
	{
		// Updating
		printf("Enter the new total case : ");
		scanf("%d", &data[storage].totalCases);
		
		printf("Enter the new total deaths : ");
		scanf("%d", &data[storage].totalDeaths);
		
		printf("Enter the new total recovered : ");
		scanf("%d", &data[storage].totalRecovered);
		
		printf("Enter the new total case : ");
		scanf("%d", &data[storage].totalTestnum);
		
		printf("Enter the new country population : ");
		scanf("%d", &data[storage].countryPopulation);
	}
	else	// If data not exist
		printf("This country data not exist in the dataset\n");
		printf("Returning to the main menu...\n\n");
}
/* sortCases FUNCTION */
void sortCases(struct covid19 data[])
{
	int i,j;
	struct covid19 storage;
	char selection;
	printf("Sorting...\n");
	
	// Sorting based on total cases
	for (i=0;i<last;i++)
	{
		for (j=0;j<last-1;j++)
		{
			if (data[j].totalCases < data[j+1].totalCases)
			{
				storage = data[j];
				data[j] = data[j+1];
				data[j+1] = storage;
			}
		}
	}
	printf("Done...\n");
	
	// Asking user to print the modified list
	printf("Do you want to list modified datas ? (Y/N): ");
	scanf(" %c",&selection);
	
	if (selection == 'Y' || selection == 'y' ) // Yes ( Y )
	{
		for (i=0;i<last;i++)
		{
			printf("%s %d %d %d %d %d\n",data[i].countryName,data[i].totalCases,data[i].totalDeaths,data[i].totalRecovered,data[i].totalTestnum,data[i].countryPopulation);
		}
	}
	else // No ( N )
		printf("Returning to the main menu...\n\n");
}
/* sortDeaths FUNCTION */
void sortDeaths(struct covid19 data[])
{
	int i,j;
	char selection;
	struct covid19 storage;
	printf("Sorting...\n");
	
	// Sorting based on total deaths
	for (i=0;i<last;i++)
	{
		for (j=0;j<last-1;j++)
		{
			if (data[j].totalDeaths < data[j+1].totalDeaths)
			{
				storage = data[j];
				data[j] = data[j+1];
				data[j+1] = storage;
			}
		}
	}
	printf("Done...\n");
	
	// Asking user to print the modified list
	printf("Do you want to list modified datas ? (Y/N): ");
	scanf(" %c",&selection);
	
	if (selection == 'Y' || selection == 'y' ) // Yes ( Y )
	{
		for (i=0;i<last;i++)
		{
			printf("%s %d %d %d %d %d\n",data[i].countryName,data[i].totalCases,data[i].totalDeaths,data[i].totalRecovered,data[i].totalTestnum,data[i].countryPopulation);
		}
	}
	else // No ( N )
		printf("Returning to the main menu...\n\n");
}
/* top5 FUNCTION */
void top5(struct covid19 data[])
{
	int i,j,k=0;
	
	// New array of structure defined because of store the ratio
	struct covid19{
		char countryName[99];
		double ratio; // Ratio will be equal to countryPopulation dividing by totalCases
	}casesperPerson[last],storage;
	
	// Calculating ratio and storing to the array of structure
	for (i=0;i<last;i++)
	{
		casesperPerson[i].ratio = data[i].countryPopulation / data[i].totalCases;
		strcpy(casesperPerson[i].countryName,data[i].countryName);
	}
	
	// Ordering
	for (i=0;i<last;i++)
	{
		for (j=0;j<last-1;j++)
		{
			if (casesperPerson[j].ratio < casesperPerson[j+1].ratio)
			{
				storage = casesperPerson[j];
				casesperPerson[j] = casesperPerson[j+1];
				casesperPerson[j+1] = storage;
			}
		}
	}
	
	printf("\nThe top 5 countriest largest number of cases per person:  \n");
	// Displaying the top 5 countries and their ratio values.
	for (i=0;i<5;i++)
		printf("%s -> %.1f\n",casesperPerson[i].countryName,casesperPerson[i].ratio);
	
	printf("\nDone\n");
	printf("Returning to the main menu...\n\n");
}
/* recent FUNCTION */
void recent(struct covid19 data[])
{
	int i;
	FILE *writeFile;  // The file is opening
	writeFile = fopen("recent.txt","w"); // Write mode
	
	/* Error Checking */
	if (writeFile == NULL) 
	{
		printf("The file could not be opened !\n"); 
		printf("Returning to the main menu...\n\n");
	}
	else
	{
		printf("Copying is starting...\n");
		for (i=0;i<last;i++)
		{
			fprintf(writeFile,"%s/%d/%d/",data[i].countryName,data[i].totalCases,data[i].totalDeaths);
			fprintf(writeFile,"%d/%d/%d\n",data[i].totalRecovered,data[i].totalTestnum,data[i].countryPopulation);
		}
		printf("Done. All datas copied in 'recent.txt'. \n");
	}
	
	fclose(writeFile); // The file is closing

	printf("Returning to the main menu...\n\n");
}
