### Resources if you are contributing First Time 😎

- [How to begin with Open Source](https://medium.com/@utkarsh06/open-source-for-beginners-the-endgame-7da09bf80c0d)
- [The Open Source Playlist](https://www.youtube.com/playlist?list=PLJHIvga3HLZz_oYBYScgA3IpS4pCFof5n)

### CONTRIBUTING GUIDELINES
We are happy to welcome all the contributions from anyone willing to improve this project. <br>
Thank you for helping out and remember, **no contribution is too small**. <br>
<br>
- **Guideline 1** : Add only the problems which have been a part of **Daily LeetCode Challenge for 2022 & 2023**
- **Guideline 2** : Update the README as per your question.
- **Guideline 3** : Contribute only **single question** at a time.
- **Guideline 4** : Add any problem if it is not present in the folder.
- **Guideline 5** : Code must be ```written in C++``` and should be saved with the ```extension .cpp```.
- **Guideline 6** : If any problem is important in perspective for the interviews, mark it as 💡
- **Guideline 7** : **Add the approach** with proper comments, along with its Time and Space Complexity.
- **Guideline 8** : Use Braces from the **next line** in your code.
- **Guideline 9** : Add the **explanation of the problem** if it is not there.
<br>

👻 **Now, Follow these steps :-**
### Step 1 : Create an issue
- Give proper Issue Title such as : ```Jan1 2022 - TwoSum Problem ```
- Give Problem Link in the description of the issue.

### Step 2 : Fork the Project
- Fork this Repository. This will create a Local Copy of this Repository on your Github Profile. Keep a reference to the original project in upstream remote.
- ```$ git clone https://github.com/<your-username>/LeetCode-Grind```
- ```$ cd LeetCode-Grind```
- ```$ git remote add upstream https://github.com/utkarsh006/LeetCode-Grind```

### Step 3 : Branch
- Create a new branch. Use its name to identify the issue your addressing.
- It will create a new branch with name Branch_Name and switch to that branch.
- ```$ git checkout -b branch_name```

### Step 4 : Work on the issue assigned
-  Work on the issue assigned to you.
-  Add all the files/folders needed.
- After you've made changes or made your contribution to the project add changes to the branch you've just created.
- ```To add all new files to branch Branch_Name```
- ```$ git add .```
### Step 5 : Commit
- This message get associated with all files you have changed.
- ```$ git commit -m "message"```
### Step 6 : Work Remotely
- Push your work to your remote repository.
- ```$ git push -u origin Branch_Name```

### Step 7 : Pull Request
- Go to your repository in browser and click on `compare and pull requests`. Then add a title and description to your pull request that explains your contribution.

- Your Pull Request has been submitted and will be reviewed by the moderators and merged 😎
- **Delete the branch** after your PR gets merged as a good coding practice.



