# RosettaStone

<img src="./Medias/Logos/Logo.png" width=256 height=256 />

[![License](https://img.shields.io/badge/Licence-AGPLv3-blue.svg)](https://github.com/utilForever/RosettaStone/blob/main/LICENSE)
![Windows](https://github.com/utilForever/RosettaStone/workflows/Windows/badge.svg)
![Ubuntu](https://github.com/utilForever/RosettaStone/workflows/Ubuntu/badge.svg)
![macOS](https://github.com/utilForever/RosettaStone/workflows/macOS/badge.svg)
[![Discord](https://img.shields.io/discord/483192043737186335.svg)](https://discord.gg/6R3UueR)

[![codecov](https://codecov.io/gh/utilForever/RosettaStone/branch/main/graph/badge.svg)](https://codecov.io/gh/utilForever/RosettaStone)
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/df6a02e1358f4e719e7bebb9a728d2ab)](https://www.codacy.com/app/utilForever/RosettaStone?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=utilForever/RosettaStone&amp;utm_campaign=Badge_Grade)
[![CodeFactor](https://www.codefactor.io/repository/github/utilforever/RosettaStone/badge)](https://www.codefactor.io/repository/github/utilforever/RosettaStone)

[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=RosettaStone&metric=alert_status)](https://sonarcloud.io/dashboard?id=RosettaStone)
[![Lines of Code](https://sonarcloud.io/api/project_badges/measure?project=RosettaStone&metric=ncloc)](https://sonarcloud.io/dashboard?id=RosettaStone)
[![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=RosettaStone&metric=sqale_rating)](https://sonarcloud.io/dashboard?id=RosettaStone)
[![Reliability Rating](https://sonarcloud.io/api/project_badges/measure?project=RosettaStone&metric=reliability_rating)](https://sonarcloud.io/dashboard?id=RosettaStone)
[![Security Rating](https://sonarcloud.io/api/project_badges/measure?project=RosettaStone&metric=security_rating)](https://sonarcloud.io/dashboard?id=RosettaStone)

RosettaStone is Hearthstone simulator using C++ with some reinforcement learning. The code is built on C++17 and can be compiled with commonly available compilers such as g++, clang++, or Microsoft Visual Studio. RosettaStone currently supports macOS (10.14 or later), Ubuntu (18.04 or later), Windows (Visual Studio 2017 or later), and Windows Subsystem for Linux (WSL). Other untested platforms that support C++17 also should be able to build RosettaStone.

## Related Repositories

  * [RosettaStone GUI](https://www.github.com/utilforever/RosettaStone-GUI)

## Key Features

  * C++17 based Hearthstone library
  * Console and GUI simulator program
  * C++ and Python API

## To-do Features

  * Upgrade "The Innkeeper" to smart
  * Recommend top-tier decks
  * Deck tracker
  * Web simulator

## Cards Implementation

### Standard Format

  * 98% Core Set (247 of 250 cards)
  * 81% Forged in the Barrens (139 of 170 cards)
  * 35% United in Stormwind (60 of 170 cards)
  * 35% Fractured in Alterac Valley (61 of 170 cards)
  * 12% Voyage to the Sunken City (22 of 170 cards)
  * 10% Murder at Castle Nathria (17 of 170 cards)
  * 0% March of the Lich King (0 of 1 cards)

### Wild Format

  * **100% Legacy (167 of 167 Cards)**
  * **100% Expert1 (245 of 245 Cards)**
  * **100% Demon Hunter Initiate (20 of 20 Cards)**
  * **100% Curse of Naxxramas (30 of 30 Cards)**
  * 6% Goblins vs Gnomes (8 of 123 Cards)
  * **100% Blackrock Mountain (31 of 31 Cards)**
  * 8% The Grand Tournament (11 of 132 Cards)
  * **100% The League of Explorers (45 of 45 Cards)**
  * 5% Whispers of the Old Gods (8 of 134 Cards)
  * **100% One Night in Karazhan (45 of 45 Cards)**
  * 2% Mean Streets of Gadgetzan (3 of 132 Cards)
  * 7% Journey to Un'Goro (10 of 135 Cards)
  * 4% Knights of the Frozen Throne (6 of 135 Cards)
  * 5% Kobolds & Catacombs (7 of 135 Cards)
  * 5% The Witchwood (8 of 135 Cards)
  * 2% The Boomsday Project (4 of 136 Cards)
  * 5% Rastakhan's Rumble (7 of 135 Cards)
  * **100% Rise of Shadows (136 of 136 cards)**
  * **99% Saviors of Uldum (134 of 135 cards)**
    * Except 'Zephrys the Great' (ULD_003)
  * **100% Descent of Dragons (140 of 140 cards)**
  * 60% Galakrond's Awakening (21 of 35 cards)
  * 60% Ashes of Outland (82 of 135 cards)
  * 57% Scholomance Academy (78 of 135 cards)
  * 46% Madness at the Darkmoon Faire (79 of 170 cards)

### Classic Format

  * **100% Vanilla Set (382 of 382 Cards)**

## Implementation List

  * [Ability list](./Documents/AbilityList.md)
  * Card list
    * [Standard Format](./Documents/CardList%20-%20Standard.md)
    * [Wild Format](./Documents/CardList%20-%20Wild.md)
    * [Classic Format](./Documents/CardList%20-%20Classic.md)
  * [Task list](./Documents/TaskList.md)

## Quick Start

You will need CMake to build the code. If you're using Windows, you need Visual Studio 2017 in addition to CMake.

First, clone the code:

```
git clone https://github.com/utilForever/RosettaStone.git --recursive
cd RosettaStone
```

### Python API

Build and install the package by running

```
pip install -U .
```

**NOTE**: We are making Python API and related examples.

### C++ API

For macOS or Linux or Windows Subsystem for Linux (WSL):

```
mkdir build
cd build
cmake ..
make
```

For Windows:

```
mkdir build
cd build
cmake .. -G"Visual Studio 15 2017 Win64"
MSBuild RosettaStone.sln /p:Configuration=Release
```

Now run console simulator:

```
bin/RosettaConsole
```

**NOTE**: To run GUI simulator, please check out [RosettaStone GUI](https://www.github.com/utilforever/RosettaStone-GUI).

### Docker

```
docker pull utilforever/rosettastone:latest
```

Now run console simulator:

```
docker run -it utilforever/rosettastone
[inside docker container]
/app/build/bin/RosettaConsole
```

### More Instructions of Building the Code

To learn how to build, test, and install the SDK, please check out [Install.md](./Documents/Install.md).

## Documentation

All the documentations for the framework can be found from [the project website](https://utilforever.github.io/RosettaStone/) incluing the API reference.

## Presentations

  * [TFCON 2018 Poster Session](./Medias/Presentations/TFCON%202018%20-%20Hearthstone%2B%2B%2C%20Hearthstone%20Simulator%20with%20Reinforcement%20Learning.pdf)
  * [NDC 2019](./Medias/Presentations/NDC%202019%20-%20Development%20Process%20of%20Hearthstone%20Reinforcement%20Learning%20Environment%20(Korean).pdf)

## Videos
  
  * [NDC 2019](https://www.youtube.com/watch?v=yO9QRinXosE)

## Sprints

  * [PyCon Korea 2018 Sprint Session](https://archive.pycon.kr/2018/program/sprint/3)
  * [Sprint Seoul - April 2019](https://sprintseoul.org/)

## Articles

  * NDC 2019
    * [[NDC2019] 하스스톤을 위한 '알파고'를 만들 수는 없을까? - 인벤](http://www.inven.co.kr/webzine/news/?news=219330&site=hs)
    * [[NDC 19] '알파고' 같은 하스스톤 인공지능을 만들기 위한 험난한 여정 - 디스이즈게임](http://www.thisisgame.com/webzine/gameevent/nboard/227/?n=93644)
    * [[NDC2019 #11] 넥슨 프로그래머의 ‘하스스톤’ A·I 제작기 - 경향게임스](http://www.khgames.co.kr/news/articleView.html?idxno=118028)
    * [[NDC 2019] 넥슨 프로그래머의 ‘하스스톤’ AI 도전기 - OSEN](http://www.osen.co.kr/article/G1111130399)

## How To Contribute

Contributions are always welcome, either reporting issues/bugs or forking the repository and then issuing pull requests when you have completed some additional coding that you feel will be beneficial to the main project. If you are interested in contributing in a more dedicated capacity, then please check out [Contributing.md](./Documents/Contributing.md).

  * [Code of Conduct](./Documents/CodeOfConduct.md)
  * [Issues](./Documents/Issues.md)
    * [How to Contribute in Issues](./Documents/Issues.md#how-to-contribute-in-issues)
    * [Asking for General Help](./Documents/Issues.md#asking-for-general-help)
    * [Submitting a Bug Report](./Documents/Issues.md#submitting-a-bug-report)
    * [Triaging a Bug Report](./Documents/Issues.md#triaging-a-bug-report)
    * [Resolving a Bug Report](./Documents/Issues.md#resolving-a-bug-report)
  * [Pull request](./Documents/PullRequests.md)
    * [Setting up your local environment](./Documents/PullRequests.md#setting-up-your-local-environment)
    * [Making Changes](./Documents/PullRequests.md#making-changes)
    * [How to add card](./Documents/HowToAddCard.md)
    * [How to add task](./Documents/HowToAddTask.md)

## Contact

You can contact me via e-mail (utilForever at gmail.com). I am always happy to answer questions or help with any issues you might have, and please be sure to share any additional work or your creations with me, I love seeing what other people are making.

## Sponsors

[![CppDepend](./Medias/Logos/CppDepend.png)](http://www.cppdepend.com)

## License

<img align="right" src="http://opensource.org/trademarks/opensource/OSI-Approved-License-100x137.png">

The class is licensed under the [Affero GPLv3 License](https://opensource.org/licenses/AGPL-3.0):

RosettaStone is based on part of Sabberstone's code

Copyright &copy; 2017-2021 SabberStone Team, darkfriend77 & rnilva

RosettaStone, Hearthstone simulator using C++ with some reinforcement learning

Copyright &copy; 2017-2024 [Chris Ohk](https://github.com/utilForever)

RosettaStone is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License. RosettaStone is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.

Hearthstone is an interactive game of Blizzard Entertainment, Inc and all rights reserved. Hearthstone is a registered trademark of Blizzard Entertainment, Inc. in the U.S. and/or other countries. This project is not affiliated with Blizzard Entertainment.
