// Copyright (c) 2019 Chris Ohk, Youngjoong Kim, SeungHyun Jeon

// We are making my contributions/submissions to this project solely in our
// personal capacity and are not conveying any rights to any intellectual
// property of any third parties.

#ifndef ROSETTASTONE_PLAYMODE_DECK_CODE_HPP
#define ROSETTASTONE_PLAYMODE_DECK_CODE_HPP

#include <Rosetta/PlayMode/Decks/Deck.hpp>

#include <string_view>

namespace RosettaStone::PlayMode
{
class DeckCode
{
 public:
    //! Decodes a deck code and returns the deck that contains some cards.
    //! \param deckCode The deck code generated by Hearthstone.
    //! \return The decoded deck that contains card information.
    static Deck Decode(std::string_view deckCode);
};
}  // namespace RosettaStone::PlayMode

#endif  // ROSETTASTONE_PLAYMODE_DECK_CODE_HPP
