// This code is based on Sabberstone project.
// Copyright (c) 2017-2019 SabberStone Team, darkfriend77 & rnilva
// RosettaStone is hearthstone simulator using C++ with reinforcement learning.
// Copyright (c) 2019 Chris Ohk, Youngjoong Kim, SeungHyun Jeon

#ifndef ROSETTASTONE_BATTLEGROUNDS_COUNT_TASK_HPP
#define ROSETTASTONE_BATTLEGROUNDS_COUNT_TASK_HPP

#include <Rosetta/Battlegrounds/Conditions/SelfCondition.hpp>
#include <Rosetta/Common/Enums/TaskEnums.hpp>

namespace RosettaStone::Battlegrounds
{
class Card;
class Minion;
class Player;

namespace SimpleTasks
{
//!
//! \brief CountTask class.
//!
//! This class represents the task for counting minions.
//!
class CountTask
{
 public:
    //! Constructs task with given \p entityType, \p numIndex and \p conditions.
    //! \param entityType The type of entity.
    //! \param numIndex An index of number.
    //! \param conditions SelfConditions to check.
    explicit CountTask(EntityType entityType, int numIndex = 0,
                       std::vector<SelfCondition> conditions = {});

    //! Runs task logic internally and returns meta data.
    //! \param player The player to run task.
    //! \param source The source minion.
    //! \return The result of task processing.
    TaskStatus Run(Player& player, Minion& source);

    //! Runs task logic internally and returns meta data.
    //! \param player The player to run task.
    //! \param source The source minion.
    //! \param target The target minion.
    //! \return The result of task processing.
    TaskStatus Run(Player& player, Minion& source, Minion& target);

 private:
    EntityType m_entityType = EntityType::INVALID;
    std::vector<SelfCondition> m_conditions;
    int m_numIndex = 0;
};
}  // namespace SimpleTasks
}  // namespace RosettaStone::Battlegrounds

#endif  // ROSETTASTONE_BATTLEGROUNDS_COUNT_TASK_HPP
