// Copyright (c) 2017-2024 Chris Ohk

// We are making my contributions/submissions to this project solely in our
// personal capacity and are not conveying any rights to any intellectual
// property of any third parties.

#include <Python/PlayMode/Utils/DeckCode.hpp>
#include <Rosetta/PlayMode/Utils/DeckCode.hpp>

#include <pybind11/pybind11.h>

using namespace RosettaStone::PlayMode;

void AddDeckCode(pybind11::module& m)
{
    pybind11::class_<DeckCode>(m, "DeckCode")
        .def_static(
            "decode", &DeckCode::Decode,
            R"pbdoc(Decodes a deck code and returns the deck that contains some cards.

            Parameters
            ----------
            deck_code : The deck code generated by Hearthstone.)pbdoc",
            pybind11::arg("deck_code"));
}
