# Contributing to RosettaStone

Contributions to RosettaStone include code, documentation, answering user questions and so on.

RosettaStone project welcomes all contributions from anyone willing to work in
good faith with other contributors and the community. No contribution is too
small and all contributions are valued.

This guide explains the process for contributing to the RosettaStone project code and describes what to expect at each step.

## [Code of Conduct](./CodeOfConduct.md)

RosettaStone project has a
[Code of Conduct](./CodeOfConduct.md)
that *all* contributors are expected to follow. This code describes the
*minimum* behavior expectations for all contributors.

## [Issues](./Issues.md)

Issues in RosettaStone are the primary means by which bug reports and
general discussions are made.

* [How to Contribute in Issues](./Issues.md#how-to-contribute-in-issues)
* [Asking for General Help](./Issues.md#asking-for-general-help)
* [Submitting a Bug Report](./Issues.md#submitting-a-bug-report)
* [Triaging a Bug Report](./Issues.md#triaging-a-bug-report)
* [Resolving a Bug Report](./Issues.md#resolving-a-bug-report)

## [Pull Requests](./PullRequests.md)

Pull Requests are the way concrete changes are made to the code, documentation,
dependencies, and tools contained in the RosettaStone.

* [Setting up your local environment](./PullRequests.md#setting-up-your-local-environment)
* [Making Changes](./PullRequests.md#making-changes)
* [How to add card](./HowToAddCard.md)
* [How to add task](./HowToAddTask.md)

<a id="developers-certificate-of-origin"></a>
## Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

* (a) The contribution was created in whole or in part by me and I
  have the right to submit it under the open source license
  indicated in the file; or

* (b) The contribution is based upon previous work that, to the best
  of my knowledge, is covered under an appropriate open source
  license and I have the right under that license to submit that
  work with modifications, whether created in whole or in part
  by me, under the same open source license (unless I am
  permitted to submit under a different license), as indicated
  in the file; or

* (c) The contribution was provided directly to me by some other
  person who certified (a), (b) or (c) and I have not modified
  it.

* (d) I understand and agree that this project and the contribution
  are public and that a record of the contribution (including all
  personal information I submit with it, including my sign-off) is
  maintained indefinitely and may be redistributed consistent with
  this project or the open source license(s) involved.