#pragma once

/*
 * Copyright (C) 2022 LEIDOS.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

#include <iostream>
#include <vector>

namespace guidance
{

  /**
   * \brief Stuct containing the algorithm configuration values for GuidanceWorker
   */
  struct Config
  {
    double spin_rate_hz = 10.0; // (Hz) The rate at which the Guidance Node will process messages

    // Stream operator for this config
    friend std::ostream &operator<<(std::ostream &output, const Config &c)
    {
      output << "guidance::Config { " << std::endl
           << "spin_rate_hz: " << c.spin_rate_hz << std::endl
           << "}" << std::endl;
      return output;
    }
  };

} // guidance