# CARMA cooperative perception stack

The `carma_cooperative_perception` package contains the cooperative perception stack used in CARMA Platform.
It wraps the `multiple_object_tracking` library in a ROS 2 interface. The stack provides two main functionalities.
The multiple object tracking functionality aggregates object data from incoming Sensor Data Sharing Messages (SDSMs),
Basic Safety Messages (BSMs), and local sensors. The sensor data sharing functionality broadcasts SDSMs containing
object data generated by the host’s local sensors. Parts of the stack can be disabled to support CARMA Platform
vehicles with different sensor and computational capabilities. CARMA Platform deployments that include this package can
collaborate with other agents that also share object tracking information to compose a cooperative perception network.

> [!IMPORTANT]\
> **Current limitations:** The package currently does not support BSMs.

## CMake options

The table below contains package-specific CMake options.

| Option                                     | Default value      | Description                |
| ------------------------------------------ | ------------------ | -------------------------- |
| `carma_cooperative_perception_BUILD_TESTS` | `${BUILD_TESTING}` | Build the package's tests. |

## Documentation

For information about the package's nodes, launch configurations, and other ROS 2 specific items, check out the
[package design][package_design_link] page. For details about the CARMA cooperative perception stack in general, check
out the [stack design][stack_design_link] page.

[package_design_link]: docs/package_design.md
[stack_design_link]: docs/stack_design.md
