<?php
/*
Copyright 2022 Micah Baumann

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

$curDirectory = str_replace('\\', '/', substr(__DIR__, strlen($_SERVER['DOCUMENT_ROOT'])).'/');
if (isset($_POST['settings'])) {
	$base = $_POST['base'];
	if (empty($base)) {
		$base = $curDirectory;
	}

	$settings = $_POST['settings'];

	if (isset($_POST['delete'])) {
		$delete = $_POST['delete'];
	} else {
		$delete = 'false';
	}

	if (isset($_POST['deleteUpdate'])) {
		$deleteUpdate = $_POST['deleteUpdate'];
	} else {
		$deleteUpdate = 'false';
	}

	if (empty($settings)) {
		header('Location: urls_install.php?error=1&base='.urlencode($base).'&delete='.urlencode($delete).'&deleteUpdate='.urlencode($deleteUpdate));
		exit();
	}
	

	if ($htaccess = fopen('.htaccess', 'a')) {
		fwrite($htaccess, "# --URLS BEGIN--\n# The following lines between \"--URLS BEGIN--\" and \"--URLS END--\" are\n# automatically generated by the URLS framework. These lines should\n# not be edited as it may result in unwanted behavior of the site. Any\n# edits made may be overwritten automatically.\nOptions +FollowSymLinks\nRewriteEngine On\nRewriteBase ".$base."\nRewriteRule ^".preg_quote($settings)."$ - [L]\n# --URLS ADD_COND BEGIN--\n# --URLS ADD_COND END--\nRewriteCond %{REQUEST_FILENAME} -d [OR]\nRewriteCond %{REQUEST_FILENAME} \.php$ [OR]\nRewriteCond %{REQUEST_FILENAME} !-f\nRewriteRule . ".$base.$settings." [L]\nRewriteRule ^$ ".$base.$settings." [L]\n# --URLS END--\n");
		fclose($htaccess);
	} else {
		die('Error creating ".htaccess" file.');
	}

	if (!is_dir('urls')) {
		$dir = 'urls';
	} else {
		$dir = 'urls_'.uniqid();
	}

	if (!mkdir($dir)) {
		die('Error creating directory: '.$dir);
	}

	// Download the update files
	$updateFilePath = $dir.'/UrlsUpdate.zip';
	file_put_contents($updateFilePath, file_get_contents('https://raw.githubusercontent.com/urls-framework/URLS/main/update_files/UrlsUpdate.zip?'.mt_rand()));

	// Extract the zip folder
	$zip = new ZipArchive;
	$res = $zip->open($updateFilePath, PATHINFO_DIRNAME);
	if ($res === true) {
		$zip->extractTo($dir);
		$zip->close();
	} else {
		die('Error unpacking files.');
	}

	// Delete the update files
	if ($deleteUpdate === 'true') {
		unlink($updateFilePath);
	}

	$settingsFile = fopen($settings, 'w');
	fwrite($settingsFile, "<?php\n/*\nURLS framework url config file.\n\nAdd your paths here:\nex. \$urls->path('blog/', 'blog-home.php', true);\n*/\ninclude '".$dir."/Urls.php';\nUrls::\$base = '".$base."';\n\n\$urls = new Urls;\n\n\n\$urls->exe();\n\n?>\n");
	fclose($settingsFile);
	echo 'done';
	if ($delete == 'true') {
		if (!unlink('urls_install.php')) {
			exit('Error deleting install file.');
		}
	}
	exit();

}
?>
<!DOCTYPE html>
<html>
<head>
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans&display=swap" rel="stylesheet">
	<meta charset="utf-8">
	<title>URLS - Welcome!</title>
	<style type="text/css">
	body {
		font-family: 'Open-Sans', sans-serif;
	}

	button,input[type=button] {
		margin: 10px;
		padding: 10px 14px 10px 14px;
		background-color: black;
		color: white;
		border: 2px black solid;
		border-radius: 5px;
		font-size: 16px;
		cursor: pointer;
		transition: .2s;
		outline: 0
	}

	button:hover,input[type=button]:hover {
		background-color: lightgray;
		border-color: lightgray;
		color: black;
	}

	button:active,input[type=button]:active {
		transition: 0s;
		background-color: darkgrey;
		border-color: darkgrey;
		color: black;
	}

	.under {
		border-bottom: 2px solid darkgrey;
		width: 200px;
	}

	.under:focus-within {
		border-bottom: 2px solid black;
	}

	input[type=text] {
		width: 200px;
		border: 0;
		background-color: #00000000;
		padding: 10px;
		padding-bottom: 2px;
		font-size: 16px;
	}

	input[type=text]:focus {
		outline: 0;
	}

	label {
		cursor: text;
	}

	.checkL, .checkD {
		cursor: pointer;
	}
	</style>
</head>
<body>
	<img src="data:image/png;base64,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" alt="URLS://" width="600px">
	<?php
	if (isset($_GET['error'])) {
		if ($_GET['error'] == 1) {
			echo '<p style="color: red;">You must specify a settings file.</p>';
		}
	}
	function check($var, $check=false, $default=null){
		if (isset($_GET[$var])) {
			if ($check == true) {
				if ($_GET[$var] == 'true') {
					echo 'checked';
				}
			} else {
				echo 'value="'.htmlspecialchars($_GET[$var]).'"';
			}
		} elseif (isset($default)) {
			echo 'value="'.htmlspecialchars($default).'"';
		}
	}
	?>
	<form method="post">
		<label>Base Directory (Enter <b>"/"</b> for the root directory <b>"<?php echo htmlspecialchars($_SERVER['DOCUMENT_ROOT']); ?>"</b>. Leave blank for current directory <b>"<?php echo htmlspecialchars($curDirectory); ?>"</b>): </label><div class="under"><input type="text" name="base" placeholder="ex. /your/path/" <?php check('base', false, $curDirectory); ?>></label></div><br>

		<label>Settings File (if the file already exists, it will be overwritten): </label><div class="under"><input type="text" name="settings" placeholder="ex. settings.php"></div><br>

		<label class="checkL"><input type="checkbox" name="delete" value="true" <?php check('delete', true); ?>>Would you like to delete this file after installation? (recomended for production)</label><br>

		<label class="checkD"><input type="checkbox" name="deleteUpdate" value="true" <?php check('deleteUpdate', true); ?>>Would you like to delete the installation files after installation? (recomended for production)</label><br>

		<button	type="submit">Install</button>
	</form>
	<p>Copyright &copy; 2022 Micah Baumann</p>
</body>
</html>