/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.xslt;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.xml.transform.CollectingTransformErrorListener;
import com.phloc.commons.xml.transform.LoggingTransformErrorListener;
import com.phloc.schematron.xslt.ISchematronXSLTProvider;
import com.phloc.schematron.xslt.SchematronProviderXSLTPrebuild;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SchematronResourceXSLTCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronResourceXSLTCache.class);
    private static final Lock s_aLock = new ReentrantLock();
    private static final Map<String, ISchematronXSLTProvider> s_aCache = new HashMap<String, ISchematronXSLTProvider>();

    private SchematronResourceXSLTCache() {
    }

    @Nullable
    public static ISchematronXSLTProvider createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource) {
        CollectingTransformErrorListener collectingTransformErrorListener;
        SchematronProviderXSLTPrebuild schematronProviderXSLTPrebuild;
        if (GlobalDebug.isDebugMode() && s_aLogger.isInfoEnabled()) {
            s_aLogger.info("Compiling XSLT instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTPrebuild = new SchematronProviderXSLTPrebuild(iReadableResource, (ErrorListener)(collectingTransformErrorListener = new CollectingTransformErrorListener((ErrorListener)(GlobalDebug.isDebugMode() ? new LoggingTransformErrorListener(Locale.US) : null))))).isValidSchematron()) {
            s_aLogger.warn("The XSLT resource '" + iReadableResource.getResourceID() + "' is invalid!");
            for (IResourceError iResourceError : collectingTransformErrorListener.getResourceErrors()) {
                s_aLogger.warn("  " + iResourceError.getAsString(Locale.US));
            }
            return null;
        }
        if (schematronProviderXSLTPrebuild.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from XSLT resource '" + iReadableResource.getResourceID() + "'!");
        }
        return schematronProviderXSLTPrebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ISchematronXSLTProvider getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            throw new NullPointerException("resource");
        }
        if (!iReadableResource.exists()) {
            s_aLogger.warn("XSLT resource " + iReadableResource + " does not exist!");
            return null;
        }
        s_aLock.lock();
        try {
            String string = iReadableResource.getResourceID();
            ISchematronXSLTProvider iSchematronXSLTProvider = s_aCache.get(string);
            if (iSchematronXSLTProvider == null && (iSchematronXSLTProvider = SchematronResourceXSLTCache.createSchematronXSLTProvider(iReadableResource)) != null) {
                s_aCache.put(string, iSchematronXSLTProvider);
            }
            ISchematronXSLTProvider iSchematronXSLTProvider2 = iSchematronXSLTProvider;
            return iSchematronXSLTProvider2;
        }
        finally {
            s_aLock.unlock();
        }
    }
}

