/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.xslt;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.DevelopersNote;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.xml.serialize.XMLWriter;
import com.phloc.schematron.xslt.ISchematronXSLTProvider;
import com.phloc.schematron.xslt.SchematronProviderXSLTFromSCH;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@ThreadSafe
public final class SchematronResourceSCHCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronResourceSCHCache.class);
    private static final Lock s_aLock = new ReentrantLock();
    private static final Map<String, ISchematronXSLTProvider> s_aCache = new HashMap<String, ISchematronXSLTProvider>();

    private SchematronResourceSCHCache() {
    }

    @Nullable
    @Deprecated
    @DevelopersNote(value="For binary compatibility to schematron2xslt-maven-plugin 2.5.0")
    public static ISchematronXSLTProvider createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        return SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, errorListener, uRIResolver, null, null);
    }

    @Nullable
    public static ISchematronXSLTProvider createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver, @Nullable String string, @Nullable String string2) {
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH;
        if (GlobalDebug.isDebugMode() && s_aLogger.isInfoEnabled()) {
            s_aLogger.info("Compiling Schematron instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTFromSCH = new SchematronProviderXSLTFromSCH(iReadableResource, errorListener, uRIResolver, string, string2)).isValidSchematron()) {
            s_aLogger.warn("The Schematron resource '" + iReadableResource.getResourceID() + "' is invalid!");
            if (GlobalDebug.isDebugMode() && schematronProviderXSLTFromSCH.getXSLTDocument() != null) {
                s_aLogger.warn("  Created XSLT document:\n" + XMLWriter.getXMLString((Node)schematronProviderXSLTFromSCH.getXSLTDocument()));
            }
            return null;
        }
        if (schematronProviderXSLTFromSCH.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from Schematron resource '" + iReadableResource.getResourceID() + "'!");
        }
        return schematronProviderXSLTFromSCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ISchematronXSLTProvider getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver, @Nullable String string, @Nullable String string2) {
        if (iReadableResource == null) {
            throw new NullPointerException("resource");
        }
        if (!iReadableResource.exists()) {
            s_aLogger.warn("Schematron resource " + iReadableResource + " does not exist!");
            return null;
        }
        s_aLock.lock();
        try {
            String string3 = iReadableResource.getResourceID();
            ISchematronXSLTProvider iSchematronXSLTProvider = s_aCache.get(string3);
            if (iSchematronXSLTProvider == null && (iSchematronXSLTProvider = SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, errorListener, uRIResolver, string, string2)) != null) {
                s_aCache.put(string3, iSchematronXSLTProvider);
            }
            ISchematronXSLTProvider iSchematronXSLTProvider2 = iSchematronXSLTProvider;
            return iSchematronXSLTProvider2;
        }
        finally {
            s_aLock.unlock();
        }
    }
}

