/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.xslt;

import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.xml.transform.LoggingTransformErrorListener;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import com.phloc.commons.xml.transform.XMLTransformerFactory;
import com.phloc.schematron.xslt.AbstractSchematronXSLTProvider;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
final class SchematronProviderXSLTFromSCH
extends AbstractSchematronXSLTProvider {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronProviderXSLTFromSCH.class);
    private static final String SCHEMATRON_DIRECTORY_XSLT2 = "schematron/20100414-xslt2/";
    private static final String XSLT2_STEP1 = "schematron/20100414-xslt2/iso_dsdl_include.xsl";
    private static final String XSLT2_STEP2 = "schematron/20100414-xslt2/iso_abstract_expand.xsl";
    private static final String XSLT2_STEP3 = "schematron/20100414-xslt2/iso_svrl_for_xslt2.xsl";
    private static final boolean SAVE_INTERMEDIATE_FILES = false;
    private static Templates s_aStep1;
    private static Templates s_aStep2;
    private static Templates s_aStep3;

    public SchematronProviderXSLTFromSCH(@Nullable IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        this(iReadableResource, errorListener, uRIResolver, null, null);
    }

    public SchematronProviderXSLTFromSCH(@Nullable IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver, @Nullable String string, @Nullable String string2) {
        ErrorListener errorListener2 = errorListener != null ? errorListener : new LoggingTransformErrorListener(Locale.US);
        try {
            if (s_aStep1 == null) {
                s_aStep1 = XMLTransformerFactory.newTemplates((IReadableResource)new ClassPathResource(XSLT2_STEP1));
            }
            if (s_aStep2 == null) {
                s_aStep2 = XMLTransformerFactory.newTemplates((IReadableResource)new ClassPathResource(XSLT2_STEP2));
            }
            if (s_aStep3 == null) {
                s_aStep3 = XMLTransformerFactory.newTemplates((IReadableResource)new ClassPathResource(XSLT2_STEP3));
            }
            DOMResult dOMResult = new DOMResult();
            Transformer transformer = s_aStep1.newTransformer();
            transformer.setErrorListener(errorListener2);
            if (uRIResolver != null) {
                transformer.setURIResolver(uRIResolver);
            }
            transformer.transform((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), dOMResult);
            DOMResult dOMResult2 = new DOMResult();
            Transformer transformer2 = s_aStep2.newTransformer();
            transformer2.setErrorListener(errorListener2);
            if (uRIResolver != null) {
                transformer2.setURIResolver(uRIResolver);
            }
            transformer2.transform(TransformSourceFactory.create((Node)dOMResult.getNode()), dOMResult2);
            DOMResult dOMResult3 = new DOMResult();
            Transformer transformer3 = s_aStep3.newTransformer();
            transformer3.setErrorListener(errorListener2);
            if (uRIResolver != null) {
                transformer3.setURIResolver(uRIResolver);
            }
            if (string != null) {
                transformer3.setParameter("phase", string);
            }
            if (string2 != null) {
                transformer3.setParameter("langCode", string2);
            }
            transformer3.transform(TransformSourceFactory.create((Node)dOMResult2.getNode()), dOMResult3);
            this.m_aSchematronXSLTDoc = (Document)dOMResult3.getNode();
            this.m_aSchematronXSLT = XMLTransformerFactory.newTemplates((Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Schematron preprocessor error", throwable);
        }
    }
}

