/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.svrl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.schematron.svrl.DefaultSVRLErrorLevelDeterminator;
import com.phloc.schematron.svrl.ISVRLErrorLevelDeterminator;
import com.phloc.schematron.svrl.SVRLFailedAssert;
import com.phloc.schematron.svrl.SVRLSuccessfulReport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;

@ThreadSafe
public final class SVRLUtils {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static ISVRLErrorLevelDeterminator s_aELD = new DefaultSVRLErrorLevelDeterminator();
    private static final SVRLUtils s_aInstance = new SVRLUtils();

    private SVRLUtils() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLFailedAssert> getAllFailedAssertions(@Nonnull SchematronOutputType schematronOutputType) {
        ArrayList<SVRLFailedAssert> arrayList = new ArrayList<SVRLFailedAssert>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            if (!(object instanceof FailedAssert)) continue;
            arrayList.add(new SVRLFailedAssert((FailedAssert)object));
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLFailedAssert> getAllFailedAssertionsMoreOrEqualSevereThan(@Nonnull SchematronOutputType schematronOutputType, @Nonnull EErrorLevel eErrorLevel) {
        ArrayList<SVRLFailedAssert> arrayList = new ArrayList<SVRLFailedAssert>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            SVRLFailedAssert sVRLFailedAssert;
            if (!(object instanceof FailedAssert) || !(sVRLFailedAssert = new SVRLFailedAssert((FailedAssert)object)).getFlag().isMoreOrEqualSevereThan(eErrorLevel)) continue;
            arrayList.add(sVRLFailedAssert);
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLSuccessfulReport> getAllSuccesssfulReports(@Nonnull SchematronOutputType schematronOutputType) {
        ArrayList<SVRLSuccessfulReport> arrayList = new ArrayList<SVRLSuccessfulReport>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            if (!(object instanceof SuccessfulReport)) continue;
            arrayList.add(new SVRLSuccessfulReport((SuccessfulReport)object));
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<SVRLSuccessfulReport> getAllSuccessfulReportsMoreOrEqualSevereThan(@Nonnull SchematronOutputType schematronOutputType, @Nonnull EErrorLevel eErrorLevel) {
        ArrayList<SVRLSuccessfulReport> arrayList = new ArrayList<SVRLSuccessfulReport>();
        for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
            SVRLSuccessfulReport sVRLSuccessfulReport;
            if (!(object instanceof SuccessfulReport) || !(sVRLSuccessfulReport = new SVRLSuccessfulReport((SuccessfulReport)object)).getFlag().isMoreOrEqualSevereThan(eErrorLevel)) continue;
            arrayList.add(sVRLSuccessfulReport);
        }
        return arrayList;
    }

    @Nonnull
    public static EErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        return SVRLUtils.getErrorLevelDeterminator().getErrorLevelFromFailedAssert(failedAssert);
    }

    @Nonnull
    public static EErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        return SVRLUtils.getErrorLevelDeterminator().getErrorLevelFromSuccessfulReport(successfulReport);
    }

    @Nonnull
    @Deprecated
    public static EErrorLevel getErrorLevelFromFlag(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("flag");
        }
        if (string.equalsIgnoreCase("warning") || string.equalsIgnoreCase("warn")) {
            return EErrorLevel.WARN;
        }
        if (string.equalsIgnoreCase("error") || string.equalsIgnoreCase("err")) {
            return EErrorLevel.ERROR;
        }
        if (string.equalsIgnoreCase("fatal") || string.equalsIgnoreCase("fatal_error") || string.equalsIgnoreCase("fatalerror")) {
            return EErrorLevel.FATAL_ERROR;
        }
        throw new IllegalArgumentException("Cannot convert the SVRL failed assertion flag '" + string + "' to an error level. Please extend the preceeding list!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ISVRLErrorLevelDeterminator getErrorLevelDeterminator() {
        s_aRWLock.readLock().lock();
        try {
            ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator = s_aELD;
            return iSVRLErrorLevelDeterminator;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setErrorLevelDeterminator(@Nonnull ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator) {
        if (iSVRLErrorLevelDeterminator == null) {
            throw new NullPointerException("ErrorLevelDeterminator");
        }
        s_aRWLock.readLock().lock();
        try {
            s_aELD = iSVRLErrorLevelDeterminator;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }
}

