/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.resolve;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.ls.SimpleLSResourceResolver;
import com.phloc.schematron.resolve.ISchematronIncludeResolver;
import java.io.IOException;
import javax.annotation.Nonnull;

public class DefaultSchematronIncludeResolver
implements ISchematronIncludeResolver {
    private final String m_sBaseHref;

    public DefaultSchematronIncludeResolver(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getAsURL().toExternalForm());
    }

    public DefaultSchematronIncludeResolver(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new NullPointerException("baseHref");
        }
        this.m_sBaseHref = string;
    }

    @Nonnull
    @Nonempty
    public String getBaseHref() {
        return this.m_sBaseHref;
    }

    @Override
    @Nonnull
    public IReadableResource getResolvedSchematronResource(@Nonnull @Nonempty String string) throws IOException {
        return SimpleLSResourceResolver.doStandardResourceResolving((String)string, (String)this.getBaseHref());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("baseHref", (Object)this.m_sBaseHref).toString();
    }
}

