/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.validation.xpath;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.state.EContinue;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignAttributes;
import com.phloc.schematron.pure.model.PSAssertReport;
import com.phloc.schematron.pure.model.PSDiagnostics;
import com.phloc.schematron.pure.model.PSDir;
import com.phloc.schematron.pure.model.PSEmph;
import com.phloc.schematron.pure.model.PSName;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSPhase;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.model.PSSpan;
import com.phloc.schematron.pure.model.PSTitle;
import com.phloc.schematron.pure.model.PSValueOf;
import com.phloc.schematron.pure.validation.PSValidationHandlerDefault;
import com.phloc.schematron.pure.validation.SchematronValidationException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.oclc.purl.dsdl.svrl.ActivePattern;
import org.oclc.purl.dsdl.svrl.DiagnosticReference;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.FiredRule;
import org.oclc.purl.dsdl.svrl.NsPrefixInAttributeValues;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;
import org.w3c.dom.Node;

@NotThreadSafe
public class PSXPathValidationHandlerSVRL
extends PSValidationHandlerDefault {
    private final IPSErrorHandler m_aErrorHandler;
    private SchematronOutputType m_aSchematronOutput;
    private PSSchema m_aSchema;
    private String m_sLastRuleContext;

    public PSXPathValidationHandlerSVRL(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (iPSErrorHandler == null) {
            throw new NullPointerException("ErrorHandler");
        }
        this.m_aErrorHandler = iPSErrorHandler;
    }

    private void _warn(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        if (this.m_aSchema == null) {
            throw new IllegalStateException("No schema is present!");
        }
        this.m_aErrorHandler.warn(this.m_aSchema.getResource(), iPSElement, string);
    }

    private void _error(@Nonnull IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        if (this.m_aSchema == null) {
            throw new IllegalStateException("No schema is present!");
        }
        this.m_aErrorHandler.error(this.m_aSchema.getResource(), iPSElement, string, throwable);
    }

    @Nullable
    private static String _getTitleAsString(@Nullable PSTitle pSTitle) throws SchematronValidationException {
        if (pSTitle == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : pSTitle.getAllContentElements()) {
            if (object instanceof String) {
                stringBuilder.append((String)object);
                continue;
            }
            if (object instanceof PSDir) {
                stringBuilder.append(((PSDir)object).getAsText());
                continue;
            }
            throw new SchematronValidationException("Unsupported title content element: " + object);
        }
        return stringBuilder.toString();
    }

    @Override
    public void onStart(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase) throws SchematronValidationException {
        SchematronOutputType schematronOutputType = new SchematronOutputType();
        if (pSPhase != null) {
            schematronOutputType.setPhase(pSPhase.getID());
        }
        schematronOutputType.setSchemaVersion(pSSchema.getSchemaVersion());
        schematronOutputType.setTitle(PSXPathValidationHandlerSVRL._getTitleAsString(pSSchema.getTitle()));
        for (Map.Entry entry : pSSchema.getAsNamespaceContext().getPrefixToNamespaceURIMap().entrySet()) {
            NsPrefixInAttributeValues nsPrefixInAttributeValues = new NsPrefixInAttributeValues();
            nsPrefixInAttributeValues.setPrefix((String)entry.getKey());
            nsPrefixInAttributeValues.setUri((String)entry.getValue());
            schematronOutputType.getNsPrefixInAttributeValues().add(nsPrefixInAttributeValues);
        }
        this.m_aSchematronOutput = schematronOutputType;
        this.m_aSchema = pSSchema;
    }

    @Override
    public void onPattern(@Nonnull PSPattern pSPattern) {
        ActivePattern activePattern = new ActivePattern();
        activePattern.setId(pSPattern.getID());
        this.m_aSchematronOutput.getActivePatternAndFiredRuleAndFailedAssert().add(activePattern);
    }

    @Override
    public void onRule(@Nonnull PSRule pSRule, @Nonnull String string) {
        FiredRule firedRule = new FiredRule();
        firedRule.setContext(string);
        firedRule.setFlag(pSRule.getFlag());
        firedRule.setId(pSRule.getID());
        this.m_aSchematronOutput.getActivePatternAndFiredRuleAndFailedAssert().add(firedRule);
        this.m_sLastRuleContext = string;
    }

    @Nonnull
    private String _getErrorText(@Nonnull List<PSXPathBoundElement> list, @Nonnull Node node) throws SchematronValidationException {
        StringBuilder stringBuilder = new StringBuilder();
        for (PSXPathBoundElement pSXPathBoundElement : list) {
            IPSHasForeignAttributes iPSHasForeignAttributes;
            Object object = pSXPathBoundElement.getElement();
            if (object instanceof String) {
                stringBuilder.append((String)object);
                continue;
            }
            if (object instanceof PSName) {
                iPSHasForeignAttributes = (PSName)object;
                if (((PSName)iPSHasForeignAttributes).hasPath()) {
                    try {
                        stringBuilder.append((String)pSXPathBoundElement.getBoundExpression().evaluate(node, XPathConstants.STRING));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this._error((IPSElement)((Object)iPSHasForeignAttributes), "Failed to evaluate XPath expression to a string: '" + pSXPathBoundElement.getExpression() + "'", xPathExpressionException);
                        stringBuilder.append(((PSName)iPSHasForeignAttributes).getPath());
                    }
                    continue;
                }
                stringBuilder.append(node.getNodeName());
                continue;
            }
            if (object instanceof PSValueOf) {
                iPSHasForeignAttributes = (PSValueOf)object;
                try {
                    stringBuilder.append((String)pSXPathBoundElement.getBoundExpression().evaluate(node, XPathConstants.STRING));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this._error((IPSElement)((Object)iPSHasForeignAttributes), "Failed to evaluate XPath expression to a string: '" + pSXPathBoundElement.getExpression() + "'", xPathExpressionException);
                    stringBuilder.append(((PSValueOf)iPSHasForeignAttributes).getSelect());
                }
                continue;
            }
            if (object instanceof PSEmph) {
                stringBuilder.append(((PSEmph)object).getAsText());
                continue;
            }
            if (object instanceof PSDir) {
                stringBuilder.append(((PSDir)object).getAsText());
                continue;
            }
            if (object instanceof PSSpan) {
                stringBuilder.append(((PSSpan)object).getAsText());
                continue;
            }
            throw new SchematronValidationException("Unsupported assert/report content element: " + object);
        }
        return stringBuilder.toString();
    }

    private void _handleDiagnosticReferences(@Nullable List<String> list, @Nonnull List<DiagnosticReference> list2, @Nonnull PSXPathBoundAssertReport pSXPathBoundAssertReport, @Nonnull Node node) throws SchematronValidationException {
        if (ContainerHelper.isNotEmpty(list)) {
            if (this.m_aSchema.hasDiagnostics()) {
                PSDiagnostics pSDiagnostics = this.m_aSchema.getDiagnostics();
                for (String string : list) {
                    PSXPathBoundDiagnostic pSXPathBoundDiagnostic = pSXPathBoundAssertReport.getBoundDiagnosticOfID(string);
                    if (pSXPathBoundDiagnostic == null) {
                        this._warn(pSDiagnostics, "Failed to resolve diagnostics with ID '" + string + "'");
                        continue;
                    }
                    DiagnosticReference diagnosticReference = new DiagnosticReference();
                    diagnosticReference.setDiagnostic(string);
                    diagnosticReference.setText(this._getErrorText(pSXPathBoundDiagnostic.getAllBoundContentElements(), node));
                    list2.add(diagnosticReference);
                }
            } else {
                this._warn(this.m_aSchema, "Failed to resolve diagnostic because schema has no diagnostics");
            }
        }
    }

    @Override
    @Nonnull
    public EContinue onFailedAssert(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, @Nonnull int n, @Nullable Object object) throws SchematronValidationException {
        if (!(object instanceof PSXPathBoundAssertReport)) {
            throw new SchematronValidationException("The passed context must be an XPath object but is a " + object);
        }
        PSXPathBoundAssertReport pSXPathBoundAssertReport = (PSXPathBoundAssertReport)object;
        FailedAssert failedAssert = new FailedAssert();
        failedAssert.setFlag(pSAssertReport.getFlag());
        failedAssert.setId(pSAssertReport.getID());
        failedAssert.setLocation(this.m_sLastRuleContext + "[" + n + "]");
        failedAssert.setTest(string);
        failedAssert.setText(this._getErrorText(pSXPathBoundAssertReport.getAllBoundContentElements(), node));
        this._handleDiagnosticReferences(pSAssertReport.getAllDiagnostics(), failedAssert.getDiagnosticReference(), pSXPathBoundAssertReport, node);
        this.m_aSchematronOutput.getActivePatternAndFiredRuleAndFailedAssert().add(failedAssert);
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EContinue onSuccessfulReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, @Nonnull int n, @Nullable Object object) throws SchematronValidationException {
        if (!(object instanceof PSXPathBoundAssertReport)) {
            throw new SchematronValidationException("The passed context must be an XPath object but is a " + object);
        }
        PSXPathBoundAssertReport pSXPathBoundAssertReport = (PSXPathBoundAssertReport)object;
        SuccessfulReport successfulReport = new SuccessfulReport();
        successfulReport.setFlag(pSAssertReport.getFlag());
        successfulReport.setId(pSAssertReport.getID());
        successfulReport.setLocation(this.m_sLastRuleContext + "[" + n + "]");
        successfulReport.setTest(string);
        successfulReport.setText(this._getErrorText(pSXPathBoundAssertReport.getAllBoundContentElements(), node));
        this._handleDiagnosticReferences(pSAssertReport.getAllDiagnostics(), successfulReport.getDiagnosticReference(), pSXPathBoundAssertReport, node);
        this.m_aSchematronOutput.getActivePatternAndFiredRuleAndFailedAssert().add(successfulReport);
        return EContinue.CONTINUE;
    }

    @Nullable
    public SchematronOutputType getSVRL() {
        return this.m_aSchematronOutput;
    }
}

