/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.preprocess;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSSchema;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class PreprocessorLookup {
    private final Map<String, PSPattern> m_aPatterns = new HashMap<String, PSPattern>();
    private final Map<String, PSRule> m_aRules = new HashMap<String, PSRule>();

    public PreprocessorLookup(@Nonnull PSSchema pSSchema) {
        if (pSSchema == null) {
            throw new NullPointerException("schema");
        }
        for (PSPattern pSPattern : pSSchema.getAllPatterns()) {
            if (pSPattern.isAbstract()) {
                this.m_aPatterns.put(pSPattern.getID(), pSPattern);
            }
            for (PSRule pSRule : pSPattern.getAllRules()) {
                if (!pSRule.isAbstract()) continue;
                this.m_aRules.put(pSRule.getID(), pSRule);
            }
        }
    }

    @Nullable
    public PSPattern getAbstractPatternOfID(@Nullable String string) {
        return this.m_aPatterns.get(string);
    }

    @Nullable
    public PSRule getAbstractRuleOfID(@Nullable String string) {
        return this.m_aRules.get(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public SortedSet<String> getAllAbstractRuleIDs() {
        return ContainerHelper.newSortedSet(this.m_aRules.keySet());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("patterns", this.m_aPatterns).append("rules", this.m_aRules).toString();
    }
}

