/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.preprocess;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.binding.IPSQueryBinding;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.PSActive;
import com.phloc.schematron.pure.model.PSAssertReport;
import com.phloc.schematron.pure.model.PSDiagnostic;
import com.phloc.schematron.pure.model.PSDiagnostics;
import com.phloc.schematron.pure.model.PSDir;
import com.phloc.schematron.pure.model.PSEmph;
import com.phloc.schematron.pure.model.PSExtends;
import com.phloc.schematron.pure.model.PSLet;
import com.phloc.schematron.pure.model.PSNS;
import com.phloc.schematron.pure.model.PSName;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSPhase;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.model.PSSpan;
import com.phloc.schematron.pure.model.PSValueOf;
import com.phloc.schematron.pure.preprocess.PreprocessorIDPool;
import com.phloc.schematron.pure.preprocess.PreprocessorLookup;
import com.phloc.schematron.pure.preprocess.SchematronPreprocessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPreprocessor {
    public static final boolean DEFAULT_KEEP_TITLES = false;
    public static final boolean DEFAULT_KEEP_DIAGNOSTICS = false;
    public static final boolean DEFAULT_KEEP_REPORTS = false;
    public static final boolean DEFAULT_KEEP_EMPTY_PATTERNS = true;
    public static final boolean DEFAULT_KEEP_EMPTY_SCHEMA = true;
    private final IPSQueryBinding m_aQueryBinding;
    private boolean m_bKeepTitles = false;
    private boolean m_bKeepDiagnostics = false;
    private boolean m_bKeepReports = false;
    private boolean m_bKeepEmptyPatterns = true;
    private boolean m_bKeepEmptySchema = true;

    public PSPreprocessor(@Nonnull IPSQueryBinding iPSQueryBinding) {
        if (iPSQueryBinding == null) {
            throw new NullPointerException("QueryBinding");
        }
        this.m_aQueryBinding = iPSQueryBinding;
    }

    @Nonnull
    public IPSQueryBinding getQueryBinding() {
        return this.m_aQueryBinding;
    }

    public boolean isKeepTitles() {
        return this.m_bKeepTitles;
    }

    @Nonnull
    public PSPreprocessor setKeepTitles(boolean bl) {
        this.m_bKeepTitles = bl;
        return this;
    }

    public boolean isKeepDiagnostics() {
        return this.m_bKeepDiagnostics;
    }

    @Nonnull
    public PSPreprocessor setKeepDiagnostics(boolean bl) {
        this.m_bKeepDiagnostics = bl;
        return this;
    }

    public boolean isKeepReports() {
        return this.m_bKeepReports;
    }

    @Nonnull
    public PSPreprocessor setKeepReports(boolean bl) {
        this.m_bKeepReports = bl;
        return this;
    }

    public boolean isKeepEmptyPatterns() {
        return this.m_bKeepEmptyPatterns;
    }

    @Nonnull
    public PSPreprocessor setKeepEmptyPatterns(boolean bl) {
        this.m_bKeepEmptyPatterns = bl;
        return this;
    }

    public boolean isKeepEmptySchema() {
        return this.m_bKeepEmptySchema;
    }

    @Nonnull
    public PSPreprocessor setKeepEmptySchema(boolean bl) {
        this.m_bKeepEmptySchema = bl;
        return this;
    }

    @Nonnull
    private static PSPhase _getPreprocessedPhase(@Nonnull PSPhase pSPhase, @Nonnull PreprocessorIDPool preprocessorIDPool) throws SchematronPreprocessException {
        PSPhase pSPhase2 = new PSPhase();
        pSPhase2.setID(preprocessorIDPool.getUniqueID(pSPhase.getID()));
        pSPhase2.setRich(pSPhase.getRichClone());
        if (pSPhase.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <phase> with an <include>");
        }
        for (IPSElement iPSElement : pSPhase.getAllContentElements()) {
            if (iPSElement instanceof PSActive) {
                pSPhase2.addActive(((PSActive)iPSElement).getClone());
                continue;
            }
            if (!(iPSElement instanceof PSLet)) continue;
            pSPhase2.addLet(((PSLet)iPSElement).getClone());
        }
        pSPhase2.addForeignElements(pSPhase.getAllForeignElements());
        pSPhase2.addForeignAttributes(pSPhase.getAllForeignAttributes());
        return pSPhase2;
    }

    @Nonnull
    @ReturnsMutableCopy
    private static List<PSAssertReport> _getResolvedExtends(@Nonnull List<IPSElement> list, @Nonnull PreprocessorLookup preprocessorLookup) throws SchematronPreprocessException {
        ArrayList<PSAssertReport> arrayList = new ArrayList<PSAssertReport>();
        for (IPSElement iPSElement : list) {
            if (iPSElement instanceof PSAssertReport) {
                arrayList.add((PSAssertReport)iPSElement);
                continue;
            }
            PSExtends pSExtends = (PSExtends)iPSElement;
            String string = pSExtends.getRule();
            PSRule pSRule = preprocessorLookup.getAbstractRuleOfID(string);
            if (pSRule == null) {
                throw new SchematronPreprocessException("Failed to resolve rule ID '" + string + "' in extends statement. Available rules are: " + preprocessorLookup.getAllAbstractRuleIDs());
            }
            arrayList.addAll(PSPreprocessor._getResolvedExtends(pSRule.getAllContentElements(), preprocessorLookup));
        }
        return arrayList;
    }

    @Nonnull
    private PSAssertReport _getPreprocessedAssert(@Nonnull PSAssertReport pSAssertReport, @Nonnull PreprocessorIDPool preprocessorIDPool, @Nullable Map<String, String> map) {
        String string = pSAssertReport.getTest();
        if (pSAssertReport.isReport() && !this.m_bKeepReports) {
            string = this.m_aQueryBinding.getNegatedTestExpression(string);
        }
        PSAssertReport pSAssertReport2 = new PSAssertReport(this.m_bKeepReports ? pSAssertReport.isAssert() : true);
        pSAssertReport2.setTest(this.m_aQueryBinding.getWithParamTextsReplaced(string, map));
        pSAssertReport2.setFlag(pSAssertReport.getFlag());
        pSAssertReport2.setID(preprocessorIDPool.getUniqueID(pSAssertReport.getID()));
        if (this.m_bKeepDiagnostics) {
            pSAssertReport2.setDiagnostics(pSAssertReport.getAllDiagnostics());
        }
        pSAssertReport2.setRich(pSAssertReport.getRichClone());
        pSAssertReport2.setLinkable(pSAssertReport.getLinkableClone());
        for (Object object : pSAssertReport.getAllContentElements()) {
            if (object instanceof String) {
                pSAssertReport2.addText((String)object);
                continue;
            }
            if (object instanceof PSName) {
                pSAssertReport2.addName(((PSName)object).getClone());
                continue;
            }
            if (object instanceof PSValueOf) {
                PSValueOf pSValueOf = ((PSValueOf)object).getClone();
                pSValueOf.setSelect(this.m_aQueryBinding.getWithParamTextsReplaced(pSValueOf.getSelect(), map));
                pSAssertReport2.addValueOf(pSValueOf);
                continue;
            }
            if (object instanceof PSEmph) {
                pSAssertReport2.addEmph(((PSEmph)object).getClone());
                continue;
            }
            if (object instanceof PSDir) {
                pSAssertReport2.addDir(((PSDir)object).getClone());
                continue;
            }
            if (!(object instanceof PSSpan)) continue;
            pSAssertReport2.addSpan(((PSSpan)object).getClone());
        }
        pSAssertReport2.addForeignElements(pSAssertReport.getAllForeignElements());
        pSAssertReport2.addForeignAttributes(pSAssertReport.getAllForeignAttributes());
        return pSAssertReport2;
    }

    @Nullable
    private PSRule _getPreprocessedRule(@Nonnull PSRule pSRule, @Nonnull PreprocessorLookup preprocessorLookup, @Nonnull PreprocessorIDPool preprocessorIDPool, @Nullable Map<String, String> map) throws SchematronPreprocessException {
        if (pSRule.isAbstract()) {
            return null;
        }
        PSRule pSRule2 = new PSRule();
        pSRule2.setFlag(pSRule.getFlag());
        pSRule2.setRich(pSRule.getRichClone());
        pSRule2.setLinkable(pSRule.getLinkableClone());
        pSRule2.setContext(this.m_aQueryBinding.getWithParamTextsReplaced(pSRule.getContext(), map));
        pSRule2.setID(preprocessorIDPool.getUniqueID(pSRule.getID()));
        if (pSRule.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <rule> with an <include>");
        }
        for (PSLet iPSElement : pSRule.getAllLets()) {
            pSRule2.addLet(iPSElement.getClone());
        }
        for (PSAssertReport pSAssertReport : PSPreprocessor._getResolvedExtends(pSRule.getAllContentElements(), preprocessorLookup)) {
            pSRule2.addAssertReport(this._getPreprocessedAssert(pSAssertReport, preprocessorIDPool, map));
        }
        pSRule2.addForeignElements(pSRule.getAllForeignElements());
        pSRule2.addForeignAttributes(pSRule.getAllForeignAttributes());
        return pSRule2;
    }

    @Nullable
    private PSPattern _getPreprocessedPattern(@Nonnull PSPattern pSPattern, @Nonnull PreprocessorLookup preprocessorLookup, @Nonnull PreprocessorIDPool preprocessorIDPool) throws SchematronPreprocessException {
        String string;
        if (pSPattern.isAbstract()) {
            return null;
        }
        PSPattern pSPattern2 = new PSPattern();
        pSPattern2.setID(preprocessorIDPool.getUniqueID(pSPattern.getID()));
        pSPattern2.setRich(pSPattern.getRichClone());
        if (pSPattern.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <pattern> with an <include>");
        }
        if (this.m_bKeepTitles && pSPattern.hasTitle()) {
            pSPattern2.setTitle(pSPattern.getTitle().getClone());
        }
        if ((string = pSPattern.getIsA()) != null) {
            PSPattern pSPattern3 = preprocessorLookup.getAbstractPatternOfID(string);
            if (pSPattern3 == null) {
                throw new SchematronPreprocessException("Failed to resolve the pattern denoted by is-a='" + string + "'");
            }
            if (!pSPattern2.hasID()) {
                pSPattern2.setID(preprocessorIDPool.getUniqueID(pSPattern3.getID()));
            }
            if (!pSPattern2.hasRich()) {
                pSPattern2.setRich(pSPattern3.getRichClone());
            }
            Map<String, String> map = this.m_aQueryBinding.getStringReplacementMap(pSPattern.getAllParams());
            for (IPSElement iPSElement : pSPattern3.getAllContentElements()) {
                PSRule pSRule;
                if (iPSElement instanceof PSLet) {
                    pSPattern2.addLet(((PSLet)iPSElement).getClone());
                    continue;
                }
                if (!(iPSElement instanceof PSRule) || (pSRule = this._getPreprocessedRule((PSRule)iPSElement, preprocessorLookup, preprocessorIDPool, map)) == null) continue;
                pSPattern2.addRule(pSRule);
            }
        } else {
            for (IPSElement iPSElement : pSPattern.getAllContentElements()) {
                PSRule pSRule;
                if (iPSElement instanceof PSLet) {
                    pSPattern2.addLet(((PSLet)iPSElement).getClone());
                    continue;
                }
                if (!(iPSElement instanceof PSRule) || (pSRule = this._getPreprocessedRule((PSRule)iPSElement, preprocessorLookup, preprocessorIDPool, null)) == null) continue;
                pSPattern2.addRule(pSRule);
            }
        }
        pSPattern2.addForeignElements(pSPattern.getAllForeignElements());
        pSPattern2.addForeignAttributes(pSPattern.getAllForeignAttributes());
        return pSPattern2;
    }

    @Nonnull
    private PSDiagnostics _getPreprocessedDiagnostics(@Nonnull PSDiagnostics pSDiagnostics) throws SchematronPreprocessException {
        PSDiagnostics pSDiagnostics2 = new PSDiagnostics();
        if (pSDiagnostics.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <diagnostics> with an <include>");
        }
        for (PSDiagnostic pSDiagnostic : pSDiagnostics.getAllDiagnostics()) {
            pSDiagnostics2.addDiagnostic(pSDiagnostic.getClone());
        }
        pSDiagnostics2.addForeignElements(pSDiagnostics.getAllForeignElements());
        pSDiagnostics2.addForeignAttributes(pSDiagnostics.getAllForeignAttributes());
        return pSDiagnostics2;
    }

    @Nullable
    public PSSchema getAsMinimalSchema(@Nonnull PSSchema pSSchema) throws SchematronPreprocessException {
        if (pSSchema == null) {
            throw new NullPointerException("Schema");
        }
        if (pSSchema.isMinimal()) {
            return pSSchema;
        }
        return this.getForcedPreprocessedSchema(pSSchema);
    }

    @Nullable
    public PSSchema getAsPreprocessedSchema(@Nonnull PSSchema pSSchema) throws SchematronPreprocessException {
        if (pSSchema == null) {
            throw new NullPointerException("Schema");
        }
        if (pSSchema.isPreprocessed()) {
            return pSSchema;
        }
        return this.getForcedPreprocessedSchema(pSSchema);
    }

    @Nullable
    public PSSchema getForcedPreprocessedSchema(@Nonnull PSSchema pSSchema) throws SchematronPreprocessException {
        if (pSSchema == null) {
            throw new NullPointerException("Schema");
        }
        PreprocessorLookup preprocessorLookup = new PreprocessorLookup(pSSchema);
        PreprocessorIDPool preprocessorIDPool = new PreprocessorIDPool();
        PSSchema pSSchema2 = new PSSchema(pSSchema.getResource());
        pSSchema2.setID(preprocessorIDPool.getUniqueID(pSSchema.getID()));
        pSSchema2.setRich(pSSchema.getRichClone());
        pSSchema2.setSchemaVersion(pSSchema.getSchemaVersion());
        pSSchema2.setDefaultPhase(pSSchema.getDefaultPhase());
        pSSchema2.setQueryBinding(pSSchema.getQueryBinding());
        if (this.m_bKeepTitles && pSSchema.hasTitle()) {
            pSSchema2.setTitle(pSSchema.getTitle().getClone());
        }
        if (pSSchema.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <schema> with an <include>");
        }
        for (PSNS iPSElement : pSSchema.getAllNSs()) {
            pSSchema2.addNS(iPSElement.getClone());
        }
        for (PSLet pSLet : pSSchema.getAllLets()) {
            pSSchema2.addLet(pSLet.getClone());
        }
        for (PSPhase pSPhase : pSSchema.getAllPhases()) {
            pSSchema2.addPhase(PSPreprocessor._getPreprocessedPhase(pSPhase, preprocessorIDPool));
        }
        for (PSPattern pSPattern : pSSchema.getAllPatterns()) {
            PSPattern pSPattern2 = this._getPreprocessedPattern(pSPattern, preprocessorLookup, preprocessorIDPool);
            if (pSPattern2 == null || pSPattern2.getRuleCount() <= 0 && !this.m_bKeepEmptyPatterns) continue;
            pSSchema2.addPattern(pSPattern2);
        }
        if (pSSchema.getPatternCount() == 0 && !this.m_bKeepEmptySchema) {
            return null;
        }
        if (this.m_bKeepDiagnostics && pSSchema.hasDiagnostics()) {
            pSSchema2.setDiagnostics(this._getPreprocessedDiagnostics(pSSchema.getDiagnostics()));
        }
        pSSchema2.addForeignElements(pSSchema.getAllForeignElements());
        pSSchema2.addForeignAttributes(pSSchema.getAllForeignAttributes());
        return pSSchema2;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("queryBinding", (Object)this.m_aQueryBinding).append("keepTitles", this.m_bKeepTitles).append("keepDiagnostics", this.m_bKeepDiagnostics).append("keepReports", this.m_bKeepReports).append("keepEmptyPatterns", this.m_bKeepEmptyPatterns).append("keepEmptySchema", this.m_bKeepEmptySchema).toString();
    }
}

