/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSClonableElement;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasMixedContent;
import com.phloc.schematron.pure.model.IPSOptionalElement;
import com.phloc.schematron.pure.model.PSDir;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSTitle
implements IPSClonableElement<PSTitle>,
IPSOptionalElement,
IPSHasMixedContent {
    private final List<Object> m_aContent = new ArrayList<Object>();

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement) || ((IPSElement)object).isValid(inMemoryLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("text");
        }
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public void addDir(@Nonnull PSDir pSDir) {
        if (pSDir == null) {
            throw new NullPointerException("Dir");
        }
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDir> getAllDirs() {
        ArrayList<PSDir> arrayList = new ArrayList<PSDir>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSDir)) continue;
            arrayList.add((PSDir)object);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<Object> getAllContentElements() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "title");
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        return microElement;
    }

    @Nonnull
    public PSTitle getClone() {
        PSTitle pSTitle = new PSTitle();
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                pSTitle.addText((String)object);
                continue;
            }
            if (!(object instanceof PSDir)) continue;
            pSTitle.addDir(((PSDir)object).getClone());
        }
        return pSTitle;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("content", this.m_aContent).toString();
    }
}

