/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.namespace.MapBasedNamespaceContext;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasID;
import com.phloc.schematron.pure.model.IPSHasIncludes;
import com.phloc.schematron.pure.model.IPSHasLets;
import com.phloc.schematron.pure.model.IPSHasRichGroup;
import com.phloc.schematron.pure.model.PSDiagnostics;
import com.phloc.schematron.pure.model.PSInclude;
import com.phloc.schematron.pure.model.PSLet;
import com.phloc.schematron.pure.model.PSNS;
import com.phloc.schematron.pure.model.PSP;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSPhase;
import com.phloc.schematron.pure.model.PSRichGroup;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSTitle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSSchema
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private final IReadableResource m_aResource;
    private String m_sID;
    private PSRichGroup m_aRich;
    private String m_sSchemaVersion;
    private String m_sDefaultPhase;
    private String m_sQueryBinding;
    private PSTitle m_aTitle;
    private final List<PSInclude> m_aIncludes = new ArrayList<PSInclude>();
    private final List<PSNS> m_aNSs = new ArrayList<PSNS>();
    private final List<PSP> m_aStartPs = new ArrayList<PSP>();
    private final List<PSLet> m_aLets = new ArrayList<PSLet>();
    private final List<PSPhase> m_aPhases = new ArrayList<PSPhase>();
    private final List<PSPattern> m_aPatterns = new ArrayList<PSPattern>();
    private final List<PSP> m_aEndPs = new ArrayList<PSP>();
    private PSDiagnostics m_aDiagnostics;
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    public PSSchema() {
        this(null);
    }

    public PSSchema(@Nullable IReadableResource iReadableResource) {
        this.m_aResource = iReadableResource;
    }

    @Nullable
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    public boolean isValid() {
        return this.isValid(new InMemoryLogger());
    }

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (this.m_aPatterns.isEmpty()) {
            inMemoryLogger.error((Serializable)((Object)"<schema> has no <pattern>s"));
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isValid(inMemoryLogger)) {
            return false;
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSNS pSNS : this.m_aNSs) {
            if (pSNS.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSP pSP : this.m_aStartPs) {
            if (pSP.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSLet pSLet : this.m_aLets) {
            if (pSLet.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            if (pSPhase.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            if (pSPattern.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSP pSP : this.m_aEndPs) {
            if (pSP.isValid(inMemoryLogger)) continue;
            return false;
        }
        return this.m_aDiagnostics == null || this.m_aDiagnostics.isValid(inMemoryLogger);
    }

    public boolean isPreprocessed() {
        if (this.hasAnyInclude()) {
            return false;
        }
        for (PSPhase iPSHasForeignElements : this.m_aPhases) {
            if (!iPSHasForeignElements.hasAnyInclude()) continue;
            return false;
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            if (pSPattern.isAbstract() || pSPattern.hasAnyInclude() || pSPattern.hasAnyParam()) {
                return false;
            }
            for (PSRule pSRule : pSPattern.getAllRules()) {
                if (!pSRule.isAbstract() && !pSRule.hasAnyInclude() && !pSRule.hasAnyExtends()) continue;
                return false;
            }
        }
        return this.m_aDiagnostics == null || !this.m_aDiagnostics.hasAnyInclude();
    }

    @Override
    public boolean isMinimal() {
        if (this.m_aTitle != null && !this.m_aTitle.isMinimal()) {
            return false;
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        for (PSNS pSNS : this.m_aNSs) {
            if (pSNS.isMinimal()) continue;
            return false;
        }
        for (PSP pSP : this.m_aStartPs) {
            if (pSP.isMinimal()) continue;
            return false;
        }
        for (PSLet pSLet : this.m_aLets) {
            if (pSLet.isMinimal()) continue;
            return false;
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            if (pSPhase.isMinimal()) continue;
            return false;
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            if (pSPattern.isMinimal()) continue;
            return false;
        }
        for (PSP pSP : this.m_aEndPs) {
            if (pSP.isMinimal()) continue;
            return false;
        }
        return this.m_aDiagnostics == null || this.m_aDiagnostics.isMinimal();
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            throw new NullPointerException("ForeignElement");
        }
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        if (list == null) {
            throw new NullPointerException("ForeignElements");
        }
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasRich() {
        return this.m_aRich != null;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    @Nullable
    public PSRichGroup getRichClone() {
        return this.m_aRich == null ? null : this.m_aRich.getClone();
    }

    public void setQueryBinding(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("queryBinding may not be empty!");
        }
        this.m_sQueryBinding = string;
    }

    @Nullable
    public String getQueryBinding() {
        return this.m_sQueryBinding;
    }

    public void setSchemaVersion(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("schemaVersion may not be empty!");
        }
        this.m_sSchemaVersion = string;
    }

    @Nullable
    public String getSchemaVersion() {
        return this.m_sSchemaVersion;
    }

    public void setDefaultPhase(@Nullable String string) {
        this.m_sDefaultPhase = string;
    }

    @Nullable
    public String getDefaultPhase() {
        return this.m_sDefaultPhase;
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aTitle = pSTitle;
    }

    @Nullable
    public PSTitle getTitle() {
        return this.m_aTitle;
    }

    public boolean hasTitle() {
        return this.m_aTitle != null;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        if (pSInclude == null) {
            throw new NullPointerException("Include");
        }
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return !this.m_aIncludes.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSInclude> getAllIncludes() {
        return ContainerHelper.newList(this.m_aIncludes);
    }

    public void addNS(@Nonnull PSNS pSNS) {
        if (pSNS == null) {
            throw new NullPointerException("NS");
        }
        this.m_aNSs.add(pSNS);
    }

    public boolean hasAnyNS() {
        return !this.m_aNSs.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSNS> getAllNSs() {
        return ContainerHelper.newList(this.m_aNSs);
    }

    @Nonnull
    @ReturnsMutableCopy
    public MapBasedNamespaceContext getAsNamespaceContext() {
        MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
        for (PSNS pSNS : this.m_aNSs) {
            mapBasedNamespaceContext.addMapping(pSNS.getPrefix(), pSNS.getUri());
        }
        return mapBasedNamespaceContext;
    }

    public void addStartP(@Nonnull PSP pSP) {
        if (pSP == null) {
            throw new NullPointerException("P");
        }
        this.m_aStartPs.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSP> getAllStartPs() {
        return ContainerHelper.newList(this.m_aStartPs);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        if (pSLet == null) {
            throw new NullPointerException("Let");
        }
        this.m_aLets.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return !this.m_aLets.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSLet> getAllLets() {
        return ContainerHelper.newList(this.m_aLets);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllLetsAsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (PSLet pSLet : this.m_aLets) {
            linkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return linkedHashMap;
    }

    public void addPhase(@Nonnull PSPhase pSPhase) {
        if (pSPhase == null) {
            throw new NullPointerException("Phase");
        }
        this.m_aPhases.add(pSPhase);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSPhase> getAllPhases() {
        return ContainerHelper.newList(this.m_aPhases);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllPhaseIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PSPhase pSPhase : this.m_aPhases) {
            if (!pSPhase.hasID()) continue;
            arrayList.add(pSPhase.getID());
        }
        return arrayList;
    }

    @Nullable
    public PSPhase getPhaseOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (PSPhase pSPhase : this.m_aPhases) {
                if (!string.equals(pSPhase.getID())) continue;
                return pSPhase;
            }
        }
        return null;
    }

    public void addPattern(@Nonnull PSPattern pSPattern) {
        if (pSPattern == null) {
            throw new NullPointerException("Pattern");
        }
        this.m_aPatterns.add(pSPattern);
    }

    public boolean hasPatterns() {
        return !this.m_aPatterns.isEmpty();
    }

    public boolean hasNoPatterns() {
        return this.m_aPatterns.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSPattern> getAllPatterns() {
        return ContainerHelper.newList(this.m_aPatterns);
    }

    @Nonnegative
    public int getPatternCount() {
        return this.m_aPatterns.size();
    }

    @Nullable
    public PSPattern getPatternOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (PSPattern pSPattern : this.m_aPatterns) {
                if (!string.equals(pSPattern.getID())) continue;
                return pSPattern;
            }
        }
        return null;
    }

    public void addEndP(@Nonnull PSP pSP) {
        if (pSP == null) {
            throw new NullPointerException("P");
        }
        this.m_aEndPs.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSP> getAllEndPs() {
        return ContainerHelper.newList(this.m_aEndPs);
    }

    public void setDiagnostics(@Nullable PSDiagnostics pSDiagnostics) {
        this.m_aDiagnostics = pSDiagnostics;
    }

    public boolean hasDiagnostics() {
        return this.m_aDiagnostics != null;
    }

    @Nullable
    public PSDiagnostics getDiagnostics() {
        return this.m_aDiagnostics;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "schema");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        microElement.setAttribute("schemaVersion", this.m_sSchemaVersion);
        microElement.setAttribute("defaultPhase", this.m_sDefaultPhase);
        microElement.setAttribute("queryBinding", this.m_sQueryBinding);
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)pSInclude.getAsMicroElement());
        }
        if (this.m_aTitle != null) {
            microElement.appendChild((IMicroNode)this.m_aTitle.getAsMicroElement());
        }
        for (PSNS pSNS : this.m_aNSs) {
            microElement.appendChild((IMicroNode)pSNS.getAsMicroElement());
        }
        for (PSP pSP : this.m_aStartPs) {
            microElement.appendChild((IMicroNode)pSP.getAsMicroElement());
        }
        for (PSLet pSLet : this.m_aLets) {
            microElement.appendChild((IMicroNode)pSLet.getAsMicroElement());
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            microElement.appendChild((IMicroNode)pSPhase.getAsMicroElement());
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            microElement.appendChild((IMicroNode)pSPattern.getAsMicroElement());
        }
        for (PSP pSP : this.m_aEndPs) {
            microElement.appendChild((IMicroNode)pSP.getAsMicroElement());
        }
        if (this.m_aDiagnostics != null) {
            microElement.appendChild((IMicroNode)this.m_aDiagnostics.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("resource", (Object)this.m_aResource).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotNull("schemaVersion", (Object)this.m_sSchemaVersion).appendIfNotNull("defaultPhase", (Object)this.m_sDefaultPhase).appendIfNotNull("queryBinding", (Object)this.m_sQueryBinding).appendIfNotNull("title", (Object)this.m_aTitle).append("includes", this.m_aIncludes).append("nss", this.m_aNSs).append("startps", this.m_aStartPs).append("lets", this.m_aLets).append("phases", this.m_aPhases).append("patterns", this.m_aPatterns).append("endps", this.m_aEndPs).appendIfNotNull("diagnostics", (Object)this.m_aDiagnostics).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }
}

