/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasFlag;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasID;
import com.phloc.schematron.pure.model.IPSHasIncludes;
import com.phloc.schematron.pure.model.IPSHasLets;
import com.phloc.schematron.pure.model.IPSHasLinkableGroup;
import com.phloc.schematron.pure.model.IPSHasRichGroup;
import com.phloc.schematron.pure.model.PSAssertReport;
import com.phloc.schematron.pure.model.PSExtends;
import com.phloc.schematron.pure.model.PSInclude;
import com.phloc.schematron.pure.model.PSLet;
import com.phloc.schematron.pure.model.PSLinkableGroup;
import com.phloc.schematron.pure.model.PSRichGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSRule
implements IPSElement,
IPSHasID,
IPSHasFlag,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup,
IPSHasLinkableGroup {
    public static final boolean DEFAULT_ABSTRACT = false;
    private String m_sFlag;
    private PSRichGroup m_aRich;
    private PSLinkableGroup m_aLinkable;
    private boolean m_bAbstract = false;
    private String m_sContext;
    private String m_sID;
    private final List<PSInclude> m_aIncludes = new ArrayList<PSInclude>();
    private final List<PSLet> m_aLets = new ArrayList<PSLet>();
    private final List<IPSElement> m_aContent = new ArrayList<IPSElement>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            inMemoryLogger.error((Serializable)((Object)"abstract <rule> has no 'id'"));
            return false;
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sContext)) {
            inMemoryLogger.error((Serializable)((Object)"abstract <rule> may not have a 'context'"));
            return false;
        }
        if (!this.m_bAbstract && StringHelper.hasNoText((String)this.m_sContext)) {
            inMemoryLogger.error((Serializable)((Object)"<rule> must have a 'context'"));
            return false;
        }
        if (this.m_aContent.isEmpty()) {
            inMemoryLogger.error((Serializable)((Object)"<rule> has no content"));
            return false;
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSLet pSLet : this.m_aLets) {
            if (pSLet.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isValid(inMemoryLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        for (PSLet pSLet : this.m_aLets) {
            if (pSLet.isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            throw new NullPointerException("ForeignElement");
        }
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        if (list == null) {
            throw new NullPointerException("ForeignElements");
        }
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setFlag(@Nullable String string) {
        this.m_sFlag = string;
    }

    @Override
    @Nullable
    public String getFlag() {
        return this.m_sFlag;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasRich() {
        return this.m_aRich != null;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    @Nullable
    public PSRichGroup getRichClone() {
        return this.m_aRich == null ? null : this.m_aRich.getClone();
    }

    @Override
    public void setLinkable(@Nullable PSLinkableGroup pSLinkableGroup) {
        this.m_aLinkable = pSLinkableGroup;
    }

    @Override
    public boolean hasLinkable() {
        return this.m_aLinkable != null;
    }

    @Override
    @Nullable
    public PSLinkableGroup getLinkable() {
        return this.m_aLinkable;
    }

    @Override
    @Nullable
    public PSLinkableGroup getLinkableClone() {
        return this.m_aLinkable == null ? null : this.m_aLinkable.getClone();
    }

    public void setAbstract(boolean bl) {
        this.m_bAbstract = bl;
    }

    public boolean isAbstract() {
        return this.m_bAbstract;
    }

    public void setContext(@Nullable String string) {
        this.m_sContext = string;
    }

    @Nullable
    public String getContext() {
        return this.m_sContext;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        if (pSInclude == null) {
            throw new NullPointerException("Include");
        }
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return !this.m_aIncludes.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSInclude> getAllIncludes() {
        return ContainerHelper.newList(this.m_aIncludes);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        if (pSLet == null) {
            throw new NullPointerException("Let");
        }
        this.m_aLets.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return !this.m_aLets.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSLet> getAllLets() {
        return ContainerHelper.newList(this.m_aLets);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllLetsAsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (PSLet pSLet : this.m_aLets) {
            linkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return linkedHashMap;
    }

    public void addAssertReport(@Nonnull PSAssertReport pSAssertReport) {
        if (pSAssertReport == null) {
            throw new NullPointerException("AssertReport");
        }
        this.m_aContent.add(pSAssertReport);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSAssertReport> getAllAssertReports() {
        ArrayList<PSAssertReport> arrayList = new ArrayList<PSAssertReport>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSAssertReport)) continue;
            arrayList.add((PSAssertReport)iPSElement);
        }
        return arrayList;
    }

    public void addExtends(@Nonnull PSExtends pSExtends) {
        if (pSExtends == null) {
            throw new NullPointerException("Extends");
        }
        this.m_aContent.add(pSExtends);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSExtends> getAllExtends() {
        ArrayList<PSExtends> arrayList = new ArrayList<PSExtends>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSExtends)) continue;
            arrayList.add((PSExtends)iPSElement);
        }
        return arrayList;
    }

    @Nonnegative
    public int getExtendsCount() {
        int n = 0;
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSExtends)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasAnyExtends() {
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSExtends)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<IPSElement> getAllContentElements() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "rule");
        microElement.setAttribute("flag", this.m_sFlag);
        if (this.m_bAbstract) {
            microElement.setAttribute("abstract", "true");
        }
        microElement.setAttribute("context", this.m_sContext);
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aLinkable != null) {
            this.m_aLinkable.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)pSInclude.getAsMicroElement());
        }
        for (PSLet pSLet : this.m_aLets) {
            microElement.appendChild((IMicroNode)pSLet.getAsMicroElement());
        }
        for (IPSElement iPSElement : this.m_aContent) {
            microElement.appendChild((IMicroNode)iPSElement.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("flag", (Object)this.m_sFlag).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotNull("linkable", (Object)this.m_aLinkable).append("abstract", this.m_bAbstract).appendIfNotNull("context", (Object)this.m_sContext).appendIfNotNull("id", (Object)this.m_sID).append("includes", this.m_aIncludes).append("lets", this.m_aLets).append("content", this.m_aContent).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }
}

