/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasID;
import com.phloc.schematron.pure.model.IPSHasIncludes;
import com.phloc.schematron.pure.model.IPSHasLets;
import com.phloc.schematron.pure.model.IPSHasRichGroup;
import com.phloc.schematron.pure.model.PSInclude;
import com.phloc.schematron.pure.model.PSLet;
import com.phloc.schematron.pure.model.PSP;
import com.phloc.schematron.pure.model.PSParam;
import com.phloc.schematron.pure.model.PSRichGroup;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSTitle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPattern
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private boolean m_bAbstract = false;
    private String m_sID;
    private String m_sIsA;
    private PSRichGroup m_aRich;
    private final List<PSInclude> m_aIncludes = new ArrayList<PSInclude>();
    private PSTitle m_aTitle;
    private final List<IPSElement> m_aContent = new ArrayList<IPSElement>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            inMemoryLogger.error((Serializable)((Object)"abstract <pattern> does not have an 'id'"));
            return false;
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sIsA)) {
            inMemoryLogger.error((Serializable)((Object)"abstract <pattern> may not have an 'is-a'"));
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sIsA)) {
            for (IPSElement iPSElement : this.m_aContent) {
                if (!(iPSElement instanceof PSParam)) continue;
                inMemoryLogger.error((Serializable)((Object)"<pattern> without 'is-a' may not contain <param>s"));
                return false;
            }
        } else {
            for (IPSElement iPSElement : this.m_aContent) {
                if (iPSElement instanceof PSRule) {
                    inMemoryLogger.error((Serializable)((Object)"<pattern> with 'is-a' may not contain <rule>s"));
                    return false;
                }
                if (!(iPSElement instanceof PSLet)) continue;
                inMemoryLogger.error((Serializable)((Object)"<pattern> with 'is-a' may not contain <let>s"));
                return false;
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            if (pSInclude.isValid(inMemoryLogger)) continue;
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isValid(inMemoryLogger)) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isValid(inMemoryLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        if (this.m_bAbstract) {
            return false;
        }
        if (StringHelper.hasText((String)this.m_sIsA)) {
            return false;
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isMinimal()) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aContent) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            throw new NullPointerException("ForeignElement");
        }
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        if (list == null) {
            throw new NullPointerException("ForeignElements");
        }
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setAbstract(boolean bl) {
        this.m_bAbstract = bl;
    }

    public boolean isAbstract() {
        return this.m_bAbstract;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setIsA(@Nullable String string) {
        this.m_sIsA = string;
    }

    @Nullable
    public String getIsA() {
        return this.m_sIsA;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasRich() {
        return this.m_aRich != null;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    @Nullable
    public PSRichGroup getRichClone() {
        return this.m_aRich == null ? null : this.m_aRich.getClone();
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        if (pSInclude == null) {
            throw new NullPointerException("Include");
        }
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return !this.m_aIncludes.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSInclude> getAllIncludes() {
        return ContainerHelper.newList(this.m_aIncludes);
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aTitle = pSTitle;
    }

    @Nullable
    public PSTitle getTitle() {
        return this.m_aTitle;
    }

    public boolean hasTitle() {
        return this.m_aTitle != null;
    }

    public void addRule(@Nonnull PSRule pSRule) {
        if (pSRule == null) {
            throw new NullPointerException("Rule");
        }
        this.m_aContent.add(pSRule);
    }

    @Nullable
    public PSRule getRuleOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (IPSElement iPSElement : this.m_aContent) {
                PSRule pSRule;
                if (!(iPSElement instanceof PSRule) || !string.equals((pSRule = (PSRule)iPSElement).getID())) continue;
                return pSRule;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSRule> getAllRules() {
        ArrayList<PSRule> arrayList = new ArrayList<PSRule>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSRule)) continue;
            arrayList.add((PSRule)iPSElement);
        }
        return arrayList;
    }

    @Nonnegative
    public int getRuleCount() {
        int n = 0;
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSRule)) continue;
            ++n;
        }
        return n;
    }

    public void addParam(@Nonnull PSParam pSParam) {
        if (pSParam == null) {
            throw new NullPointerException("Param");
        }
        this.m_aContent.add(pSParam);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSParam> getAllParams() {
        ArrayList<PSParam> arrayList = new ArrayList<PSParam>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSParam)) continue;
            arrayList.add((PSParam)iPSElement);
        }
        return arrayList;
    }

    public boolean hasAnyParam() {
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSParam)) continue;
            return true;
        }
        return false;
    }

    public void addP(@Nonnull PSP pSP) {
        if (pSP == null) {
            throw new NullPointerException("P");
        }
        this.m_aContent.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSP> getAllPs() {
        ArrayList<PSP> arrayList = new ArrayList<PSP>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSP)) continue;
            arrayList.add((PSP)iPSElement);
        }
        return arrayList;
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        if (pSLet == null) {
            throw new NullPointerException("Let");
        }
        this.m_aContent.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSLet> getAllLets() {
        ArrayList<PSLet> arrayList = new ArrayList<PSLet>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            arrayList.add((PSLet)iPSElement);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllLetsAsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (IPSElement iPSElement : this.m_aContent) {
            if (!(iPSElement instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)iPSElement;
            linkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<IPSElement> getAllContentElements() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "pattern");
        if (this.m_bAbstract) {
            microElement.setAttribute("abstract", "true");
        }
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("is-a", this.m_sIsA);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)pSInclude.getAsMicroElement());
        }
        if (this.m_aTitle != null) {
            microElement.appendChild((IMicroNode)this.m_aTitle.getAsMicroElement());
        }
        for (IPSElement iPSElement : this.m_aContent) {
            microElement.appendChild((IMicroNode)iPSElement.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("abstract", this.m_bAbstract).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("is-a", (Object)this.m_sIsA).appendIfNotNull("rich", (Object)this.m_aRich).append("includes", this.m_aIncludes).appendIfNotNull("title", (Object)this.m_aTitle).append("content", this.m_aContent).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }
}

