/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSClonableElement;
import com.phloc.schematron.pure.model.IPSHasForeignAttributes;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSNS
implements IPSClonableElement<PSNS>,
IPSHasForeignAttributes {
    private String m_sUri;
    private String m_sPrefix;
    private Map<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (StringHelper.hasNoText((String)this.m_sUri)) {
            inMemoryLogger.error((Serializable)((Object)"<ns> has no 'uri'"));
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sPrefix)) {
            inMemoryLogger.error((Serializable)((Object)"<ns> has no 'prefix'"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setUri(@Nullable String string) {
        this.m_sUri = string;
    }

    @Nullable
    public String getUri() {
        return this.m_sUri;
    }

    public void setPrefix(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nullable
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "ns");
        microElement.setAttribute("prefix", this.m_sPrefix);
        microElement.setAttribute("uri", this.m_sUri);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry<String, String> entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSNS getClone() {
        PSNS pSNS = new PSNS();
        pSNS.setUri(this.m_sUri);
        pSNS.setPrefix(this.m_sPrefix);
        if (this.hasForeignAttributes()) {
            pSNS.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSNS;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("uri", (Object)this.m_sUri).appendIfNotNull("prefix", (Object)this.m_sPrefix).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).toString();
    }
}

