/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignAttributes;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSExtends
implements IPSElement,
IPSHasForeignAttributes {
    private String m_sRule;
    private Map<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (StringHelper.hasNoText((String)this.m_sRule)) {
            inMemoryLogger.error((Serializable)((Object)"<extends> has no 'rule'"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setRule(@Nullable String string) {
        this.m_sRule = string;
    }

    @Nullable
    public String getRule() {
        return this.m_sRule;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "extends");
        microElement.setAttribute("rule", this.m_sRule);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry<String, String> entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("rule", (Object)this.m_sRule).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).toString();
    }
}

