/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSClonableElement;
import com.phloc.schematron.pure.model.IPSHasTexts;
import com.phloc.schematron.pure.model.IPSOptionalElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSEmph
implements IPSClonableElement<PSEmph>,
IPSOptionalElement,
IPSHasTexts {
    private final List<String> m_aContent = new ArrayList<String>();

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (this.m_aContent.isEmpty()) {
            inMemoryLogger.error((Serializable)((Object)"<emph> has no content"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("text");
        }
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        return !this.m_aContent.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Nullable
    public String getAsText() {
        return StringHelper.getImploded(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "emph");
        for (String string : this.m_aContent) {
            microElement.appendText((CharSequence)string);
        }
        return microElement;
    }

    @Nonnull
    public PSEmph getClone() {
        PSEmph pSEmph = new PSEmph();
        for (String string : this.m_aContent) {
            pSEmph.addText(string);
        }
        return pSEmph;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("content", this.m_aContent).toString();
    }
}

