/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasIncludes;
import com.phloc.schematron.pure.model.IPSOptionalElement;
import com.phloc.schematron.pure.model.PSDiagnostic;
import com.phloc.schematron.pure.model.PSInclude;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDiagnostics
implements IPSElement,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasIncludes {
    private final List<PSInclude> m_aIncludes = new ArrayList<PSInclude>();
    private final List<PSDiagnostic> m_aDiagnostics = new ArrayList<PSDiagnostic>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isValid(inMemoryLogger)) continue;
            return false;
        }
        for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
            if (pSDiagnostic.isValid(inMemoryLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            throw new NullPointerException("ForeignElement");
        }
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        if (list == null) {
            throw new NullPointerException("ForeignElements");
        }
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        if (pSInclude == null) {
            throw new NullPointerException("Include");
        }
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return !this.m_aIncludes.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSInclude> getAllIncludes() {
        return ContainerHelper.newList(this.m_aIncludes);
    }

    public void addDiagnostic(@Nonnull PSDiagnostic pSDiagnostic) {
        if (pSDiagnostic == null) {
            throw new NullPointerException("diagnostic");
        }
        this.m_aDiagnostics.add(pSDiagnostic);
    }

    @Nullable
    public PSDiagnostic getDiagnosticOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
                if (!string.equals(pSDiagnostic.getID())) continue;
                return pSDiagnostic;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDiagnostic> getAllDiagnostics() {
        return ContainerHelper.newList(this.m_aDiagnostics);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "diagnostics");
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)pSInclude.getAsMicroElement());
        }
        for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
            microElement.appendChild((IMicroNode)pSDiagnostic.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("includes", this.m_aIncludes).append("diagnostics", this.m_aDiagnostics).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }
}

