/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSClonableElement;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasID;
import com.phloc.schematron.pure.model.IPSHasMixedContent;
import com.phloc.schematron.pure.model.IPSHasRichGroup;
import com.phloc.schematron.pure.model.IPSOptionalElement;
import com.phloc.schematron.pure.model.PSDir;
import com.phloc.schematron.pure.model.PSEmph;
import com.phloc.schematron.pure.model.PSRichGroup;
import com.phloc.schematron.pure.model.PSSpan;
import com.phloc.schematron.pure.model.PSValueOf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDiagnostic
implements IPSClonableElement<PSDiagnostic>,
IPSOptionalElement,
IPSHasID,
IPSHasForeignElements,
IPSHasMixedContent,
IPSHasRichGroup {
    private String m_sID;
    private PSRichGroup m_aRich;
    private final List<Object> m_aContent = new ArrayList<Object>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement) || ((IPSElement)object).isValid(inMemoryLogger)) continue;
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sID)) {
            inMemoryLogger.error((Serializable)((Object)"<diagnostic> has no 'id'"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            throw new NullPointerException("ForeignElement");
        }
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        if (list == null) {
            throw new NullPointerException("ForeignElements");
        }
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        if (string == null) {
            throw new NullPointerException("AttrName");
        }
        if (string2 == null) {
            throw new NullPointerException("AttrValue");
        }
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("foreignAttrs");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasRich() {
        return this.m_aRich != null;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    @Nullable
    public PSRichGroup getRichClone() {
        return this.m_aRich == null ? null : this.m_aRich.getClone();
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("text");
        }
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public void addValueOf(@Nonnull PSValueOf pSValueOf) {
        if (pSValueOf == null) {
            throw new NullPointerException("ValueOf");
        }
        this.m_aContent.add(pSValueOf);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSValueOf> getAllValueOfs() {
        ArrayList<PSValueOf> arrayList = new ArrayList<PSValueOf>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSValueOf)) continue;
            arrayList.add((PSValueOf)object);
        }
        return arrayList;
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        if (pSEmph == null) {
            throw new NullPointerException("Emph");
        }
        this.m_aContent.add(pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSEmph> getAllEmphs() {
        ArrayList<PSEmph> arrayList = new ArrayList<PSEmph>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSEmph)) continue;
            arrayList.add((PSEmph)object);
        }
        return arrayList;
    }

    public void addDir(@Nonnull PSDir pSDir) {
        if (pSDir == null) {
            throw new NullPointerException("Dir");
        }
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDir> getAllDirs() {
        ArrayList<PSDir> arrayList = new ArrayList<PSDir>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSDir)) continue;
            arrayList.add((PSDir)object);
        }
        return arrayList;
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        if (pSSpan == null) {
            throw new NullPointerException("Span");
        }
        this.m_aContent.add(pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSSpan> getAllSpans() {
        ArrayList<PSSpan> arrayList = new ArrayList<PSSpan>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSSpan)) continue;
            arrayList.add((PSSpan)object);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<Object> getAllContentElements() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "diagnostic");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSDiagnostic getClone() {
        PSDiagnostic pSDiagnostic = new PSDiagnostic();
        pSDiagnostic.setID(this.m_sID);
        pSDiagnostic.setRich(this.getRichClone());
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                pSDiagnostic.addText((String)object);
                continue;
            }
            if (object instanceof PSValueOf) {
                pSDiagnostic.addValueOf(((PSValueOf)object).getClone());
                continue;
            }
            if (object instanceof PSEmph) {
                pSDiagnostic.addEmph(((PSEmph)object).getClone());
                continue;
            }
            if (object instanceof PSDir) {
                pSDiagnostic.addDir(((PSDir)object).getClone());
                continue;
            }
            if (!(object instanceof PSSpan)) continue;
            pSDiagnostic.addSpan(((PSSpan)object).getClone());
        }
        if (this.hasForeignElements()) {
            pSDiagnostic.addForeignElements(this.m_aForeignElements);
        }
        if (this.hasForeignAttributes()) {
            pSDiagnostic.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSDiagnostic;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("rich", (Object)this.m_aRich).append("content", this.m_aContent).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }
}

