/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.bound;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.SchematronException;
import com.phloc.schematron.pure.binding.IPSQueryBinding;
import com.phloc.schematron.pure.binding.PSQueryBindingRegistry;
import com.phloc.schematron.pure.bound.IPSBoundSchema;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.exchange.PSReader;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.preprocess.PSPreprocessor;
import com.phloc.schematron.pure.preprocess.SchematronPreprocessException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSBoundSchemaCacheKey {
    private final IReadableResource m_aResource;
    private final String m_sPhase;
    private final IPSErrorHandler m_aErrorHandler;

    public PSBoundSchemaCacheKey(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) {
        if (iReadableResource == null) {
            throw new NullPointerException("Resource");
        }
        this.m_aResource = iReadableResource;
        this.m_sPhase = string;
        this.m_aErrorHandler = iPSErrorHandler;
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nullable
    public final String getPhase() {
        return this.m_sPhase;
    }

    @Nullable
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nonnull
    @OverrideOnDemand
    protected PSSchema readSchema(@Nonnull IReadableResource iReadableResource, @Nullable IPSErrorHandler iPSErrorHandler) throws SchematronException {
        return new PSReader(iReadableResource, iPSErrorHandler).readSchema();
    }

    @Nonnull
    @OverrideOnDemand
    protected IPSQueryBinding getQueryBinding(@Nonnull PSSchema pSSchema) throws SchematronException {
        return PSQueryBindingRegistry.getQueryBindingOfNameOrThrow(pSSchema.getQueryBinding());
    }

    @Nonnull
    @OverrideOnDemand
    protected PSPreprocessor createPreprocessor(@Nonnull IPSQueryBinding iPSQueryBinding) {
        PSPreprocessor pSPreprocessor = new PSPreprocessor(iPSQueryBinding);
        pSPreprocessor.setKeepTitles(true);
        return pSPreprocessor;
    }

    @Nonnull
    @OverrideOnDemand
    protected PSSchema createPreprocessedSchema(@Nonnull PSSchema pSSchema, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronException {
        PSPreprocessor pSPreprocessor = this.createPreprocessor(iPSQueryBinding);
        PSSchema pSSchema2 = pSPreprocessor.getAsPreprocessedSchema(pSSchema);
        if (pSSchema2 == null) {
            throw new SchematronPreprocessException("Failed to preprocess schema " + pSSchema);
        }
        return pSSchema2;
    }

    @Nonnull
    public IPSBoundSchema createBoundSchema() throws SchematronException {
        PSSchema pSSchema = this.readSchema(this.getResource(), this.getErrorHandler());
        IPSQueryBinding iPSQueryBinding = this.getQueryBinding(pSSchema);
        PSSchema pSSchema2 = this.createPreprocessedSchema(pSSchema, iPSQueryBinding);
        return iPSQueryBinding.bind(pSSchema2, this.getPhase(), this.getErrorHandler());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PSBoundSchemaCacheKey pSBoundSchemaCacheKey = (PSBoundSchemaCacheKey)object;
        return this.m_aResource.equals(pSBoundSchemaCacheKey.m_aResource) && EqualsUtils.equals((Object)this.m_sPhase, (Object)pSBoundSchemaCacheKey.m_sPhase);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aResource).append((Object)this.m_sPhase).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aResource).append("phase", (Object)this.m_sPhase).toString();
    }
}

