/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.binding.xpath;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.compare.ComparatorStringLongestFirst;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.string.StringHelper;
import com.phloc.schematron.SchematronException;
import com.phloc.schematron.pure.binding.IPSQueryBinding;
import com.phloc.schematron.pure.binding.SchematronBindException;
import com.phloc.schematron.pure.bound.IPSBoundSchema;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundSchema;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.model.PSParam;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.preprocess.PSPreprocessor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSXPathQueryBinding
implements IPSQueryBinding {
    public static final char PARAM_VARIABLE_PREFIX = '$';
    private static final Logger s_aLogger = LoggerFactory.getLogger(PSXPathQueryBinding.class);
    private static final PSXPathQueryBinding s_aInstance = new PSXPathQueryBinding();

    private PSXPathQueryBinding() {
    }

    @Nonnull
    public static PSXPathQueryBinding getInstance() {
        return s_aInstance;
    }

    @Override
    @Nonnull
    public String getNegatedTestExpression(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("test");
        }
        if (string.startsWith("not(") && string.endsWith(")")) {
            return string.substring(4, string.length() - 2);
        }
        return "not(" + string + ")";
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getStringReplacementMap(@Nonnull List<PSParam> list) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>((Comparator<String>)new ComparatorStringLongestFirst());
        for (PSParam pSParam : list) {
            treeMap.put('$' + pSParam.getName(), pSParam.getValue());
        }
        return treeMap;
    }

    @Nullable
    public static String getWithParamTextsReplacedStatic(@Nullable String string, @Nullable Map<String, String> map) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(36) < 0) {
            return string;
        }
        String string2 = StringHelper.replaceMultiple((String)string, map);
        return string2;
    }

    @Override
    @Nullable
    public String getWithParamTextsReplaced(@Nullable String string, @Nullable Map<String, String> map) {
        return PSXPathQueryBinding.getWithParamTextsReplacedStatic(string, map);
    }

    @Override
    @Nonnull
    public IPSBoundSchema bind(@Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) throws SchematronException {
        if (pSSchema == null) {
            throw new NullPointerException("Schema");
        }
        InMemoryLogger inMemoryLogger = new InMemoryLogger();
        if (!pSSchema.isValid(inMemoryLogger)) {
            throw new SchematronBindException("The passed schema is not valid and can therefore not be bound: " + inMemoryLogger.getAllMessages());
        }
        PSSchema pSSchema2 = pSSchema;
        if (!pSSchema2.isPreprocessed()) {
            PSPreprocessor pSPreprocessor = new PSPreprocessor(this);
            pSPreprocessor.setKeepReports(true);
            pSPreprocessor.setKeepDiagnostics(true);
            pSPreprocessor.setKeepTitles(true);
            pSSchema2 = pSPreprocessor.getForcedPreprocessedSchema(pSSchema);
        }
        return new PSXPathBoundSchema(this, pSSchema2, string, iPSErrorHandler);
    }
}

