/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.state.EValidity;
import com.phloc.commons.xml.serialize.XMLReader;
import com.phloc.schematron.AbstractSchematronResource;
import com.phloc.schematron.SchematronException;
import com.phloc.schematron.SchematronUtils;
import com.phloc.schematron.pure.bound.IPSBoundSchema;
import com.phloc.schematron.pure.bound.PSBoundSchemaCache;
import com.phloc.schematron.pure.bound.PSBoundSchemaCacheKey;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.svrl.SVRLWriter;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Immutable
public class SchematronResourcePure
extends AbstractSchematronResource {
    private final PSBoundSchemaCacheKey m_aCacheKey;

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, null, null);
    }

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) {
        this(iReadableResource, new PSBoundSchemaCacheKey(iReadableResource, string, iPSErrorHandler));
    }

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource, @Nonnull PSBoundSchemaCacheKey pSBoundSchemaCacheKey) {
        super(iReadableResource);
        if (pSBoundSchemaCacheKey == null) {
            throw new NullPointerException("cacheKey");
        }
        this.m_aCacheKey = pSBoundSchemaCacheKey;
    }

    @Nonnull
    protected IPSBoundSchema getBoundSchema() {
        return (IPSBoundSchema)PSBoundSchemaCache.getInstance().getFromCache(this.m_aCacheKey);
    }

    @Override
    public boolean isValidSchematron() {
        return this.getBoundSchema().getOriginalSchema().isValid();
    }

    @Nonnull
    public SchematronOutputType applySchematronValidation(@Nonnull Node node) throws SchematronException {
        return this.getBoundSchema().validateComplete(node);
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull IReadableResource iReadableResource) throws Exception {
        if (!this.isValidSchematron()) {
            return EValidity.INVALID;
        }
        Document document = XMLReader.readXMLDOM((IReadableResource)iReadableResource);
        if (document == null) {
            throw new IllegalArgumentException("Failed to read resource " + iReadableResource + " as XML");
        }
        return this.getBoundSchema().validatePartially(document);
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull Source source) throws Exception {
        if (!this.isValidSchematron()) {
            return EValidity.INVALID;
        }
        Node node = SchematronUtils.getNodeOfSource(source);
        if (node == null) {
            return EValidity.INVALID;
        }
        return this.getBoundSchema().validatePartially(node);
    }

    @Override
    @Nullable
    public Document applySchematronValidation(@Nonnull IReadableResource iReadableResource) throws Exception {
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(iReadableResource);
        return schematronOutputType == null ? null : SVRLWriter.createXML(schematronOutputType);
    }

    @Override
    @Nullable
    public Document applySchematronValidation(@Nonnull Source source) throws Exception {
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(source);
        return schematronOutputType == null ? null : SVRLWriter.createXML(schematronOutputType);
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull IReadableResource iReadableResource) throws Exception {
        if (iReadableResource == null) {
            throw new NullPointerException("XMLResource");
        }
        if (!this.isValidSchematron()) {
            return null;
        }
        if (!iReadableResource.exists()) {
            return null;
        }
        Document document = XMLReader.readXMLDOM((IReadableResource)iReadableResource);
        if (document == null) {
            throw new IllegalArgumentException("Failed to read resource " + iReadableResource + " as XML");
        }
        return this.applySchematronValidation(document);
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Source source) throws Exception {
        if (source == null) {
            throw new NullPointerException("XMLSource");
        }
        if (!this.isValidSchematron()) {
            return null;
        }
        Node node = SchematronUtils.getNodeOfSource(source);
        if (node == null) {
            return null;
        }
        return this.applySchematronValidation(node);
    }

    @Nonnull
    public static SchematronResourcePure fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourcePure((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourcePure((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromFile(@Nonnull File file) {
        return new SchematronResourcePure((IReadableResource)new FileSystemResource(file));
    }
}

