import type { Registry } from '@/registry/schema';

export const blocks: Registry = [
  {
    category: 'Editors',
    files: [
      {
        path: 'block/editor-select/page.tsx',
        target: 'app/editor/page.tsx',
        type: 'registry:page',
      },
    ],
    name: 'editor-select',
    registryDependencies: ['select-editor-demo'],
    type: 'registry:block',
  },
  {
    category: 'Editors',
    dependencies: [
      '@udecode/cn',
      '@udecode/plate-ai',
      '@udecode/plate-basic-marks',
      '@udecode/plate-block-quote',
      '@udecode/plate-code-block',
      '@udecode/plate-comments',
      '@udecode/plate-common',
      '@udecode/plate-date',
      '@udecode/plate-emoji',
      '@udecode/plate-excalidraw',
      '@udecode/plate-heading',
      '@udecode/plate-highlight',
      '@udecode/plate-horizontal-rule',
      '@udecode/plate-kbd',
      '@udecode/plate-layout',
      '@udecode/plate-link',
      '@udecode/plate-media',
      '@udecode/plate-mention',
      '@udecode/plate-slash-command',
      '@udecode/plate-table',
      '@udecode/plate-toggle',
      'sonner',
    ],
    files: [
      {
        path: 'block/editor-ai/page.tsx',
        target: 'app/editor/page.tsx',
        type: 'registry:page',
      },
      {
        path: 'block/editor-ai/components/editor/plate-editor.tsx',
        target: 'components/editor/plate-editor.tsx',
        type: 'registry:component',
      },
      {
        path: 'block/editor-ai/components/editor/use-create-editor.ts',
        target: 'components/editor/use-create-editor.ts',
        type: 'registry:component',
      },
      {
        path: 'components/editor/settings.tsx',
        target: 'components/editor/settings.tsx',
        type: 'registry:component',
      },
    ],
    name: 'editor-ai',
    registryDependencies: [
      'api-ai',
      'api-uploadthing',
      'plate-types',

      'editor-plugins',
      'copilot-plugins',
      'floating-toolbar-plugin',
      'fixed-toolbar-plugin',

      'ai-menu',
      'ghost-text',
      'comments-popover',
      'cursor-overlay',
      'editor',
      'block-context-menu',

      'ai-leaf',
      'blockquote-element',
      'code-block-element',
      'code-leaf',
      'code-line-element',
      'code-syntax-leaf',
      'column-element',
      'column-group-element',
      'comment-leaf',
      'date-element',
      'draggable',
      'emoji-input-element',
      'excalidraw-element',
      'heading-element',
      'highlight-leaf',
      'hr-element',
      'image-element',
      'kbd-leaf',
      'link-element',
      'media-audio-element',
      'media-embed-element',
      'media-file-element',
      'media-placeholder-element',
      'media-video-element',
      'mention-element',
      'mention-input-element',
      'paragraph-element',
      'placeholder',
      'slash-input-element',
      'table-cell-element',
      'table-element',
      'table-row-element',
      'toc-element',
      'toggle-element',
    ],
    type: 'registry:block',
  },
  {
    category: 'Editors',
    dependencies: [
      '@udecode/plate-basic-elements',
      '@udecode/plate-basic-marks',
    ],
    files: [
      {
        path: 'block/editor-basic/page.tsx',
        target: 'app/editor/page.tsx',
        type: 'registry:page',
      },
      {
        path: 'block/editor-basic/components/editor/plate-editor.tsx',
        target: 'components/editor/plate-editor.tsx',
        type: 'registry:component',
      },
      {
        path: 'block/editor-basic/components/editor/use-create-editor.ts',
        target: 'components/editor/use-create-editor.ts',
        type: 'registry:component',
      },
    ],
    name: 'editor-basic',
    registryDependencies: ['editor'],
    type: 'registry:block',
  },
];
