export const baseColors = [
  {
    activeColor: {
      dark: '240 5.2% 33.9%',
      light: '240 5.9% 10%',
    },
    cssVars: {
      dark: {
        accent: '240 3.7% 15.9%',
        'accent-foreground': '0 0% 98%',
        background: '240 10% 3.9%',
        border: '240 3.7% 25%',
        brand: '213.3 93.9% 67.8%',
        card: '240 10% 3.9%',
        'card-foreground': '0 0% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '0 0% 98%',
        foreground: '0 0% 98%',
        highlight: '48 96% 53%',
        input: '240 3.7% 25%',
        muted: '240 3.7% 15.9%',
        'muted-foreground': '240 5% 64.9%',
        popover: '240 10% 3.9%',
        'popover-foreground': '0 0% 98%',
        primary: '0 0% 98%',
        'primary-foreground': '240 5.9% 10%',
        ring: '240 4.9% 83.9%',
        secondary: '240 3.7% 15.9%',
        'secondary-foreground': '0 0% 98%',
      },
      light: {
        accent: '240 4.8% 95.9%',
        'accent-foreground': '240 5.9% 10%',
        background: '0 0% 100%',
        border: '240 5.9% 90%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '240 10% 3.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '0 0% 98%',
        foreground: '240 10% 3.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '240 5.9% 90%',
        muted: '240 4.8% 95.9%',
        'muted-foreground': '240 3.8% 46.1%',
        popover: '0 0% 100%',
        'popover-foreground': '240 10% 3.9%',
        primary: '240 5.9% 10%',
        'primary-foreground': '0 0% 98%',
        radius: '0.5rem',
        ring: '240 5.9% 10%',
        secondary: '240 4.8% 95.9%',
        'secondary-foreground': '240 5.9% 10%',
      },
    },
    label: 'Zinc',
    name: 'zinc',
  },
  {
    activeColor: {
      dark: '215.3 19.3% 34.5%',
      light: '215.4 16.3% 46.9%',
    },
    cssVars: {
      dark: {
        accent: '217.2 32.6% 17.5%',
        'accent-foreground': '210 40% 98%',
        background: '222.2 84% 4.9%',
        border: '217.2 32.6% 17.5%',
        brand: '213.3 93.9% 67.8%',
        card: '222.2 84% 4.9%',
        'card-foreground': '210 40% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '210 40% 98%',
        foreground: '210 40% 98%',
        highlight: '48 96% 53%',
        input: '217.2 32.6% 17.5%',
        muted: '217.2 32.6% 17.5%',
        'muted-foreground': '215 20.2% 65.1%',
        popover: '222.2 84% 4.9%',
        'popover-foreground': '210 40% 98%',
        primary: '210 40% 98%',
        'primary-foreground': '222.2 47.4% 11.2%',
        ring: '217.2 32.6% 17.5%',
        secondary: '217.2 32.6% 17.5%',
        'secondary-foreground': '210 40% 98%',
      },
      light: {
        accent: '210 40% 96.1%',
        'accent-foreground': '222.2 47.4% 11.2%',
        background: '0 0% 100%',
        border: '214.3 31.8% 91.4%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '222.2 84% 4.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '210 40% 98%',
        foreground: '222.2 84% 4.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '214.3 31.8% 91.4%',
        muted: '210 40% 96.1%',
        'muted-foreground': '215.4 16.3% 46.9%',
        popover: '0 0% 100%',
        'popover-foreground': '222.2 84% 4.9%',
        primary: '222.2 47.4% 11.2%',
        'primary-foreground': '210 40% 98%',
        radius: '0.5rem',
        ring: '215 20.2% 65.1%',
        secondary: '210 40% 96.1%',
        'secondary-foreground': '222.2 47.4% 11.2%',
      },
    },
    label: 'Slate',
    name: 'slate',
  },
  {
    activeColor: {
      dark: '33.3 5.5% 32.4%',
      light: '25 5.3% 44.7%',
    },
    cssVars: {
      dark: {
        accent: '12 6.5% 15.1%',
        'accent-foreground': '60 9.1% 97.8%',
        background: '20 14.3% 4.1%',
        border: '12 6.5% 15.1%',
        brand: '213.3 93.9% 67.8%',
        card: '20 14.3% 4.1%',
        'card-foreground': '60 9.1% 97.8%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '60 9.1% 97.8%',
        foreground: '60 9.1% 97.8%',
        highlight: '48 96% 53%',
        input: '12 6.5% 15.1%',
        muted: '12 6.5% 15.1%',
        'muted-foreground': '24 5.4% 63.9%',
        popover: '20 14.3% 4.1%',
        'popover-foreground': '60 9.1% 97.8%',
        primary: '60 9.1% 97.8%',
        'primary-foreground': '24 9.8% 10%',
        ring: '24 5.7% 82.9%',
        secondary: '12 6.5% 15.1%',
        'secondary-foreground': '60 9.1% 97.8%',
      },
      light: {
        accent: '60 4.8% 95.9%',
        'accent-foreground': '24 9.8% 10%',
        background: '0 0% 100%',
        border: '20 5.9% 90%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '20 14.3% 4.1%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '60 9.1% 97.8%',
        foreground: '20 14.3% 4.1%',
        highlight: '47.9 95.8% 53.1%',
        input: '20 5.9% 90%',
        muted: '60 4.8% 95.9%',
        'muted-foreground': '25 5.3% 44.7%',
        popover: '0 0% 100%',
        'popover-foreground': '20 14.3% 4.1%',
        primary: '24 9.8% 10%',
        'primary-foreground': '60 9.1% 97.8%',
        radius: '0.95rem',
        ring: '20 14.3% 4.1%',
        secondary: '60 4.8% 95.9%',
        'secondary-foreground': '24 9.8% 10%',
      },
    },
    label: 'Stone',
    name: 'stone',
  },
  {
    activeColor: {
      dark: '215 13.8% 34.1%',
      light: '220 8.9% 46.1%',
    },
    cssVars: {
      dark: {
        accent: '215 27.9% 16.9%',
        'accent-foreground': '210 20% 98%',
        background: '224 71.4% 4.1%',
        border: '215 27.9% 16.9%',
        brand: '213.3 93.9% 67.8%',
        card: '224 71.4% 4.1%',
        'card-foreground': '210 20% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '210 20% 98%',
        foreground: '210 20% 98%',
        highlight: '48 96% 53%',
        input: '215 27.9% 16.9%',
        muted: '215 27.9% 16.9%',
        'muted-foreground': '217.9 10.6% 64.9%',
        popover: '224 71.4% 4.1%',
        'popover-foreground': '210 20% 98%',
        primary: '210 20% 98%',
        'primary-foreground': '220.9 39.3% 11%',
        ring: '216 12.2% 83.9%',
        secondary: '215 27.9% 16.9%',
        'secondary-foreground': '210 20% 98%',
      },
      light: {
        accent: '220 14.3% 95.9%',
        'accent-foreground': '220.9 39.3% 11%',
        background: '0 0% 100%',
        border: '220 13% 91%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '224 71.4% 4.1%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '210 20% 98%',
        foreground: '224 71.4% 4.1%',
        highlight: '47.9 95.8% 53.1%',
        input: '220 13% 91%',
        muted: '220 14.3% 95.9%',
        'muted-foreground': '220 8.9% 46.1%',
        popover: '0 0% 100%',
        'popover-foreground': '224 71.4% 4.1%',
        primary: '220.9 39.3% 11%',
        'primary-foreground': '210 20% 98%',
        radius: '0.35rem',
        ring: '224 71.4% 4.1%',
        secondary: '220 14.3% 95.9%',
        'secondary-foreground': '220.9 39.3% 11%',
      },
    },
    label: 'Gray',
    name: 'gray',
  },
  {
    activeColor: {
      dark: '0 0% 32.2%',
      light: '0 0% 45.1%',
    },
    cssVars: {
      dark: {
        accent: '0 0% 14.9%',
        'accent-foreground': '0 0% 98%',
        background: '0 0% 3.9%',
        border: '0 0% 14.9%',
        brand: '213.3 93.9% 67.8%',
        card: '0 0% 3.9%',
        'card-foreground': '0 0% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '0 0% 98%',
        foreground: '0 0% 98%',
        highlight: '48 96% 53%',
        input: '0 0% 14.9%',
        muted: '0 0% 14.9%',
        'muted-foreground': '0 0% 63.9%',
        popover: '0 0% 3.9%',
        'popover-foreground': '0 0% 98%',
        primary: '0 0% 98%',
        'primary-foreground': '0 0% 9%',
        ring: '0 0% 83.1%',
        secondary: '0 0% 14.9%',
        'secondary-foreground': '0 0% 98%',
      },
      light: {
        accent: '0 0% 96.1%',
        'accent-foreground': '0 0% 9%',
        background: '0 0% 100%',
        border: '0 0% 89.8%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '0 0% 3.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '0 0% 98%',
        foreground: '0 0% 3.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '0 0% 89.8%',
        muted: '0 0% 96.1%',
        'muted-foreground': '0 0% 45.1%',
        popover: '0 0% 100%',
        'popover-foreground': '0 0% 3.9%',
        primary: '0 0% 9%',
        'primary-foreground': '0 0% 98%',
        ring: '0 0% 3.9%',
        secondary: '0 0% 96.1%',
        'secondary-foreground': '0 0% 9%',
      },
    },
    label: 'Neutral',
    name: 'neutral',
  },
  {
    activeColor: {
      dark: '0 72.2% 50.6%',
      light: '0 72.2% 50.6%',
    },
    cssVars: {
      dark: {
        accent: '0 0% 14.9%',
        'accent-foreground': '0 0% 98%',
        background: '0 0% 3.9%',
        border: '0 0% 14.9%',
        brand: '213.3 93.9% 67.8%',
        card: '0 0% 3.9%',
        'card-foreground': '0 0% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '0 0% 98%',
        foreground: '0 0% 98%',
        highlight: '48 96% 53%',
        input: '0 0% 14.9%',
        muted: '0 0% 14.9%',
        'muted-foreground': '0 0% 63.9%',
        popover: '0 0% 3.9%',
        'popover-foreground': '0 0% 98%',
        primary: '0 72.2% 50.6%',
        'primary-foreground': '0 85.7% 97.3%',
        ring: '0 72.2% 50.6%',
        secondary: '0 0% 14.9%',
        'secondary-foreground': '0 0% 98%',
      },
      light: {
        accent: '0 0% 96.1%',
        'accent-foreground': '0 0% 9%',
        background: '0 0% 100%',
        border: '0 0% 89.8%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '0 0% 3.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '0 0% 98%',
        foreground: '0 0% 3.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '0 0% 89.8%',
        muted: '0 0% 96.1%',
        'muted-foreground': '0 0% 45.1%',
        popover: '0 0% 100%',
        'popover-foreground': '0 0% 3.9%',
        primary: '0 72.2% 50.6%',
        'primary-foreground': '0 85.7% 97.3%',
        radius: '0.4rem',
        ring: '0 72.2% 50.6%',
        secondary: '0 0% 96.1%',
        'secondary-foreground': '0 0% 9%',
      },
    },
    label: 'Red',
    name: 'red',
  },
  {
    activeColor: {
      dark: '346.8 77.2% 49.8%',
      light: '346.8 77.2% 49.8%',
    },
    cssVars: {
      dark: {
        accent: '12 6.5% 15.1%',
        'accent-foreground': '0 0% 98%',
        background: '20 14.3% 4.1%',
        border: '240 3.7% 25%',
        brand: '213.3 93.9% 67.8%',
        card: '24 9.8% 10%',
        'card-foreground': '0 0% 95%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '0 85.7% 97.3%',
        foreground: '0 0% 95%',
        highlight: '48 96% 53%',
        input: '240 3.7% 25%',
        muted: '0 0% 15%',
        'muted-foreground': '240 5% 64.9%',
        popover: '0 0% 9%',
        'popover-foreground': '0 0% 95%',
        primary: '346.8 77.2% 49.8%',
        'primary-foreground': '355.7 100% 97.3%',
        ring: '346.8 77.2% 49.8%',
        secondary: '240 3.7% 15.9%',
        'secondary-foreground': '0 0% 98%',
      },
      light: {
        accent: '240 4.8% 95.9%',
        'accent-foreground': '240 5.9% 10%',
        background: '0 0% 100%',
        border: '240 5.9% 90%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '240 10% 3.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '0 0% 98%',
        foreground: '240 10% 3.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '240 5.9% 90%',
        muted: '240 4.8% 95.9%',
        'muted-foreground': '240 3.8% 46.1%',
        popover: '0 0% 100%',
        'popover-foreground': '240 10% 3.9%',
        primary: '346.8 77.2% 49.8%',
        'primary-foreground': '355.7 100% 97.3%',
        radius: '0.5rem',
        ring: '346.8 77.2% 49.8%',
        secondary: '240 4.8% 95.9%',
        'secondary-foreground': '240 5.9% 10%',
      },
    },
    label: 'Rose',
    name: 'rose',
  },
  {
    activeColor: {
      dark: '20.5 90.2% 48.2%',
      light: '24.6 95% 53.1%',
    },
    cssVars: {
      dark: {
        accent: '12 6.5% 15.1%',
        'accent-foreground': '60 9.1% 97.8%',
        background: '20 14.3% 4.1%',
        border: '12 6.5% 15.1%',
        brand: '213.3 93.9% 67.8%',
        card: '20 14.3% 4.1%',
        'card-foreground': '60 9.1% 97.8%',
        destructive: '0 72.2% 50.6%',
        'destructive-foreground': '60 9.1% 97.8%',
        foreground: '60 9.1% 97.8%',
        highlight: '48 96% 53%',
        input: '12 6.5% 15.1%',
        muted: '12 6.5% 15.1%',
        'muted-foreground': '24 5.4% 63.9%',
        popover: '20 14.3% 4.1%',
        'popover-foreground': '60 9.1% 97.8%',
        primary: '20.5 90.2% 48.2%',
        'primary-foreground': '60 9.1% 97.8%',
        ring: '20.5 90.2% 48.2%',
        secondary: '12 6.5% 15.1%',
        'secondary-foreground': '60 9.1% 97.8%',
      },
      light: {
        accent: '60 4.8% 95.9%',
        'accent-foreground': '24 9.8% 10%',
        background: '0 0% 100%',
        border: '20 5.9% 90%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '20 14.3% 4.1%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '60 9.1% 97.8%',
        foreground: '20 14.3% 4.1%',
        highlight: '47.9 95.8% 53.1%',
        input: '20 5.9% 90%',
        muted: '60 4.8% 95.9%',
        'muted-foreground': '25 5.3% 44.7%',
        popover: '0 0% 100%',
        'popover-foreground': '20 14.3% 4.1%',
        primary: '24.6 95% 53.1%',
        'primary-foreground': '60 9.1% 97.8%',
        radius: '0.95rem',
        ring: '24.6 95% 53.1%',
        secondary: '60 4.8% 95.9%',
        'secondary-foreground': '24 9.8% 10%',
      },
    },
    label: 'Orange',
    name: 'orange',
  },
  {
    activeColor: {
      dark: '142.1 70.6% 45.3%',
      light: '142.1 76.2% 36.3%',
    },
    cssVars: {
      dark: {
        accent: '12 6.5% 15.1%',
        'accent-foreground': '0 0% 98%',
        background: '20 14.3% 4.1%',
        border: '240 3.7% 25%',
        brand: '213.3 93.9% 67.8%',
        card: '24 9.8% 10%',
        'card-foreground': '0 0% 95%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '0 85.7% 97.3%',
        foreground: '0 0% 95%',
        highlight: '48 96% 53%',
        input: '240 3.7% 25%',
        muted: '0 0% 15%',
        'muted-foreground': '240 5% 64.9%',
        popover: '0 0% 9%',
        'popover-foreground': '0 0% 95%',
        primary: '142.1 70.6% 45.3%',
        'primary-foreground': '144.9 80.4% 10%',
        ring: '142.4 71.8% 29.2%',
        secondary: '240 3.7% 15.9%',
        'secondary-foreground': '0 0% 98%',
      },
      light: {
        accent: '240 4.8% 95.9%',
        'accent-foreground': '240 5.9% 10%',
        background: '0 0% 100%',
        border: '240 5.9% 90%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '240 10% 3.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '0 0% 98%',
        foreground: '240 10% 3.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '240 5.9% 90%',
        muted: '240 4.8% 95.9%',
        'muted-foreground': '240 3.8% 46.1%',
        popover: '0 0% 100%',
        'popover-foreground': '240 10% 3.9%',
        primary: '142.1 76.2% 36.3%',
        'primary-foreground': '355.7 100% 97.3%',
        ring: '142.1 76.2% 36.3%',
        secondary: '240 4.8% 95.9%',
        'secondary-foreground': '240 5.9% 10%',
      },
    },
    label: 'Green',
    name: 'green',
  },
  {
    activeColor: {
      dark: '217.2 91.2% 59.8%',
      light: '221.2 83.2% 53.3%',
    },
    cssVars: {
      dark: {
        accent: '217.2 32.6% 17.5%',
        'accent-foreground': '210 40% 98%',
        background: '222.2 84% 4.9%',
        border: '217.2 32.6% 17.5%',
        brand: '213.3 93.9% 67.8%',
        card: '222.2 84% 4.9%',
        'card-foreground': '210 40% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '210 40% 98%',
        foreground: '210 40% 98%',
        highlight: '48 96% 53%',
        input: '217.2 32.6% 17.5%',
        muted: '217.2 32.6% 17.5%',
        'muted-foreground': '215 20.2% 65.1%',
        popover: '222.2 84% 4.9%',
        'popover-foreground': '210 40% 98%',
        primary: '217.2 91.2% 59.8%',
        'primary-foreground': '222.2 47.4% 11.2%',
        ring: '224.3 76.3% 48%',
        secondary: '217.2 32.6% 17.5%',
        'secondary-foreground': '210 40% 98%',
      },
      light: {
        accent: '210 40% 96.1%',
        'accent-foreground': '222.2 47.4% 11.2%',
        background: '0 0% 100%',
        border: '214.3 31.8% 91.4%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '222.2 84% 4.9%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '210 40% 98%',
        foreground: '222.2 84% 4.9%',
        highlight: '47.9 95.8% 53.1%',
        input: '214.3 31.8% 91.4%',
        muted: '210 40% 96.1%',
        'muted-foreground': '215.4 16.3% 46.9%',
        popover: '0 0% 100%',
        'popover-foreground': '222.2 84% 4.9%',
        primary: '221.2 83.2% 53.3%',
        'primary-foreground': '210 40% 98%',
        ring: '221.2 83.2% 53.3%',
        secondary: '210 40% 96.1%',
        'secondary-foreground': '222.2 47.4% 11.2%',
      },
    },
    label: 'Blue',
    name: 'blue',
  },
  {
    activeColor: {
      dark: '47.9 95.8% 53.1%',
      light: '47.9 95.8% 53.1%',
    },
    cssVars: {
      dark: {
        accent: '12 6.5% 15.1%',
        'accent-foreground': '60 9.1% 97.8%',
        background: '20 14.3% 4.1%',
        border: '12 6.5% 15.1%',
        brand: '213.3 93.9% 67.8%',
        card: '20 14.3% 4.1%',
        'card-foreground': '60 9.1% 97.8%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '60 9.1% 97.8%',
        foreground: '60 9.1% 97.8%',
        highlight: '48 96% 53%',
        input: '12 6.5% 15.1%',
        muted: '12 6.5% 15.1%',
        'muted-foreground': '24 5.4% 63.9%',
        popover: '20 14.3% 4.1%',
        'popover-foreground': '60 9.1% 97.8%',
        primary: '47.9 95.8% 53.1%',
        'primary-foreground': '26 83.3% 14.1%',
        ring: '35.5 91.7% 32.9%',
        secondary: '12 6.5% 15.1%',
        'secondary-foreground': '60 9.1% 97.8%',
      },
      light: {
        accent: '60 4.8% 95.9%',
        'accent-foreground': '24 9.8% 10%',
        background: '0 0% 100%',
        border: '20 5.9% 90%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '20 14.3% 4.1%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '60 9.1% 97.8%',
        foreground: '20 14.3% 4.1%',
        highlight: '47.9 95.8% 53.1%',
        input: '20 5.9% 90%',
        muted: '60 4.8% 95.9%',
        'muted-foreground': '25 5.3% 44.7%',
        popover: '0 0% 100%',
        'popover-foreground': '20 14.3% 4.1%',
        primary: '47.9 95.8% 53.1%',
        'primary-foreground': '26 83.3% 14.1%',
        radius: '0.95rem',
        ring: '20 14.3% 4.1%',
        secondary: '60 4.8% 95.9%',
        'secondary-foreground': '24 9.8% 10%',
      },
    },
    label: 'Yellow',
    name: 'yellow',
  },
  {
    activeColor: {
      dark: '263.4 70% 50.4%',
      light: '262.1 83.3% 57.8%',
    },
    cssVars: {
      dark: {
        accent: '215 27.9% 16.9%',
        'accent-foreground': '210 20% 98%',
        background: '224 71.4% 4.1%',
        border: '215 27.9% 16.9%',
        brand: '213.3 93.9% 67.8%',
        card: '224 71.4% 4.1%',
        'card-foreground': '210 20% 98%',
        destructive: '0 62.8% 30.6%',
        'destructive-foreground': '210 20% 98%',
        foreground: '210 20% 98%',
        highlight: '48 96% 53%',
        input: '215 27.9% 16.9%',
        muted: '215 27.9% 16.9%',
        'muted-foreground': '217.9 10.6% 64.9%',
        popover: '224 71.4% 4.1%',
        'popover-foreground': '210 20% 98%',
        primary: '263.4 70% 50.4%',
        'primary-foreground': '210 20% 98%',
        ring: '263.4 70% 50.4%',
        secondary: '215 27.9% 16.9%',
        'secondary-foreground': '210 20% 98%',
      },
      light: {
        accent: '220 14.3% 95.9%',
        'accent-foreground': '220.9 39.3% 11%',
        background: '0 0% 100%',
        border: '220 13% 91%',
        brand: '217.2 91.2% 59.8%',
        card: '0 0% 100%',
        'card-foreground': '224 71.4% 4.1%',
        destructive: '0 72.22% 50.59%',
        'destructive-foreground': '210 20% 98%',
        foreground: '224 71.4% 4.1%',
        highlight: '47.9 95.8% 53.1%',
        input: '220 13% 91%',
        muted: '220 14.3% 95.9%',
        'muted-foreground': '220 8.9% 46.1%',
        popover: '0 0% 100%',
        'popover-foreground': '224 71.4% 4.1%',
        primary: '262.1 83.3% 57.8%',
        'primary-foreground': '210 20% 98%',
        ring: '262.1 83.3% 57.8%',
        secondary: '220 14.3% 95.9%',
        'secondary-foreground': '220.9 39.3% 11%',
      },
    },
    label: 'Violet',
    name: 'violet',
  },
] as const;

export type BaseColor = (typeof baseColors)[number];
