import type { SidebarNavItem } from '@/types/nav';

export const docsApi: SidebarNavItem[] = [
  {
    description: 'Common utilities for Plate.',
    headings: [],
    href: '/docs/api/common',
    title: 'Plate Common',
  },
  {
    description: 'Core utilities for Plate.',
    headings: [
      'createAtomStore',
      'createDeserializeAstPlugin',
      'createHtmlPlugin',
      'createEditorProtocolPlugin',
      'createEventEditorPlugin',
      'createHistoryPlugin',
      'createInlineVoidPlugin',
      'createInsertDataPlugin',
      'createPlateEditor',
      'createSlatePlugin',
      'createPrevSelectionPlugin',
      'createPlatePlugin',
      'getPlugin',
      'getPluginInjectProps',
      'getPluginOptions',
      'getPluginType',
      'Hotkeys',
      'toggleBlock',
      'useEditorRef',
      'useEditorState',
      'useElement',
      'useEditorReadOnly',
      'useEditorSelection',
      'useEditorVersion',
      'useSelectionVersion',
      'withPlate',
      'withTReact',
    ],
    href: '/docs/api/core',
    items: [
      {
        headings: [
          'PlateProps',
          'PlateContent',
          'id',
          'children',
          'decorate',
          'disableCorePlugins',
          'editableProps',
          'editableRef',
          'editor',
          'firstChildren',
          'initialValue',
          'normalizeInitialValue',
          'onChange',
          'plugins',
          'renderEditable',
          'renderElement',
          'renderLeaf',
          'value',
        ],
        href: '/docs/api/core/plate',
        title: 'Plate',
      },
      {
        headings: [
          'platecontroller-store',
          'state',
          'activeId',
          'primaryEditorIds',
          'editorStores',
          'usage-patterns',
          'specific-editor-by-id',
          'active-editor',
          'dealing-with-fallback-editors',
        ],
        href: '/docs/api/core/plate-controller',
        title: 'PlateController',
      },
      {
        headings: [
          'currentKeyboardEvent',
          'key',
          'plugins',
          'pluginsByKey',
          'prevSelection',
          'redecorate',
          'reset',
        ],
        href: '/docs/api/core/plate-editor',
        title: 'PlateEditor',
      },
      {
        headings: [
          'key',
          'component',
          'decorate',
          'html',
          'attributeNames',
          'getNode',
          'query',
          'rules',
          'validAttribute',
          'validClassName',
          'validNodeName',
          'validStyle',
          'withoutChildren',
          'editor',
          'insertData',
          'format',
          'getFragment',
          'preInsert',
          'transformData',
          'transformFragment',
          'handlers',
          'onKeyDown',
          'onDrop',
          'onDragStart',
          'inject',
          'aboveComponent',
          'belowComponent',
          'pluginsByKey',
          'className',
          'defaultNodeValue',
          'nodeKey',
          'styleKey',
          'transformClassName',
          'transformNodeValue',
          'transformStyle',
          'validNodeValues',
          'targetPlugins',
          'isInline',
          'isElement',
          'isLeaf',
          'isVoid',
          'normalizeInitialValue',
          'options',
          'overrideByKey',
          'plugins',
          'props',
          'aboveEditable',
          'aboveSlate',
          'afterEditable',
          'beforeEditable',
          'serializeHtml',
          'then',
          'type',
          'useHooks',
          'extendEditor',
        ],
        href: '/docs/api/core/plate-plugin',
        title: 'PlatePlugin',
      },
      {
        headings: ['useEventEditorSelectors', 'useEventPlateId'],
        href: '/docs/api/core/store',
        title: 'Store',
      },
    ],
    title: 'Plate Core',
  },
  {
    description: 'Additional utilities for Plate.',
    headings: [
      'PlateElement',
      'PlateLeaf',
      'useMarkToolbarButtonState',
      'useMarkToolbarButton',
      'usePlaceholderState',
      'useRemoveNodeButton',
      'isType',
      'resetEditorChildren',
      'selectEditor',
      'defaultsDeepToNodes',
    ],
    href: '/docs/api/utils',
    title: 'Plate Utils',
  },
  {
    description: 'Slate utilities.',
    headings: [
      'addMark',
      'createPathRef',
      'createPointRef',
      'createRangeRef',
      'deleteBackward',
      'deleteForward',
      'deleteFragment',
      'deleteMerge',
      'getAboveNode',
      'getEdgePoints',
      'getEditorString',
      'getEndPoint',
      'getFirstNode',
      'getFragment',
      'getLastNode',
      'getLeafNode',
      'getLevels',
      'getMarks',
      'getNextNode',
      'getNodeEntries',
      'getNodeEntry',
      'getParentNode',
      'getPath',
      'getPathRefs',
      'getPoint',
      'getPointAfter',
      'getPointBefore',
      'getPointRefs',
      'getPositions',
      'getPreviousNode',
      'getRange',
      'getRangeRefs',
      'getStartPoint',
      'getVoidNode',
      'hasBlocks',
      'hasInlines',
      'hasTexts',
      'insertBreak',
      'insertNode',
      'isBlock',
      'isEdgePoint',
      'isEditor',
      'isEditorNormalizing',
      'isElementEmpty',
      'isEndPoint',
      'isInline',
      'isStartPoint',
      'isVoid',
      'normalizeEditor',
      'removeEditorMark',
      'TEditor',
      'unhangRange',
      'withoutNormalizing',
      'elementMatches',
      'isElement',
      'isElementList',
      'TElement',
      'isHistoryEditor',
      'isHistoryMerging',
      'isHistorySaving',
      'withoutMergingHistory',
      'withoutSavingHistory',
      'TDescendant',
      'getNodeDescendants',
      'getNodeLastNode',
      'getNodeString',
      'getNodeFirstNode',
      'hasNode',
      'isNode',
      'getNodeFragment',
      'getNodeLeaf',
      'getNodeLevels',
      'isNodeList',
      'getNodeProps',
      'TAncestor',
      'getNode',
      'getNodeTexts',
      'getNodes',
      'getNodeChildren',
      'getNodeAncestor',
      'TNodeEntry',
      'TNode',
      'nodeMatches',
      'getNodeChild',
      'getNodeElements',
      'getNodeAncestors',
      'getNodeDescendant',
      'getCommonNode',
      'isAncestor',
      'hasSingleChild',
      'getNodeParent',
      'isCollapsed',
      'isExpanded',
      'isText',
      'isTextList',
      'textEquals',
      'textMatches',
      'TText',
      'moveNodes',
      'moveSelection',
      'removeNodes',
      'select',
      'insertText',
      'insertNodes',
      'deleteText',
      'setPoint',
      'setNodes',
      'unwrapNodes',
      'deselect',
      'mergeNodes',
      'collapseSelection',
      'unsetNodes',
      'setSelection',
      'splitNodes',
      'insertFragment',
      'wrapNodes',
      'liftNodes',
    ],
    href: '/docs/api/slate',
    title: 'Slate',
  },
  {
    description: 'Slate React utilities.',
    headings: [
      'blurEditor',
      'hasEditorSelectableTarget',
      'insertData',
      'hasEditorDOMNode',
      'focusEditor',
      'findNodeKey',
      'getEditorWindow',
      'toDOMRange',
      'toDOMNode',
      'findEditorDocumentOrShadowRoot',
      'setFragmentData',
      'toSlateNode',
      'findEventRange',
      'isEditorFocused',
      'isComposing',
      'hasEditorTarget',
      'isEditorReadOnly',
      'isTargetInsideNonReadonlyVoidEditor',
      'deselectEditor',
      'hasEditorEditableTarget',
      'toSlatePoint',
      'findNodePath',
      'SlateProps',
      'toSlateRange',
      'toDOMPoint',
    ],
    href: '/docs/api/slate-react',
    title: 'Slate React',
  },
  {
    description: 'Additional utilities for Slate.',
    headings: [
      'findDescendant',
      'getBlockAbove',
      'getChildren',
      'getEdgeBlocksAbove',
      'getLastChild',
      'getLastNodeByLevel',
      'getMark',
      'getNextNodeStartPoint',
      'getNextSiblingNodes',
      'getOperations',
      'getPointBeforeLocation',
      'getPointFromLocation',
      'getPointNextToVoid',
      'getPreviousBlockById',
      'getPreviousNodeEndPoint',
      'getPreviousPath',
      'getPreviousSiblingNode',
      'getRangeBefore',
      'getRangeFromBlockStart',
      'getSelectionText',
      'isAncestorEmpty',
      'isBlockAboveEmpty',
      'isBlockTextEmptyAfterSelection',
      'isDocumentEnd',
      'isFirstChild',
      'isMarkActive',
      'isPointAtWordEnd',
      'isRangeAcrossBlocks',
      'isRangeInSameBlock',
      'isRangeInSingleText',
      'isSelectionAtBlockEnd',
      'isSelectionAtBlockStart',
      'isSelectionExpanded',
      'isTextByPath',
      'isWordAfterTrigger',
      'queryEditor',
      'insertElements',
      'insertEmptyElement',
      'moveChildren',
      'removeMark',
      'removeNodeChildren',
      'removeSelectionMark',
      'replaceNodeChildren',
      'selectEndOfBlockAboveSelection',
      'setMarks',
      'toggleMark',
      'toggleWrapNodes',
      'wrapNodeChildren',
      'createDocumentNode',
      'createNode',
    ],
    href: '/docs/api/slate-utils',
    title: 'Slate Utils',
  },
  {
    description: 'React utilities.',
    headings: [
      'PortalBody',
      'Text',
      'Box',
      'createPrimitiveComponent',
      'createSlotComponent',
      'withProviders',
    ],
    href: '/docs/api/react-utils',
    title: 'React Utils',
  },
  {
    description: 'Class utilities.',
    headings: ['cn', 'withCn', 'withProps', 'withVariants'],
    href: '/docs/api/cn',
    title: 'cn',
  },
  {
    description: 'API reference for @udecode/plate-floating',
    headings: [],
    href: '/docs/api/floating',
    label: 'New',
    title: 'Floating',
  },
  {
    description: 'API reference for @udecode/plate-resizable',
    headings: [],
    href: '/docs/api/resizable',
    label: 'New',
    title: 'Resizable',
  },
];
