# [Beautiful Web Type](https://beautifulwebtype.com)

In October 2018 I released a completely re-thought and re-designed version of this project. The new version aims to provide a complete look at each typeface, cataloging all the available weights and styles, the full glyph set, the kerning quality, OpenType features, recommended pairings and more. I will highlight only typefaces that show a high level of quality.

The original version of the site is archived here: https://beautifulwebtype.com/v1/

## Changelog

### 23 Oct 2023
* **Added [TASA Orbiter](https://beautifulwebtype.com/tasa-orbiter/)**.

### 8 Apr 2023
 * **Updated [Source Code Pro](https://beautifulwebtype.com/source-code-pro/)** to version 1.024.

### 22 Nov 2020
* **Added [Fraunces](https://beautifulwebtype.com/fraunces/)**.
* **Added pairing example** for Fraunces and Libre Franklin.
* **Added pairing example** for Messapia and Inter.

### 21 Nov 2020
* **Added [Inter](https://beautifulwebtype.com/inter/)**.
* **Updated glyph inspector** to include plain text character in sidebar for easier copying.

### 23 May 2020
* **Added [Messapia](https://beautifulwebtype.com/messapia/)**.
* **Added [Crimson Pro](https://beautifulwebtype.com/crimson-pro/)**.
* **Updated [Source Code Pro](https://beautifulwebtype.com/source-code-pro/)** to variable version.
* **Updated [iA Writer Quattro](https://beautifulwebtype.com/ia-writer-quattro/)** to variable version.
* **Updated [Fire Code](https://beautifulwebtype.com/fira-code/)** to v4.0 variable version.
* **Updated [Lora](https://beautifulwebtype.com/lora/)** to variable version.
* **Updated [Work Sans](https://beautifulwebtype.com/work-sans/)** to variable version.
* **Updated [Space Grotesk](https://beautifulwebtype.com/space-grotesk/)** to variable version.
* **Updated Manrope** to variable version.
* **Updated [Source Serif Pro](https://beautifulwebtype.com/source-serif-pro/)** to variable version.
* **Updated [Source Sans Pro](https://beautifulwebtype.com/source-sans-pro/)** to variable version.

**[Read full Changelog](https://github.com/ubuwaits/beautiful-web-type/blob/gh-pages/CHANGELOG.md)**

## Featured typefaces
All typefaces are licensed under the [SIL Open Font License](https://scripts.sil.org/OFL).

* [Alegreya](https://beautifulwebtype.com/alegreya/) &#8594; [Glyph inspector](https://beautifulwebtype.com/alegreya/glyphs/)
* [Alegreya Sans](https://beautifulwebtype.com/alegreya-sans/) &#8594; [Glyph inspector](https://beautifulwebtype.com/alegreya-sans/glyphs/)
* [Archivo](https://beautifulwebtype.com/archivo/) &#8594; [Glyph inspector](https://beautifulwebtype.com/archivo/glyphs/)
* [Archivo Black](https://beautifulwebtype.com/archivo-black/) &#8594; [Glyph inspector](https://beautifulwebtype.com/archivo-black/glyphs/)
* [BioRhyme](https://beautifulwebtype.com/biorhyme/) &#8594; [Glyph inspector](https://beautifulwebtype.com/biorhyme/glyphs/)
* [BioRhyme Expanded](https://beautifulwebtype.com/biorhyme-expanded/) &#8594; [Glyph inspector](https://beautifulwebtype.com/biorhyme-expanded/glyphs/)
* [Cooper Hewitt](https://beautifulwebtype.com/cooper-hewitt/) &#8594; [Glyph inspector](https://beautifulwebtype.com/cooper-hewitt/glyphs/)
* [Crimson Pro](https://beautifulwebtype.com/crimson-pro/) &#8594; [Glyph inspector](https://beautifulwebtype.com/crimson-pro/glyphs/)
* [Fira Code](https://beautifulwebtype.com/fira-code/) &#8594; [Glyph inspector](https://beautifulwebtype.com/fira-code/glyphs/)
* [FiraGo](https://beautifulwebtype.com/firago/) &#8594; [Glyph inspector](https://beautifulwebtype.com/firago/glyphs/)
* [Fivo Sans](https://beautifulwebtype.com/fivo-sans/) &#8594; [Glyph inspector](https://beautifulwebtype.com/fivo-sans/glyphs/)
* [Fivo Sans Modern](https://beautifulwebtype.com/fivo-sans-modern/) &#8594; [Glyph inspector](https://beautifulwebtype.com/fivo-sans-modern/glyphs/)
* [Fraunces](https://beautifulwebtype.com/fraunces/) &#8594; [Glyph inspector](https://beautifulwebtype.com/fraunces/glyphs/)
* [iA Writer Quattro](https://beautifulwebtype.com/ia-writer-quattro/) &#8594; [Glyph inspector](https://beautifulwebtype.com/ia-writer-quattro/glyphs/)
* [IBM Plex Mono](https://beautifulwebtype.com/ibm-plex-mono/) &#8594; [Glyph inspector](https://beautifulwebtype.com/ibm-plex-mono/glyphs/)
* [IBM Plex Sans](https://beautifulwebtype.com/ibm-plex-sans/) &#8594; [Glyph inspector](https://beautifulwebtype.com/ibm-plex-sans/glyphs/)
* [IBM Plex Sans Condensed](https://beautifulwebtype.com/ibm-plex-sans-condensed/) &#8594; [Glyph inspector](https://beautifulwebtype.com/ibm-plex-sans-condensed/glyphs/)
* [IBM Plex Serif](https://beautifulwebtype.com/ibm-plex-serif/) &#8594; [Glyph inspector](https://beautifulwebtype.com/ibm-plex-serif/glyphs/)
* [Inria Sans](https://beautifulwebtype.com/inria-sans/) &#8594; [Glyph inspector](https://beautifulwebtype.com/inria-sans/glyphs/)
* [Inria Serif](https://beautifulwebtype.com/inria-serif/) &#8594; [Glyph inspector](https://beautifulwebtype.com/inria-serif/glyphs/)
* [Inter](https://beautifulwebtype.com/inter/) &#8594; [Glyph inspector](https://beautifulwebtype.com/inter/glyphs/)
* [Jost*](https://beautifulwebtype.com/jost/) &#8594; [Glyph inspector](https://beautifulwebtype.com/jost/glyphs/)
* [Le Murmure](https://beautifulwebtype.com/le-murmure/) &#8594; [Glyph inspector](https://beautifulwebtype.com/le-murmure/glyphs/)
* [Libre Franklin](https://beautifulwebtype.com/libre-franklin/) &#8594; [Glyph inspector](https://beautifulwebtype.com/libre-franklin/glyphs/)
* [Lora](https://beautifulwebtype.com/lora/) &#8594; [Glyph inspector](https://beautifulwebtype.com/lora/glyphs/)
* [Messapia](https://beautifulwebtype.com/messapia/) &#8594; [Glyph inspector](https://beautifulwebtype.com/messapia/glyphs/)
* [Oswald](https://beautifulwebtype.com/oswald/) &#8594; [Glyph inspector](https://beautifulwebtype.com/oswald/glyphs/)
* [Playfair Display](https://beautifulwebtype.com/playfair-display/) &#8594; [Glyph inspector](https://beautifulwebtype.com/playfair-display/glyphs/)
* [Poppins](https://beautifulwebtype.com/poppins/) &#8594; [Glyph inspector](https://beautifulwebtype.com/poppins/glyphs/)
* [Rakkas](https://beautifulwebtype.com/rakkas/) &#8594; [Glyph inspector](https://beautifulwebtype.com/rakkas/glyphs/)
* [Source Code Pro](https://beautifulwebtype.com/source-code-pro/) &#8594; [Glyph inspector](https://beautifulwebtype.com/source-code-pro/glyphs/)
* [Source Sans Pro](https://beautifulwebtype.com/source-sans-pro/) &#8594; [Glyph inspector](https://beautifulwebtype.com/source-sans-pro/glyphs/)
* [Source Serif Pro](https://beautifulwebtype.com/source-serif-pro/) &#8594; [Glyph inspector](https://beautifulwebtype.com/source-serif-pro/glyphs/)
* [Space Grotesk](https://beautifulwebtype.com/space-grotesk/) &#8594; [Glyph inspector](https://beautifulwebtype.com/space-grotesk/glyphs/)
* [Space Mono](https://beautifulwebtype.com/space-mono/) &#8594; [Glyph inspector](https://beautifulwebtype.com/space-mono/glyphs/)
* [TASA Orbiter](https://beautifulwebtype.com/tasa-orbiter/) &#8594; [Glyph inspector](https://beautifulwebtype.com/tasa-orbiter/glyphs/)
* [Vollkorn](https://beautifulwebtype.com/vollkorn/) &#8594; [Glyph inspector](https://beautifulwebtype.com/vollkorn/glyphs/)
* [Work Sans](https://beautifulwebtype.com/work-sans/) &#8594; [Glyph inspector](https://beautifulwebtype.com/work-sans/glyphs/)
* [Zilla Slab](https://beautifulwebtype.com/zilla-slab/) &#8594; [Glyph inspector](https://beautifulwebtype.com/zilla-slab/glyphs/)

## Suggesting Typefaces

I'm happy to receive suggestions for typefaces via [a GitHub issue](https://github.com/ubuwaits/beautiful-web-type/issues). When sending suggestions please include an example or two of the typeface in use. This helps me to make an initial evaluation of the typeface.

## Local development

To work with the site locally, start the Jekyll server and watch the Sass files with:

    rake s
