"""Initial migration

Revision ID: 47f5b8adb56b
Revises: 
Create Date: 2024-03-08 02:22:01.454335+00:00

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "47f5b8adb56b"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "chat_history",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("session_id", sa.Text(), nullable=False),
        sa.Column("history_json", sqlite.JSON(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_chat_history_session_id"), "chat_history", ["session_id"], unique=False
    )
    op.create_table(
        "chat_record",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("session_id", sa.Text(), nullable=False),
        sa.Column("event_name", sa.Text(), nullable=False),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.Column("meta_json", sqlite.JSON(), nullable=True),
        sa.ForeignKeyConstraint(
            ["session_id"], ["chat_history.session_id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_chat_record_session_id"), "chat_record", ["session_id"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_chat_record_session_id"), table_name="chat_record")
    op.drop_table("chat_record")
    op.drop_index(op.f("ix_chat_history_session_id"), table_name="chat_history")
    op.drop_table("chat_history")
    # ### end Alembic commands ###
