/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

// Mostly from https://github.com/tensorflow/tensorflow/blob/r2.4/tensorflow/cc/saved_model/reader.h
// with some modifications

/// Functions to read the SavedModel proto, or parts of it.

#ifndef TENSORFLOW_CC_SAVED_MODEL_READER_H_
#define TENSORFLOW_CC_SAVED_MODEL_READER_H_

// Workaround for TF issue
// https://github.com/abseil/abseil-cpp/issues/211
#include "absl/base/config.h"
#undef ABSL_HAVE_STD_STRING_VIEW
#undef ABSL_USES_STD_STRING_VIEW

#include "tensorflow/core/lib/core/status.h"
#include "tensorflow/core/protobuf/meta_graph.pb.h"

#include <string>
#include <unordered_set>

namespace tensorflow
{

// Reads the SavedModel proto from saved_model.pb(txt) in the given directory,
// finds the MetaGraphDef that matches the given set of tags and writes it to
// the `meta_graph_def` parameter. Returns a failure status when the SavedModel
// file does not exist or no MetaGraphDef matches the tags.
Status ReadMetaGraphDefFromSavedModel(const string &                    export_dir,
                                      const std::unordered_set<string> &tags,
                                      MetaGraphDef *const               meta_graph_def);

} // namespace tensorflow

#endif // TENSORFLOW_CC_SAVED_MODEL_READER_H_
