## Contributing

If you're interested in implementing a new feature or bugfix:

1. Please create [an issue](https://github.com/uber/neuropod/issues) describing the proposed feature/bugfix.

2. We'll discuss the implementation plan and design. If everything looks good, go ahead and implement it.

3. Once you're ready to submit your change for review, create a pull request (see GitHub's instructions on [forking a repo](https://help.github.com/en/github/getting-started-with-github/fork-a-repo) and [creating a pull request from a fork](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request-from-a-fork)).

If you're interested in implementing a feature or fixing a bug described by an [existing issue](https://github.com/uber/neuropod/issues):

1. Comment on the issue saying you'd like to work on it and provide some detail about your proposed solution. Note that we generally don't assign issues to external contributors, but it's still recommended to comment on the issue to express your intent.

2. We'll discuss the implementation plan and design. If everything looks good, go ahead and implement it.

3. Once you're ready to submit your change for review, create a pull request (see GitHub's instructions on [forking a repo](https://help.github.com/en/github/getting-started-with-github/fork-a-repo) and [creating a pull request from a fork](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request-from-a-fork)).


Some issues are tagged "good first issue". These are generally a good place to start if you're looking for a way to contribute.

### Guidelines

To streamline the PR review process, please:

- Write clear and concise titles and descriptions
- Include tests in your PR
- Ensure your PR passes lint locally (see the [lint](#lint-and-static-analysis) section above)
- Include comments in your code
- Keep PRs small. These tend to be easier to review.
