/*
 * Copyright (C) 2019. Uber Technologies
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.uber.lintchecks.android

import org.w3c.dom.Attr
import org.w3c.dom.Element
import org.w3c.dom.Node

/**
 * Utils regarding vector drawables.
 */
object UiDetectorUtils {
  const val VECTOR = "vector"

  fun isInVectorDrawable(attribute: Attr) = isInVectorDrawable(attribute.ownerElement)

  fun isInVectorDrawable(element: Element): Boolean {
    var node: Node? = element
    while (node != null) {
      if (node.nodeName == VECTOR) {
        return true
      } else {
        node = node.parentNode
      }
    }
    return false
  }
}
