/*
 * Decompiled with CFR 0.152.
 */
package com.uber.presidio.intellij_plugin.generator;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.text.StrSubstitutor;

public abstract class Generator {
    private static final String TEMPLATE_TOKEN_PACKAGE_NAME = "package_name";
    private static final String TEMPLATE_TOKEN_RIBLET_NAME = "rib_name";
    private static final String TEMPLATE_TOKEN_RIBLET_NAME_TO_LOWER = "rib_name_to_lower";
    private final String packageName;
    private final String ribName;
    private final String templateString;
    private final boolean isKotlin;
    private final Map<String, String> templateValuesMap;

    public Generator(String packageName, String ribName, boolean isKotlin, String templateName) {
        this.packageName = packageName;
        this.ribName = ribName;
        this.isKotlin = isKotlin;
        this.templateValuesMap = new HashMap<String, String>();
        this.templateValuesMap.put(TEMPLATE_TOKEN_PACKAGE_NAME, packageName);
        this.templateValuesMap.put(TEMPLATE_TOKEN_RIBLET_NAME, ribName);
        this.templateValuesMap.put(TEMPLATE_TOKEN_RIBLET_NAME_TO_LOWER, ribName.toLowerCase());
        try {
            String[] resources;
            for (String resourceName : resources = this.getResourceListing(this.getClass(), "partials/")) {
                if (resourceName == null || resourceName.length() == 0) continue;
                InputStream resourceAsStream = Generator.class.getResourceAsStream("/partials/" + resourceName);
                String resourceContents = (String)Preconditions.checkNotNull((Object)CharStreams.toString((Readable)new InputStreamReader(resourceAsStream, Charsets.UTF_8)));
                this.templateValuesMap.put(String.format("partial: %s", resourceName), resourceContents);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        try {
            String resource = "/templates/java/" + templateName + ".java.template";
            if (isKotlin) {
                resource = "/templates/kotlin/" + templateName + ".kt.template";
            }
            InputStream resourceAsStream1 = Generator.class.getResourceAsStream(resource);
            this.templateString = (String)Preconditions.checkNotNull((Object)CharStreams.toString((Readable)new InputStreamReader(resourceAsStream1, Charsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String getClassName();

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getRibName() {
        return this.ribName;
    }

    public final String getFileExtension() {
        if (this.isKotlin) {
            return ".kt";
        }
        return ".java";
    }

    protected final Map<String, String> getTemplateValuesMap() {
        return this.templateValuesMap;
    }

    public final String generate() {
        StrSubstitutor substitutor = new StrSubstitutor(this.templateValuesMap);
        String newFile = substitutor.replace(this.templateString);
        System.out.println(newFile);
        return newFile;
    }

    String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }
}

