/*
 * Decompiled with CFR 0.152.
 */
package com.uber.presidio.intellij_plugin.action.rib;

import com.google.common.collect.ImmutableList;
import com.uber.presidio.intellij_plugin.generator.Generator;
import com.uber.presidio.intellij_plugin.generator.GeneratorPair;
import com.uber.presidio.intellij_plugin.generator.rib.BuilderGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.InteractorWithEmptyPresenterGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.InteractorWithEmptyPresenterTestGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.InteractorWithPresenterGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.InteractorWithPresenterTestGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.RouterGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.RouterTestGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.ViewBuilderGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.ViewGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.ViewRouterGenerator;
import com.uber.presidio.intellij_plugin.generator.rib.ViewRouterTestGenerator;
import java.util.List;

public final class Generators {
    private Generators() {
    }

    public static GeneratorPair getGeneratorsForRibWithPresenterAndView(String packageName, String ribName, boolean isKotlinSelected) {
        InteractorWithPresenterGenerator interactorGenerator = new InteractorWithPresenterGenerator(packageName, ribName, isKotlinSelected);
        ViewBuilderGenerator viewBuilderGenerator = new ViewBuilderGenerator(packageName, ribName, isKotlinSelected);
        ViewGenerator viewGenerator = new ViewGenerator(packageName, ribName, isKotlinSelected);
        ViewRouterGenerator viewRouterGenerator = new ViewRouterGenerator(packageName, ribName, isKotlinSelected);
        InteractorWithPresenterTestGenerator interactorWithPresenterTestGenerator = new InteractorWithPresenterTestGenerator(packageName, ribName, isKotlinSelected);
        ViewRouterTestGenerator viewRouterTestGenerator = new ViewRouterTestGenerator(packageName, ribName, isKotlinSelected);
        return new GeneratorPair((List<Generator>)ImmutableList.of((Object)interactorGenerator, (Object)viewBuilderGenerator, (Object)viewGenerator, (Object)viewRouterGenerator), (List<Generator>)ImmutableList.of((Object)interactorWithPresenterTestGenerator, (Object)viewRouterTestGenerator));
    }

    public static GeneratorPair getGeneratorsForRibWithoutPresenterAndView(String packageName, String ribName, boolean isKotlinSelected) {
        InteractorWithEmptyPresenterGenerator interactorGenerator = new InteractorWithEmptyPresenterGenerator(packageName, ribName, isKotlinSelected);
        BuilderGenerator builderGenerator = new BuilderGenerator(packageName, ribName, isKotlinSelected);
        RouterGenerator routerGenerator = new RouterGenerator(packageName, ribName, isKotlinSelected);
        InteractorWithEmptyPresenterTestGenerator interactorWithEmptyPresenterTestGenerator = new InteractorWithEmptyPresenterTestGenerator(packageName, ribName, isKotlinSelected);
        RouterTestGenerator routerTestGenerator = new RouterTestGenerator(packageName, ribName, isKotlinSelected);
        return new GeneratorPair((List<Generator>)ImmutableList.of((Object)interactorGenerator, (Object)builderGenerator, (Object)routerGenerator), (List<Generator>)ImmutableList.of((Object)interactorWithEmptyPresenterTestGenerator, (Object)routerTestGenerator));
    }
}

