import 'package:test/test.dart';
import 'package:mockito/mockito.dart';

import 'package:typesense/src/operations.dart';

import 'test_utils.mocks.dart';

void main() {
  late Operations operations;
  late MockApiCall mock;

  setUp(() {
    mock = MockApiCall();
    operations = Operations(mock);
  });

  group('Operations', () {
    test('has a resourcepath', () {
      expect(Operations.resourcepath, equals('/operations'));
    });
    test('createSnapshot() calls ApiCall.post()', () async {
      when(
        mock.post(
          '/operations/snapshot',
          queryParams: {
            'snapshot_path': '/tmp/typesense-data-snapshot',
          },
        ),
      ).thenAnswer((realInvocation) => Future.value({"success": true}));
      expect(await operations.createSnapshot('/tmp/typesense-data-snapshot'),
          equals({"success": true}));
    });
    test('initLeaderElection() calls ApiCall.post()', () async {
      when(
        mock.post(
          '/operations/vote',
        ),
      ).thenAnswer((realInvocation) => Future.value({"success": true}));
      expect(await operations.initLeaderElection(), equals({"success": true}));
    });
    test('toggleSlowRequestLog() calls ApiCall.post()', () async {
      when(
        mock.post('/config',
            bodyParameters: {'log-slow-requests-time-ms': 2000}),
      ).thenAnswer((realInvocation) => Future.value({"success": true}));
      expect(await operations.toggleSlowRequestLog(Duration(seconds: 2)),
          equals({"success": true}));
    });
  });
}
