import 'package:test/test.dart';
import 'package:mockito/mockito.dart';

import 'package:typesense/src/aliases.dart';

import 'test_utils.mocks.dart';

void main() {
  late Aliases aliases;
  late MockApiCall mock;

  setUp(() {
    mock = MockApiCall();
    aliases = Aliases(mock);
  });

  group('Aliases', () {
    test('has a resourcepath', () {
      expect(Aliases.resourcepath, equals('/aliases'));
    });
    test('upsert() calls ApiCall.put()', () async {
      when(
        mock.put('/aliases/companies',
            bodyParameters: {'collection_name': 'companies_june11'}),
      ).thenAnswer((realInvocation) => Future.value({
            "name": "companies",
            "collection_name": "companies_june11",
          }));
      expect(
          await aliases
              .upsert('companies', {'collection_name': 'companies_june11'}),
          equals({
            "name": "companies",
            "collection_name": "companies_june11",
          }));
    });
    test('retrieve() calls ApiCall.get()', () async {
      when(
        mock.get(
          '/aliases',
        ),
      ).thenAnswer((realInvocation) => Future.value({
            "aliases": [
              {"name": "companies", "collection_name": "companies_june11"},
              {"name": "employees", "collection_name": "employees_june11"}
            ]
          }));
      expect(
          await aliases.retrieve(),
          equals({
            "aliases": [
              {"name": "companies", "collection_name": "companies_june11"},
              {"name": "employees", "collection_name": "employees_june11"}
            ]
          }));
    });
  });
}
