<p align="center"><a href="https://typescene.dev"><img width="160" src="https://typescene.dev/assets/logo_detail.png"></a></p>

<p align="center">
  <a href="https://npmcharts.com/compare/typescene?minimal=true"><img src="https://img.shields.io/npm/dm/typescene.svg"></a>
  <a href="https://www.npmjs.com/package/typescene"><img src="https://img.shields.io/npm/v/typescene.svg"></a>
  <a href="https://www.npmjs.com/package/typescene"><img src="https://img.shields.io/npm/l/typescene.svg"></a>
</p>

<h1 align="center">Typescene</h1>

Typescene is a robust front end library written in TypeScript: strongly typed, no dependencies, no nonsense.

## Documentation

All documentation for Typescene can be found on the website: [https://typescene.dev/docs/](https://typescene.dev/docs/).

The online docs include an [overview](https://typescene.dev/docs/introduction) as well as other guides, and [reference documentation](https://typescene.dev/docs).

## Getting Started

If you're new to Typescene, make sure to check out these resources:

- Read up on the [Architecture overview](https://typescene.dev/docs/introduction)
- Follow along with the [Installation guide](https://typescene.dev/docs/installation)
- Use [`create-typescene-webapp`](https://github.com/typescene/create-typescene-webapp)
- For a complete example, check out [`typescene-realworld-example-app`](https://github.com/typescene/typescene-realworld-example-app)

## TODO

A few very important tasks are currently still pending:

- Tests, lots of 'em. The core package now comes with a test harness but only very few tests. These need to be added in some kind of structural way. Perhaps this can be organized using a Github project, opinions welcome on Twitter please.
- More tests for the `@typescene/webapp` package. These probably need an automated browser-based test framework. Opinions welcome on Twitter please.
- More examples for the reference documentation. These need to be added to the `typescene.github.io` repo on GitHub.
- More sample projects, along with articles on how they work. Before publishing these we're happy to review your own samples, please DM on Twitter.
- More prebuilt components (calendars, combo buttons, etc). See `typescene-treegrid` on GitHub for a full featured example.

## Questions and Issues

Have a question about Typescene? Get in touch with us on [Twitter](https://twitter.com/typescene) or post a question on [Stack Overflow](https://stackoverflow.com/).

If you think you’ve found a bug or other issue, please make sure you can reproduce the issue with a minimal example. Then post your issue here on [GitHub](https://github.com/typescene/typescene/issues).

## Changes

The main Typescene repository uses tagged [Releases](https://github.com/typescene/typescene/releases) to communicate changes between versions. Make sure you stay updated by following [Typescene](https://twitter.com/typescene) on Twitter!

## FAQ

**Q:** Why another JavaScript framework? \
**A:** Typescene is different in a number of ways. Read [this article](https://typescene.dev/docs/introduction/goals) for a detailed overview of Typescene's design goals.

**Q:** Should I use Typescene for my next project? \
**A:** Sure! Typescene works best for desktop-style and/or mobile Web apps. As always, read the [docs](https://typescene.dev/docs) first. If you need something for your blog or other online content, then other frameworks might suit your needs better.

**Q:** How do I get started with Typescene? \
**A:** Typescene is distributed through NPM. Read through the guides provided on the Typescene [docs website](https://typescene.dev/docs) and follow along to create your first project.

## Reach Out!

Find Typescene on [Twitter](https://twitter.com/typescene) for the latest news, and please consider giving the repository a ⭐️ star on [GitHub](https://github.com/typescene/typescene).

## Support

Your support is greatly appreciated. At this stage, we mostly need to get the word out. If you like Typescene, tell all your friends and colleagues!

For contributions in the form of bug fixes and changes, feel free to use [Pull Requests](https://github.com/typescene/typescene/pulls) or send a DM on Twitter to discuss how best to approach your issue.

## License

The Typescene source code is licensed under the MIT license.
