# type: ignore
import re
import subprocess

import setuptools

version = re.search(
    r'^__version__\s*=\s*"(.*)"',
    open("./rawsec_cli/__init__.py").read(),
    re.M,
).group(
    1,
)

try:
    commit = subprocess.check_output("git rev-parse --verify HEAD", shell=True)
except subprocess.CalledProcessError as e:
    print("Exception on process, rc=", e.returncode, "output=", e.output)
    commit = b"commit name not found"

with open("./rawsec_cli/__init__.py", "w") as f:
    f.write(
        f'# autogenerated\n__version__ = "{str(version)}"\n__commit__ = "{str(commit, "utf-8").strip()}"\n',
    )
f.close()

with open("README.md") as f:
    long_description = f.read()
f.close()

with open("dev-requirements.txt") as f:
    dev_requires = [line.strip() for line in f]
    f.close()

with open("docs/requirements.txt") as f:
    docs_requires = [line.strip() for line in f]
    f.close()
with open("requirements.txt") as f:
    install_requires = [line.strip() for line in f]
    f.close()


setuptools.setup(
    name="rawsec-cli",
    version=version,
    author="mBouamama",
    author_email="matthieubouamama@gmail.com",
    description="Cli for searching tools & resources on rawsec's CyberSecrity Inventory",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/mBouamama/rawsec_cli",
    install_requires=install_requires,
    entry_points={"console_scripts": ["rawsec-cli = rawsec_cli.cli.cli:cli"]},
    extras_require={"dev": dev_requires, "docs": docs_requires},
    packages=setuptools.find_packages(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Topic :: Security",
        "Topic :: Internet :: WWW/HTTP",
    ],
    python_requires=">=3.7",
)
